/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.document;

import java.util.List;
import net.refractions.udig.catalog.document.IAbstractAttachmentSource;
import net.refractions.udig.catalog.document.IDocument;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IDocumentSource
extends IAbstractAttachmentSource {
    public List<IDocument> getDocuments(IProgressMonitor var1);

    public IDocument add(DocumentInfo var1, IProgressMonitor var2);

    public List<IDocument> add(List<DocumentInfo> var1, IProgressMonitor var2);

    public boolean update(IDocument var1, DocumentInfo var2, IProgressMonitor var3);

    public boolean remove(IDocument var1, IProgressMonitor var2);

    public boolean remove(List<IDocument> var1, IProgressMonitor var2);

    public static class DocumentInfo {
        private String label;
        private String description;
        private String info;
        private IDocument.Type type;
        private IDocument.ContentType contentType;
        private boolean isTemplate;
        public static final String DELIMITER = "|~|";
        public static final String DELIMITER_REGEX = "\\|~\\|";

        public DocumentInfo(String attachmentInfo) {
            this.fromString(attachmentInfo);
        }

        public DocumentInfo(String label, String description, String info, IDocument.ContentType contentType, boolean isTemplate, IDocument.Type type) {
            this.label = label;
            this.description = description;
            this.info = info;
            this.type = type;
            this.contentType = contentType;
            this.isTemplate = isTemplate;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public IDocument.Type getType() {
            return this.type;
        }

        public void setType(IDocument.Type type) {
            this.type = type;
        }

        public IDocument.ContentType getContentType() {
            return this.contentType;
        }

        public void setContentType(IDocument.ContentType contentType) {
            this.contentType = contentType;
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        public void setTemplate(boolean isTemplate) {
            this.isTemplate = isTemplate;
        }

        private void fromString(String attachmentInfo) {
            String[] defValues = attachmentInfo.split(DELIMITER_REGEX);
            this.info = this.getCleanValue(defValues[0]);
            this.type = IDocument.Type.valueOf(defValues[1]);
            this.contentType = IDocument.ContentType.valueOf(defValues[2]);
            this.label = defValues.length > 2 ? this.getCleanValue(defValues[3]) : null;
            this.description = defValues.length > 3 ? this.getCleanValue(defValues[4]) : null;
            this.isTemplate = defValues.length > 4 ? Boolean.parseBoolean(defValues[5]) : false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.info != null) {
                sb.append(this.info);
            }
            sb.append(DELIMITER);
            if (this.type != null) {
                sb.append((Object)this.type);
            }
            sb.append(DELIMITER);
            if (this.contentType != null) {
                sb.append((Object)this.contentType);
            }
            sb.append(DELIMITER);
            if (this.label != null) {
                sb.append(this.label);
            }
            sb.append(DELIMITER);
            if (this.description != null) {
                sb.append(this.description);
            }
            sb.append(DELIMITER);
            sb.append(Boolean.toString(this.isTemplate));
            return sb.toString();
        }

        private String getCleanValue(String text) {
            String cleanText;
            if (text != null && (cleanText = text.trim()).length() > 0) {
                return cleanText;
            }
            return null;
        }
    }
}

