/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.core.internal.CorePlugin;

public class URLUtils {
    public static boolean urlEquals(URL url1, URL url2, boolean stripRef) {
        boolean sameRef;
        if (url1 == null) {
            return url2 == null;
        }
        if (url2 == null) {
            return false;
        }
        boolean sameProtocol = url2.getProtocol().equalsIgnoreCase(url1.getProtocol());
        if ("file".equals(url2.getProtocol()) && "file".equals(url1.getProtocol())) {
            File file1 = URLUtils.urlToFile(url1);
            File file2 = URLUtils.urlToFile(url2);
            try {
                if (file1 != null && file2 != null) {
                    String path1 = file1.getCanonicalPath();
                    path1 = path1.replaceAll("\\\\", "/");
                    if (file1.isDirectory() && !path1.endsWith("/")) {
                        path1 = String.valueOf(path1) + "/";
                    }
                    String path2 = file2.getCanonicalPath();
                    path2 = path2.replaceAll("\\\\", "/");
                    if (file2.isDirectory() && !path2.endsWith("/")) {
                        path2 = String.valueOf(path2) + "/";
                    }
                    if (stripRef) {
                        if (url1.getRef() != null) {
                            path1 = path1.substring(0, path1.length() - url1.getRef().length() - 1);
                        }
                        if (url2.getRef() != null) {
                            path2 = path2.substring(0, path2.length() - url2.getRef().length() - 1);
                        }
                    }
                    return path1.equals(path2);
                }
            }
            catch (IOException e) {
                CatalogPlugin.log("Unable to compare file URLS " + file1 + " and " + file2 + " files because of an exception.", e);
            }
        }
        boolean sameHost = url2.getHost() == null || "".equals(url2.getHost()) || url2.getHost() != null && url2.getHost().equalsIgnoreCase(url1.getHost());
        boolean samePath = url2.getPath() == null || "".equals(url2.getPath()) || url2.getPath() != null && url2.getPath().equalsIgnoreCase(url1.getPath());
        boolean sameQuery = url2.getQuery() == null || "".equals(url2.getQuery()) || url2.getQuery() != null && url2.getQuery().equalsIgnoreCase(url1.getQuery());
        boolean sameAuthority = url2.getAuthority() == null || "".equals(url2.getAuthority()) || url2.getAuthority() != null && url2.getAuthority().equalsIgnoreCase(url1.getAuthority());
        boolean bl = sameRef = !stripRef && (url2.getRef() == null || "".equals(url2.getRef()) || url2.getRef() != null && url2.getRef().equalsIgnoreCase(url1.getRef()));
        if (sameProtocol && sameHost && samePath && sameQuery && sameAuthority && sameRef) {
            return true;
        }
        String string1 = URLUtils.urlToString(url1, stripRef).replace("%20", " ").toLowerCase();
        String string2 = URLUtils.urlToString(url2, stripRef).replace("%20", " ").toLowerCase();
        if (stripRef) {
            return string1.startsWith(string2) || string2.startsWith(string1);
        }
        return string1.equalsIgnoreCase(string2);
    }

    public static String urlToString(URL url, boolean ignoreRef) {
        String string = url.toExternalForm();
        if (ignoreRef && string.contains("#")) {
            string = string.substring(0, string.lastIndexOf(35));
        }
        if ((string = string.replaceAll("\\\\", "/")).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("file:")) {
            string = string.replaceAll("/+", "/");
        }
        return string;
    }

    public static URL toRelativePath(File reference, URL destination) {
        reference.exists();
        if (!destination.getProtocol().equalsIgnoreCase("file") || destination.getQuery() != null || destination.getRef() != null) {
            return destination;
        }
        try {
            File destinationFile = URLUtils.urlToFile(destination).getAbsoluteFile();
            File destDir = destinationFile.isFile() ? destinationFile.getParentFile() : destinationFile;
            File absReference = reference.getAbsoluteFile();
            if (absReference.isFile()) {
                absReference = absReference.getParentFile().getAbsoluteFile();
            }
            if (destDir.equals(absReference)) {
                if (destinationFile.isFile()) {
                    return new URL("file:/./" + destinationFile.getName());
                }
                return new URL("file:/./");
            }
            if (!destinationFile.getPath().startsWith(absReference.getPath())) {
                return destination;
            }
            int length = absReference.getPath().length();
            String frag = destinationFile.getPath().substring(length + 1);
            String dirPath = "file:/./" + frag.replaceAll("\\\\", "/");
            return new URL(dirPath);
        }
        catch (Exception exception) {
            return destination;
        }
    }

    public static String getPrefix(File file) {
        File compare;
        if (!file.isAbsolute()) {
            return null;
        }
        try {
            compare = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            compare = file.getAbsoluteFile();
        }
        while (compare.getParent() != null) {
            compare = compare.getParentFile();
        }
        String root = compare.getPath();
        String platform = System.getProperty("os.name");
        if (platform.toUpperCase().indexOf("WINDOWS") != -1) {
            if (root.length() > 2 && root.charAt(1) == ':') {
                return root.substring(0, 2);
            }
            if (root.startsWith("\\\\")) {
                return root;
            }
        } else {
            if (platform.toUpperCase().indexOf("MAC") != -1) {
                return null;
            }
            if (root.startsWith("/")) {
                return "/";
            }
        }
        return null;
    }

    public static URL constructURL(File base, String urlSpec) throws MalformedURLException {
        String substring;
        URL url = new URL(null, urlSpec, CorePlugin.RELAXED_HANDLER);
        if (!urlSpec.startsWith("file:/") || urlSpec.contains("?") || urlSpec.contains("#")) {
            return url;
        }
        File file = URLUtils.urlToFile(url);
        if (file.exists()) {
            try {
                if (file.getCanonicalPath().equals(file.getPath())) {
                    return url;
                }
            }
            catch (IOException iOException) {}
        }
        if ((substring = urlSpec.substring(5)).startsWith("//")) {
            return url;
        }
        try {
            File tmp = new File(base.getParentFile(), file.getPath());
            if (tmp.exists()) {
                File absoluteFile = tmp.getCanonicalFile();
                URL url2 = absoluteFile.toURI().toURL();
                return url2;
            }
            if (substring.charAt(0) == base.getCanonicalPath().charAt(0)) {
                return url;
            }
        }
        catch (IOException iOException) {
            return url;
        }
        file = new File(base.getParentFile(), substring);
        try {
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.toURI().toURL();
        }
        catch (IOException iOException) {
            return url;
        }
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        String simplePrefix = "file:/";
        String standardPrefix = String.valueOf(simplePrefix) + "/";
        if (string.startsWith(standardPrefix)) {
            String path2 = string.substring(standardPrefix.length());
            path3 = path2.replace("%20", " ");
        } else if (string.startsWith(simplePrefix)) {
            String path2 = string.substring(simplePrefix.length() - 1);
            path3 = path2.replace("%20", " ");
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                try {
                    return new URL("file:/" + file.getCanonicalPath().replace('\\', '/'));
                }
                catch (MalformedURLException malformedURLException3) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
    }

    public static String cleanFilename(String typeName) {
        StringBuffer fix = new StringBuffer(typeName);
        int i = 0;
        while (i < fix.length()) {
            char c = fix.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                fix.setCharAt(i, '_');
            }
            ++i;
        }
        return fix.toString();
    }

    public static File[] findRelatedFiles(File baseFile, final String ... optionalExtensions) {
        int index = baseFile.getName().indexOf(46);
        final String base = index > 0 ? baseFile.getName().substring(0, index) : baseFile.getName();
        File[] files = baseFile.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lower = name.toLowerCase();
                if (name.startsWith(base)) {
                    String[] stringArray = optionalExtensions;
                    int n = optionalExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        String ext = string.toLowerCase();
                        if (lower.endsWith(ext) && lower.equalsIgnoreCase(String.valueOf(base) + ext)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        });
        if (files == null) {
            return new File[0];
        }
        return files;
    }
}

