/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ServiceParameterPersister {
    private static final String COLON_ENCODING = "@col@";
    private static final String TYPE_QUALIFIER = "@type@";
    private static final String PROPERTIES_KEY = "_properties";
    private static final String TITLE_KEY = "title";
    private static final String CHILD_PREFIX = "child_";
    private static final String VALUE_ID = "value";
    private static final String TYPE_ID = "type";
    private static final String ENCODING = "UTF-8";
    protected final ICatalog localCatalog;
    protected final IServiceFactory serviceFactory;
    private File reference;

    public ServiceParameterPersister(ICatalog localCatalog, IServiceFactory serviceFactory) {
        this(localCatalog, serviceFactory, null);
    }

    public ServiceParameterPersister(ICatalog localCatalog, IServiceFactory serviceFactory, File reference) {
        this.localCatalog = localCatalog;
        this.serviceFactory = serviceFactory;
        this.reference = reference;
    }

    public void restore(Preferences node) {
        try {
            String[] stringArray = node.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id != null) {
                    try {
                        Preferences servicePref = node.node(id);
                        ID url = this.decodeID(id);
                        HashMap<String, Serializable> connectionParams = new HashMap<String, Serializable>();
                        String[] nodes = servicePref.childrenNames();
                        HashMap<ID, Map<String, Serializable>> resourcePropertyMap = new HashMap<ID, Map<String, Serializable>>();
                        Map<String, Serializable> properties = new HashMap<String, Serializable>();
                        String[] stringArray2 = nodes;
                        int n3 = nodes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String childName = stringArray2[n4];
                            if (childName != null) {
                                if (PROPERTIES_KEY.equals(childName)) {
                                    Preferences propertiesPref = servicePref.node(PROPERTIES_KEY);
                                    propertiesPref.flush();
                                    properties = this.restoreProperties(propertiesPref);
                                } else if (childName.startsWith(CHILD_PREFIX)) {
                                    String childIDEncoded = childName.substring(CHILD_PREFIX.length());
                                    if (childIDEncoded.length() != 0) {
                                        ID childID = this.decodeID(childIDEncoded);
                                        Preferences childPref = servicePref.node(childName);
                                        childPref.flush();
                                        Map<String, Serializable> childProperties = this.restoreProperties(childPref);
                                        resourcePropertyMap.put(childID, childProperties);
                                    }
                                } else {
                                    this.mapAsObject(servicePref, connectionParams, childName);
                                }
                            }
                            ++n4;
                        }
                        this.locateService(url, connectionParams, properties, resourcePropertyMap);
                    }
                    catch (Throwable t) {
                        CatalogPlugin.log(null, new Exception(t));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            CatalogPlugin.log(null, new Exception(t));
        }
    }

    private String encodeID(ID id) {
        String str;
        try {
            if (id.isChild()) {
                return URLEncoder.encode(id.toString(), ENCODING);
            }
            if (id.isFile()) {
                String path = id.toFile().getAbsolutePath();
                path = path.replace(":", COLON_ENCODING);
                str = URLEncoder.encode(path, ENCODING);
            } else {
                str = URLEncoder.encode(id.toString(), ENCODING);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            str = id.toString();
        }
        if (id.getTypeQualifier() != null) {
            try {
                str = String.valueOf(str) + TYPE_QUALIFIER + URLEncoder.encode(id.getTypeQualifier(), ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                str = String.valueOf(str) + TYPE_QUALIFIER + id.getTypeQualifier();
            }
        }
        return str;
    }

    private ID decodeID(String encodedId) {
        ID id;
        try {
            String decodeId = URLDecoder.decode(encodedId, ENCODING);
            String[] parts = decodeId.split(TYPE_QUALIFIER);
            String qualifier = null;
            if (parts.length == 2) {
                qualifier = parts[1];
            }
            try {
                new URL(null, parts[0], CorePlugin.RELAXED_HANDLER);
                id = new ID(parts[0], qualifier);
            }
            catch (MalformedURLException malformedURLException) {
                String path = parts[0].replaceAll(COLON_ENCODING, ":");
                id = new ID(new File(path), qualifier);
            }
        }
        catch (UnsupportedEncodingException e) {
            CatalogPlugin.log("Could not code preferences URL", e);
            throw new RuntimeException(e);
        }
        return id;
    }

    protected void locateService(ID targetID, Map<String, Serializable> connectionParameters, Map<String, Serializable> properties, Map<ID, Map<String, Serializable>> resourcePropertyMap) {
        block14: {
            IService found = this.localCatalog.getById(IService.class, targetID, null);
            List<IService> newServices = this.serviceFactory.createService(connectionParameters);
            try {
                if (!newServices.isEmpty()) {
                    Iterator<IService> iter = newServices.iterator();
                    while (iter.hasNext()) {
                        IService service = iter.next();
                        found = this.localCatalog.getById(IService.class, service.getID(), null);
                        if (found != null && found.getID().equals(targetID)) {
                            service = found;
                        } else if (service.getID().equals(targetID)) {
                            this.localCatalog.add(service);
                            iter.remove();
                        }
                        if (properties != null && !properties.isEmpty()) {
                            try {
                                service.getPersistentProperties().putAll(properties);
                            }
                            catch (Exception exception) {}
                        }
                        if (resourcePropertyMap == null || resourcePropertyMap.isEmpty()) continue;
                        for (Map.Entry<ID, Map<String, Serializable>> entry : resourcePropertyMap.entrySet()) {
                            try {
                                ID childID = entry.getKey();
                                Map<String, Serializable> entryProperties = entry.getValue();
                                if (entryProperties == null || entryProperties.isEmpty()) continue;
                                Map<String, Serializable> resourceProperties = service.getPersistentProperties(childID);
                                resourceProperties.putAll(entryProperties);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    break block14;
                }
                CatalogPlugin.log("Nothing was able to be loaded from saved preferences: " + connectionParameters, null);
            }
            finally {
                this.serviceFactory.dispose(newServices, null);
            }
        }
    }

    private void mapAsObject(Preferences servicePreferenceNode, Map<String, Serializable> connectionParams, String currentKey) {
        Preferences paramNode = servicePreferenceNode.node(currentKey);
        String value = paramNode.get(VALUE_ID, null);
        try {
            value = URLDecoder.decode(value, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            CatalogPlugin.log("error decoding value, using undecoded value", e);
        }
        String type = paramNode.get(TYPE_ID, null);
        Serializable obj = this.toObject(value, type);
        connectionParams.put(currentKey, obj);
    }

    private Serializable toObject(String txt, String type) {
        try {
            Class<?> clazz = Class.forName(type);
            if (this.reference != null && (URL.class.isAssignableFrom(clazz) || File.class.isAssignableFrom(clazz))) {
                try {
                    URL result = URLUtils.constructURL(this.reference, txt);
                    if (URL.class.isAssignableFrom(clazz)) {
                        return result;
                    }
                    return new File(result.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    CatalogPlugin.log(String.valueOf(type) + " was not able to use as a URL so we're putting it in to the parameters as a String", null);
                    return txt;
                }
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object object = constructor.newInstance(txt);
                return (Serializable)object;
            }
            catch (Throwable t) {
                try {
                    Method[] methods = clazz.getMethods();
                    Method bestMatch = this.findBestMatch(methods);
                    if (bestMatch != null) {
                        Object obj = clazz.newInstance();
                        bestMatch.invoke(obj, txt);
                        return (Serializable)obj;
                    }
                }
                catch (Throwable t2) {
                    CatalogPlugin.log("error that occurred when trying use construction with string: " + type + " value= " + txt, t);
                    CatalogPlugin.log("error that occurred when use a setter: " + type + " value= " + txt, t2);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            CatalogPlugin.log(String.valueOf(type) + " was not able find declared type so we're putting it in to the parameters as a String", null);
        }
        return txt;
    }

    /*
     * Unable to fully structure code
     */
    private Method findBestMatch(Method[] methods) {
        bestMatch = null;
        var6_3 = methods;
        var5_4 = methods.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block6: {
                method = var6_3[var4_5];
                methodParams = method.getParameterTypes();
                if (methodParams.length != 1 || !methodParams[0].isAssignableFrom(String.class)) break block6;
                if (!method.getName().startsWith("parse")) ** GOTO lbl-1000
                if (bestMatch == null) {
                    bestMatch = method;
                } else if (bestMatch.getName().startsWith("set")) {
                    bestMatch = method;
                } else if (method.getName().startsWith("set") && bestMatch == null) {
                    bestMatch = method;
                }
            }
            ++var4_5;
        }
        return bestMatch;
    }

    public void store(IProgressMonitor monitor, Preferences node, Collection<? extends IResolve> resolves) throws BackingStoreException, IOException {
        this.clearPreferences(node);
        for (IResolve iResolve : resolves) {
            try {
                IPreferenceStore preferenceStore = CatalogPlugin.getDefault().getPreferenceStore();
                if (!preferenceStore.getBoolean("SaveTemporaryDataTypes") && iResolve.canResolve(ITransientResolve.class)) continue;
                IService service = null;
                if (iResolve instanceof IGeoResource) {
                    service = ((IGeoResource)iResolve).service(monitor);
                } else if (iResolve instanceof IService) {
                    service = (IService)iResolve;
                }
                if (service == null) continue;
                ID serviceID = service.getID();
                String id = this.encodeID(serviceID);
                Preferences serviceNode = node.node(id);
                for (Map.Entry<String, Serializable> entry : service.getConnectionParams().entrySet()) {
                    String value;
                    File file;
                    URL old;
                    String string = entry.getKey().toString();
                    Serializable object = entry.getValue();
                    URL url = null;
                    if (object instanceof URL) {
                        url = (URL)object;
                    } else if (object instanceof File && !(old = (file = (File)object).toURI().toURL()).equals(url = file.toURI().toURL())) {
                        CatalogPlugin.trace("old url:" + old, null);
                        CatalogPlugin.trace("new url:" + url, null);
                    }
                    if (this.reference != null && url != null) {
                        URL relativeURL = URLUtils.toRelativePath(this.reference, url);
                        value = URLUtils.urlToString(relativeURL, true);
                    } else {
                        String string2 = value = object == null ? null : object.toString();
                    }
                    if (value == null) continue;
                    value = URLEncoder.encode(value, ENCODING);
                    Preferences paramNode = serviceNode.node(string);
                    paramNode.put(VALUE_ID, value);
                    paramNode.put(TYPE_ID, object.getClass().getName());
                }
                try {
                    Map<String, Serializable> persistentProperties = service.getPersistentProperties();
                    Preferences propertiesNode = serviceNode.node(PROPERTIES_KEY);
                    this.storeProperties(propertiesNode, persistentProperties);
                    propertiesNode.flush();
                }
                catch (Exception e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
                boolean resourcePropertiesSaved = false;
                if (service.getStatus() == IResolve.Status.CONNECTED) {
                    try {
                        List<? extends IGeoResource> resources = service.resources(null);
                        if (resources != null && !resources.isEmpty()) {
                            for (IGeoResource iGeoResource : resources) {
                                ID childID = iGeoResource.getID();
                                Map<String, Serializable> childProperties = service.getPersistentProperties(childID);
                                String encodeID = this.encodeID(childID);
                                String childKey = CHILD_PREFIX + encodeID;
                                Preferences childNode = serviceNode.node(childKey);
                                this.storeProperties(childNode, childProperties);
                                childNode.flush();
                            }
                        }
                        resourcePropertiesSaved = true;
                    }
                    catch (Exception e) {
                        CatalogPlugin.log("Unable to access resource list for " + service.getID() + ":" + e, e);
                    }
                }
                if (!resourcePropertiesSaved) {
                    for (Map.Entry<ID, Map<String, Serializable>> entry : service.resourceProperties.entrySet()) {
                        Map<String, Serializable> childProperties = entry.getValue();
                        String encodeID = this.encodeID(entry.getKey());
                        String childKey = CHILD_PREFIX + encodeID;
                        Preferences childNode = serviceNode.node(childKey);
                        this.storeProperties(childNode, childProperties);
                        childNode.flush();
                    }
                }
                if (serviceNode.keys().length > 0) {
                    serviceNode.flush();
                }
                monitor.worked(1);
            }
            catch (RuntimeException e) {
                CatalogPlugin.log("Error storing: " + iResolve.getIdentifier(), e);
            }
        }
        node.flush();
    }

    private void storeProperties(Preferences prefs, Map<String, Serializable> properties) {
        for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
            String KEY = entry.getKey().toString();
            Serializable object = entry.getValue();
            String txt = object == null ? null : object.toString();
            if (txt == null) continue;
            try {
                txt = URLEncoder.encode(txt, ENCODING);
                Preferences paramNode = prefs.node(KEY);
                paramNode.put(VALUE_ID, txt);
                paramNode.put(TYPE_ID, object.getClass().getName());
                paramNode.flush();
            }
            catch (Exception e) {
                CatalogPlugin.trace("Could not encode " + KEY + " - " + e, e);
            }
        }
    }

    private Map<String, Serializable> restoreProperties(Preferences preference) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            String[] keys = preference.childrenNames();
            int j = 0;
            while (j < keys.length) {
                String KEY = keys[j];
                Preferences paramNode = preference.node(KEY);
                String txt = paramNode.get(VALUE_ID, null);
                if (txt != null) {
                    try {
                        txt = URLDecoder.decode(txt, ENCODING);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String type = paramNode.get(TYPE_ID, null);
                    Serializable value = this.toObject(txt, type);
                    map.put(KEY, value);
                }
                ++j;
            }
        }
        catch (BackingStoreException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return map;
    }

    private void clearPreferences(Preferences node) throws BackingStoreException {
        String[] stringArray = node.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Preferences child = node.node(name);
            child.removeNode();
            ++n2;
        }
    }
}

