/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public abstract class RemotePreferenceStore
implements IPersistentPreferenceStore {
    private Set<IPropertyChangeListener> listeners = new CopyOnWriteArraySet<IPropertyChangeListener>();
    private Map<String, String> localProperties;
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private boolean dirty = false;
    private boolean ready = false;

    protected abstract String getValue(String var1);

    public abstract void putValue(String var1, String var2);

    public abstract boolean isKey(String var1);

    public RemotePreferenceStore() {
        this.localProperties = new HashMap<String, String>();
    }

    protected void load() {
        String[] names = this.preferenceNames();
        int i = 0;
        while (i < names.length) {
            String value = this.getValue(names[i]);
            if (value != null) {
                this.localProperties.put(names[i], value);
            }
            ++i;
        }
        this.ready = true;
    }

    public void save() throws IOException {
        String[] names = this.preferenceNames();
        int i = 0;
        while (i < names.length) {
            String remoteValue = this.getValue(names[i]);
            String localValue = this.toString(this.localProperties.get(names[i]));
            String defaultValue = this.toString(this.defaultProperties.get(names[i]));
            if (localValue == null) {
                if (defaultValue == null) {
                    throw new IOException("Default property value not defined");
                }
                this.putValue(names[i], defaultValue);
            } else if (remoteValue == null) {
                this.putValue(names[i], localValue);
            } else if (remoteValue.equals(localValue)) {
                this.putValue(names[i], localValue);
            }
            ++i;
        }
        this.dirty = false;
    }

    private String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return "true";
            }
            return "false";
        }
        return String.valueOf(object);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        if (this.localProperties.containsKey(name) || this.defaultProperties.containsKey(name)) {
            return true;
        }
        String remoteValue = this.getValue(name);
        return remoteValue != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (oldValue == null || !oldValue.equals(newValue)) {
            final PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            for (final IPropertyChangeListener l : this.listeners) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError")){

                    public void run() {
                        l.propertyChange(pe);
                    }
                });
            }
        }
    }

    public boolean getBoolean(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getBoolean(this.localProperties, name);
    }

    private boolean getBoolean(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean getDefaultBoolean(String name) {
        return this.getBoolean(this.defaultProperties, name);
    }

    public double getDefaultDouble(String name) {
        return this.getDouble(this.defaultProperties, name);
    }

    private double getDouble(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0.0;
        }
        double ival = 0.0;
        try {
            ival = new Double(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public float getDefaultFloat(String name) {
        return this.getFloat(this.defaultProperties, name);
    }

    private float getFloat(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0.0f;
        }
        float ival = 0.0f;
        try {
            ival = new Float(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public int getDefaultInt(String name) {
        return this.getInt(this.defaultProperties, name);
    }

    private int getInt(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0;
        }
        int ival = 0;
        try {
            ival = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public long getDefaultLong(String name) {
        return this.getLong(this.defaultProperties, name);
    }

    private long getLong(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return 0L;
        }
        long ival = 0L;
        try {
            ival = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public String getDefaultString(String name) {
        return this.getString(this.defaultProperties, name);
    }

    private String getString(Map<String, String> p, String name) {
        String value;
        String string = value = p != null ? p.get(name) : null;
        if (value == null) {
            return "";
        }
        return value;
    }

    public double getDouble(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getDouble(this.localProperties, name);
    }

    public float getFloat(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getFloat(this.localProperties, name);
    }

    public int getInt(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getInt(this.localProperties, name);
    }

    public long getLong(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getLong(this.localProperties, name);
    }

    public String getString(String name) {
        if (!this.ready) {
            this.load();
        }
        return this.getString(this.localProperties, name);
    }

    public boolean isDefault(String name) {
        return !this.localProperties.containsKey(name) && this.defaultProperties.containsKey(name);
    }

    public boolean needsSaving() {
        if (!this.ready) {
            this.load();
        }
        return this.dirty;
    }

    public String[] preferenceNames() {
        Set<String> names = this.defaultProperties.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setDefault(String name, double value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, float value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, int value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, long value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, String value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setValue(this.defaultProperties, name, value);
    }

    private void setValue(Map<String, String> p, String name, double value) {
        Assert.isTrue((p != null && name != null ? 1 : 0) != 0);
        p.put(name, this.toString(new Double(value)));
    }

    private void setValue(Map<String, String> p, String name, float value) {
        Assert.isTrue((p != null && name != null ? 1 : 0) != 0);
        p.put(name, this.toString(new Float(value)));
    }

    private void setValue(Map<String, String> p, String name, int value) {
        Assert.isTrue((p != null && name != null ? 1 : 0) != 0);
        p.put(name, this.toString(value));
    }

    private void setValue(Map<String, String> p, String name, long value) {
        Assert.isTrue((p != null && name != null ? 1 : 0) != 0);
        p.put(name, this.toString(value));
    }

    private void setValue(Map<String, String> p, String name, String value) {
        Assert.isTrue((p != null && name != null && value != null ? 1 : 0) != 0);
        p.put(name, value);
    }

    private void setValue(Map<String, String> p, String name, boolean value) {
        Assert.isTrue((p != null && name != null ? 1 : 0) != 0);
        p.put(name, this.toString(value));
    }

    public void setToDefault(String name) {
        String oldValue = this.localProperties.get(name);
        this.localProperties.remove(name);
        this.dirty = true;
        String newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Double(oldValue), new Double(value));
        }
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Float(oldValue), new Float(value));
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.setValue(this.localProperties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }
}

