/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.ui.ErrorManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class IService
implements IResolve {
    protected static IServiceInfo INFO_UNAVAILABLE = new IServiceInfo();
    protected boolean isDisposed = false;
    private Map<String, Serializable> properties = Collections.synchronizedMap(new HashMap());
    Map<ID, Map<String, Serializable>> resourceProperties = Collections.synchronizedMap(new HashMap());
    protected volatile IServiceInfo info = null;

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            monitor.done();
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(ICatalog.class)) {
            return adaptee.cast(this.parent(monitor));
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve(this, adaptee)) {
            return rm.resolve(this, adaptee, monitor);
        }
        return null;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IServiceInfo.class) || adaptee.isAssignableFrom(List.class) || adaptee.isAssignableFrom(ICatalog.class) || CatalogPlugin.getDefault().getResolveManager().canResolve(this, adaptee));
    }

    @Override
    public ICatalog parent(IProgressMonitor monitor) {
        ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
        if (localCatalog.getById(IService.class, this.getID(), monitor) != null) {
            return localCatalog;
        }
        return null;
    }

    public abstract List<? extends IGeoResource> resources(IProgressMonitor var1) throws IOException;

    @Override
    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        ArrayList<IResolve> resolves = new ArrayList<IResolve>(this.resources(monitor));
        return resolves;
    }

    protected abstract IServiceInfo createInfo(IProgressMonitor var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        if (this.isDisposed) {
            return null;
        }
        if (this.info == null) {
            IService iService = this;
            synchronized (iService) {
                if (this.info == null) {
                    if (Display.getCurrent() != null) {
                        throw new IllegalStateException("Lookup of getInfo not available from the display thread");
                    }
                    this.info = this.createInfo(monitor);
                    if (this.info == null) {
                        this.info = INFO_UNAVAILABLE;
                    }
                }
            }
        }
        if (this.info == INFO_UNAVAILABLE) {
            return null;
        }
        return this.info;
    }

    @Override
    public ID getID() {
        return new ID(this.getIdentifier());
    }

    public abstract Map<String, Serializable> getConnectionParams();

    public Map<String, Serializable> getPersistentProperties() {
        return this.properties;
    }

    public synchronized Map<String, Serializable> getPersistentProperties(ID child) {
        if (this.resourceProperties.containsKey(child)) {
            Map<String, Serializable> properties = this.resourceProperties.get(child);
            return properties;
        }
        Map<String, Serializable> properties = Collections.synchronizedMap(new HashMap());
        this.resourceProperties.put(child, properties);
        return properties;
    }

    @Override
    public String getTitle() {
        String title = null;
        if (this.info != null) {
            title = this.info.getTitle();
            this.getPersistentProperties().put("title", (Serializable)((Object)title));
        }
        if (title == null) {
            Serializable s = this.properties.get("title");
            title = s != null ? s.toString() : null;
        }
        return title;
    }

    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof IService) {
            IService service = (IService)obj;
            if (this.getID() != null && service.getID() != null) {
                return this.getID().equals(service.getID());
            }
        }
        return false;
    }

    public final int hashCode() {
        int value = 31;
        if (this.getID() != null) {
            value += 31 + this.getID().hashCode();
        }
        return value += 31 + this.getClass().getName().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getSimpleName();
        buf.append(classname);
        buf.append("(");
        ID ref = this.getID();
        buf.append(ref.labelServer());
        buf.append(")");
        return buf.toString();
    }

    @Override
    public IResolve.Status getStatus() {
        if (this.isDisposed) {
            return IResolve.Status.DISPOSED;
        }
        if (this.getMessage() != null) {
            return IResolve.Status.BROKEN;
        }
        return IResolve.Status.NOTCONNECTED;
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed) {
            CatalogPlugin.trace(String.valueOf(this.getClass().getName()) + " being cleaned up by fianlize, without prior call to dispose", null);
            this.dispose((IProgressMonitor)new NullProgressMonitor());
        }
        super.finalize();
    }

    @Override
    public void dispose(IProgressMonitor monitor) {
        if (this.isDisposed) {
            throw new IllegalStateException("IService.dispose() called, for the second time");
        }
        monitor.beginTask(Messages.IService_dispose, 100);
        if (this.getStatus() == IResolve.Status.CONNECTED) {
            try {
                List<IResolve> members = this.members((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                int steps = (int)(99.0 / (double)members.size());
                for (IResolve resolve : members) {
                    try {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, steps);
                        resolve.dispose((IProgressMonitor)subProgressMonitor);
                        subProgressMonitor.done();
                    }
                    catch (Throwable e) {
                        ErrorManager.get().displayException(e, "Error during dispose: " + resolve.getIdentifier(), "net.refractions.udig.catalog");
                    }
                }
            }
            catch (Throwable e) {
                ErrorManager.get().displayException(e, "Cleaning up memebers of service: " + this.getIdentifier(), "net.refractions.udig.catalog");
                return;
            }
        }
        this.isDisposed = true;
    }
}

