/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.data.Parameter;
import org.geotools.process.ProcessFactory;
import org.opengis.feature.type.Name;

public class IProcessInfo {
    protected String title;
    protected String description;
    protected String name;
    protected String[] keywords;
    protected URI schema;
    protected ImageDescriptor icon;
    protected ProcessFactory processFactory;
    protected Icon awtIcon;
    protected Name processName;

    protected IProcessInfo() {
    }

    public IProcessInfo(String title, String name, String description, URI schema, ProcessFactory pf, Name pn, String[] keywords, ImageDescriptor icon) {
        this.processFactory = pf;
        this.processName = pn;
        this.title = title;
        this.description = description;
        this.name = name;
        int i = 0;
        if (keywords != null) {
            i = keywords.length;
        }
        String[] k = new String[i];
        if (keywords != null) {
            System.arraycopy(keywords, 0, k, 0, k.length);
        }
        this.keywords = k;
        this.schema = schema;
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public ProcessFactory getProcessFactory() {
        return this.processFactory;
    }

    public Name getProcessName() {
        return this.processName;
    }

    public Set<String> getKeywords() {
        List<String> asList = Arrays.asList(this.keywords);
        HashSet<String> set = new HashSet<String>(asList);
        return set;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        if (this.awtIcon != null) {
            return this.awtIcon;
        }
        if (this.icon == null) {
            return null;
        }
        Icon awtIcon = AWTSWTImageUtils.imageDescriptor2awtIcon((ImageDescriptor)this.icon);
        return awtIcon;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.icon != null) {
            return this.icon;
        }
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            return null;
        }
        return AWTSWTImageUtils.awtIcon2ImageDescriptor((Icon)icon2);
    }

    public Map<String, Parameter<?>> getInputs() {
        return this.processFactory.getParameterInfo(this.processName);
    }

    public Map<String, Parameter<?>> getOutputs() {
        return this.processFactory.getResultInfo(this.processName, null);
    }
}

