/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IProcessInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.URLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class IProcess
implements IResolve {
    private volatile String stringURL;

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(IProcessInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast(this.service(monitor));
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            try {
                monitor.beginTask("service info", 100);
                IService service = this.service((IProgressMonitor)new SubProgressMonitor(monitor, 40));
                IServiceInfo info = service.createInfo((IProgressMonitor)new SubProgressMonitor(monitor, 60));
                T t = adaptee.cast(info);
                return t;
            }
            finally {
                monitor.done();
            }
        }
        if (adaptee.isAssignableFrom(IProcess.class)) {
            monitor.done();
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(this.getClass())) {
            return adaptee.cast(this);
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve(this, adaptee)) {
            return rm.resolve(this, adaptee, monitor);
        }
        return null;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(IProcess.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(this.getClass()) || adaptee.isAssignableFrom(IResolve.class) || CatalogPlugin.getDefault().getResolveManager().canResolve(this, adaptee));
    }

    public abstract IProcessInfo getInfo(IProgressMonitor var1) throws IOException;

    public abstract IService service(IProgressMonitor var1) throws IOException;

    @Override
    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.service(monitor);
    }

    @Override
    public List<IResolve> members(IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0 instanceof IProcess) {
            IProcess resource = (IProcess)arg0;
            if (this.getIdentifier() != null && resource.getIdentifier() != null) {
                return this.getStringURL().equals(resource.getStringURL());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringURL() {
        if (this.stringURL == null) {
            IProcess iProcess = this;
            synchronized (iProcess) {
                if (this.stringURL == null) {
                    this.stringURL = URLUtils.urlToString(this.getIdentifier(), false);
                }
            }
        }
        return this.stringURL;
    }

    public int hashCode() {
        int value = 31;
        if (this.getIdentifier() != null) {
            value += 31 + URLUtils.urlToString(this.getIdentifier(), false).hashCode();
        }
        return value += 31 + this.getClass().getName().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getName();
        String name = classname.substring(classname.lastIndexOf(46) + 1);
        buf.append(name);
        buf.append("(");
        buf.append(this.getIdentifier());
        buf.append(")");
        return buf.toString();
    }

    @Override
    public abstract URL getIdentifier();

    @Override
    public ID getID() {
        return new ID(this.getIdentifier());
    }

    @Override
    public void dispose(IProgressMonitor monitor) {
    }
}

