/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.data.DataUtilities;

public class ID
implements Serializable {
    private static final long serialVersionUID = 5858146620416500314L;
    private String id;
    private File file;
    private URL url;
    private URI uri;
    private String typeQualifier;

    public ID(String txt, String qualifier) {
        this.id = txt;
        try {
            this.url = new URL(null, txt, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            this.uri = this.url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.file = DataUtilities.urlToFile((URL)this.url);
        this.typeQualifier = qualifier;
    }

    public ID(File file, String qualifier) {
        this.typeQualifier = qualifier;
        this.file = file;
        try {
            this.id = file.getCanonicalPath();
        }
        catch (IOException iOException) {}
        this.uri = file.toURI();
        if (this.id == null) {
            this.id = this.uri.toString();
        }
        try {
            this.url = this.uri.toURL();
            if (this.id == null) {
                this.id = this.url.toString();
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public ID(String id, URL url, File file, URI uri, String qualifier) {
        this.id = id;
        this.url = url;
        this.uri = uri;
        this.file = file;
        this.typeQualifier = qualifier;
    }

    public ID(URL url) {
        this(url, null);
    }

    public ID(URL url, String qualifier) {
        this.typeQualifier = qualifier;
        this.url = url;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.file = DataUtilities.urlToFile((URL)url);
        if (this.file != null && this.uri != null && this.uri.isAbsolute() && "file".equals(this.uri.getScheme())) {
            try {
                String fragment = this.uri.getFragment();
                if (fragment != null) {
                    String canonicalPath = this.file.getCanonicalPath();
                    File canonicalFile = this.file.getCanonicalFile();
                    canonicalFile = new File(canonicalPath.substring(0, canonicalPath.length() - fragment.length() - 1));
                    URI canonicalURI = canonicalFile.toURI();
                    this.uri = new URI(String.valueOf(canonicalURI.toASCIIString()) + "#" + fragment);
                    this.url = this.uri.toURL();
                    this.id = canonicalPath;
                    this.file = canonicalFile;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Trouble matching file for:" + this.uri);
            }
        }
        if (this.id == null && this.file != null) {
            try {
                String canonicalPath;
                this.id = canonicalPath = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        if (this.id == null) {
            this.id = this.uri != null ? this.uri.toString() : url.toString();
        }
    }

    public ID(URI uri, String qualifier) throws IOException {
        this(uri);
        this.typeQualifier = qualifier;
    }

    public ID(URI uri) throws IOException {
        this.uri = uri;
        if (uri.isAbsolute()) {
            try {
                this.url = uri.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.url = new URL(null, this.url.toExternalForm(), CorePlugin.RELAXED_HANDLER);
            }
        }
        this.file = uri.isAbsolute() && "file".equals(uri.getScheme()) ? new File(uri) : null;
        if (this.file != null) {
            this.id = this.file.getCanonicalPath();
        } else if (uri != null) {
            this.id = uri.toString();
        }
    }

    public ID(ID parent, String child) {
        String extension = parent.id.contains("#") ? "/" + child : "#" + child;
        this.id = String.valueOf(parent.id) + extension;
        try {
            this.url = new URL(null, String.valueOf(parent.toURL().toString()) + extension, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            this.uri = new URI(String.valueOf(parent.uri.toString()) + extension);
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.file = parent.file;
        this.typeQualifier = parent.getTypeQualifier();
    }

    public String getTypeQualifier() {
        return this.typeQualifier;
    }

    public File toFile() {
        return this.file;
    }

    public File toFile(String extension) {
        if (extension == null) {
            return this.file;
        }
        File parent = this.file.getParentFile();
        String baseFile = this.toBaseFile();
        File target = new File(parent, String.valueOf(baseFile) + "." + extension);
        return target;
    }

    public String toExtension() {
        String name;
        try {
            name = this.uri.toURL().getFile();
        }
        catch (MalformedURLException malformedURLException) {
            name = this.url.getFile();
        }
        int slash = name.lastIndexOf(47);
        int dot = name.lastIndexOf(46);
        int beginIndex = (slash == -1 && slash < name.length() - 1 ? 0 : slash) + 1;
        if (dot == -1 || dot < beginIndex || dot == name.length() - 1) {
            return "";
        }
        return name.substring(dot + 1);
    }

    public String toBaseFile() {
        String name;
        try {
            name = this.uri.toURL().getFile();
        }
        catch (MalformedURLException malformedURLException) {
            name = this.url.getFile();
        }
        int slash = name.lastIndexOf(47);
        int dot = name.lastIndexOf(46);
        int beginIndex = (slash == -1 && slash < name.length() - 1 ? 0 : slash) + 1;
        int endIndex = dot == -1 || dot < beginIndex ? name.length() : dot;
        return name.substring(beginIndex, endIndex);
    }

    public URL toURL() {
        return this.url;
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.typeQualifier == null ? 0 : this.typeQualifier.hashCode());
        return result;
    }

    public boolean equals(ID other, boolean stripChildRef) {
        if (stripChildRef) {
            String strip1 = this.stripChildRef();
            String strip2 = other.stripChildRef();
            return strip1.equals(strip2);
        }
        return this.equals(this.id);
    }

    private String stripChildRef() {
        int splitHash = this.id.indexOf("#");
        if (splitHash != -1) {
            int splitSlash = this.id.indexOf("/", splitHash);
            if (splitSlash != -1) {
                return this.id.substring(0, splitSlash);
            }
            return this.id.substring(0, splitHash);
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID other = (ID)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.typeQualifier == null ? other.typeQualifier != null : !this.typeQualifier.equals(other.typeQualifier));
    }

    public URL toURL(File baseDirectory) {
        return URLUtils.toRelativePath(baseDirectory, this.toURL());
    }

    public boolean isLocal() {
        return this.id.contains("localhost");
    }

    public boolean isChild() {
        return this.id.toString().contains("#");
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean isDecorator() {
        if (this.url == null) {
            return false;
        }
        String HOST = this.url.getHost();
        String PROTOCOL = this.url.getProtocol();
        String PATH = this.url.getPath();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (!"localhost".equals(HOST)) {
            return false;
        }
        return "/mapgraphic".equals(PATH);
    }

    public boolean isTemporary() {
        if (this.url == null) {
            return false;
        }
        String HOST = this.url.getHost();
        String PROTOCOL = this.url.getProtocol();
        String PATH = this.url.getPath();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (!"localhost".equals(HOST)) {
            return false;
        }
        return "/scratch".equals(PATH);
    }

    public boolean isWMS() {
        if (this.url == null) {
            return false;
        }
        String PATH = this.url.getPath();
        String QUERY = this.url.getQuery();
        String PROTOCOL = this.url.getProtocol();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WMS") != -1) {
            return true;
        }
        return PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WMS") != -1;
    }

    public boolean isWFS() {
        if (this.url == null) {
            return false;
        }
        String PATH = this.url.getPath();
        String QUERY = this.url.getQuery();
        String PROTOCOL = this.url.getProtocol();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WFS") != -1) {
            return true;
        }
        return PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WFS") != -1;
    }

    public boolean isJDBC() {
        return this.id.startsWith("jdbc");
    }

    public boolean isMemory() {
        String HOST = this.url.getHost();
        String PROTOCOL = this.url.getProtocol();
        String PATH = this.url.getPath();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (!"localhost".equals(HOST)) {
            return false;
        }
        return "/scratch".equals(PATH);
    }

    public String labelResource() {
        if (this.url == null) {
            return this.id;
        }
        String HOST = this.url.getHost();
        String QUERY = this.url.getQuery();
        String PATH = this.url.getPath();
        String PROTOCOL = this.url.getProtocol();
        String REF = this.url.getRef();
        if (REF != null) {
            return REF;
        }
        if (PROTOCOL == null) {
            return "";
        }
        StringBuffer label = new StringBuffer();
        if ("file".equals(PROTOCOL)) {
            int split = PATH.lastIndexOf(47);
            if (split == -1) {
                label.append(PATH);
            } else {
                String file = PATH.substring(split + 1);
                int dot = file.lastIndexOf(46);
                if (dot != -1) {
                    file = file.substring(0, dot);
                }
                file = file.replace("%20", " ");
                label.append(file);
            }
        } else if ("http".equals(PROTOCOL) && HOST.indexOf(".jdbc") != -1) {
            if (QUERY != null) {
                label.append(QUERY);
            } else {
                label.append(PATH);
            }
        } else if ("http".equals(PROTOCOL)) {
            if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WFS") != -1) {
                String[] stringArray = QUERY.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String split = stringArray[n2];
                    if (split.toLowerCase().startsWith("type=")) {
                        label.append(split.substring(5));
                    }
                    ++n2;
                }
            } else if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WMS") != -1) {
                String[] stringArray = QUERY.split("&");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String split = stringArray[n3];
                    if (split.startsWith("LAYER=")) {
                        label.append(split.substring(6));
                    }
                    ++n3;
                }
            } else {
                int split = PATH.lastIndexOf(47);
                if (split == -1) {
                    label.append(PATH);
                } else {
                    label.append(PATH.substring(split + 1));
                }
            }
        } else {
            int split = PATH.lastIndexOf(47);
            if (split == -1) {
                label.append(PATH);
            } else {
                label.append(PATH.substring(split + 1));
            }
        }
        return label.toString();
    }

    public String labelServer() {
        if (this.url == null) {
            return this.id;
        }
        String HOST = this.url.getHost();
        int PORT = this.url.getPort();
        String PATH = this.url.getPath();
        String PROTOCOL = this.url.getProtocol();
        if (PROTOCOL == null) {
            return "";
        }
        StringBuffer label = new StringBuffer();
        if (this.isFile()) {
            String[] split = PATH.split("\\/");
            if (split.length == 0) {
                label.append(File.separatorChar);
            } else {
                if (split.length < 2) {
                    label.append(File.separatorChar);
                    label.append(split[0]);
                    label.append(File.separatorChar);
                } else {
                    label.append(split[split.length - 2]);
                    label.append(File.separatorChar);
                }
                label.append(split[split.length - 1]);
            }
        } else if (this.isJDBC()) {
            int split2 = HOST.lastIndexOf(46);
            int split1 = HOST.lastIndexOf(46, split2 - 1);
            if (split1 != -1 && split2 != -1) {
                label.append(HOST.substring(split1 + 1, split2));
                label.append("://");
                label.append(HOST.subSequence(0, split1));
            } else {
                label.append(HOST);
            }
        } else if ("http".equals(PROTOCOL) || "https".equals(PROTOCOL)) {
            if (this.isWMS()) {
                label.append("wms://");
            } else if (this.isWFS()) {
                label.append("wfs://");
            }
            label.append(HOST);
        } else {
            label.append(PROTOCOL);
            label.append("://");
            label.append(HOST);
        }
        if (PORT != -1) {
            label.append(":");
            label.append(PORT);
        }
        return label.toString();
    }

    public static ID cast(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ID) {
            return (ID)data;
        }
        if (data instanceof IService) {
            IService service = (IService)data;
            return service.getID();
        }
        if (data instanceof IGeoResource) {
            IGeoResource resource = (IGeoResource)data;
            return resource.getID();
        }
        if (data instanceof IResolve) {
            IResolve resolve = (IResolve)data;
            return resolve.getID();
        }
        if (data instanceof URL) {
            URL url = (URL)data;
            return new ID(url);
        }
        if (data instanceof URI) {
            URI uri = (URI)data;
            try {
                return new ID(uri);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (data instanceof File) {
            File file = (File)data;
            return new ID(file, null);
        }
        if (data instanceof String) {
            String string = (String)data;
            int index = string.indexOf("\n");
            if (index > -1) {
                string = string.substring(0, index);
            }
            try {
                URL url = new URL(string);
                return new ID(url);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    File file = new File(string);
                    return new ID(file, null);
                }
                catch (Throwable throwable) {
                    return new ID(string, null);
                }
            }
        }
        return null;
    }
}

