/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IRepository;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.catalog.internal.ResolveManager2;
import net.refractions.udig.catalog.internal.ServiceFactoryImpl;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.ui.PreShutdownTask;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.ShutdownTaskList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class CatalogPlugin
extends Plugin {
    private static final String EXTENSION_POINT_ICATALOG = "net.refractions.udig.catalog.ICatalog";
    public static final String ID = "net.refractions.udig.catalog";
    private static CatalogPlugin plugin;
    private ResourceBundle resourceBundle;
    private CatalogImpl local;
    private List<ISearch> catalogs;
    private IServiceFactory serviceFactory;
    private IPreferenceStore preferenceStore;
    private volatile IResolveManager resolveManager;
    private Lock registeredLock = new ReentrantLock();
    Map<String, ServiceExtension> registered = null;

    public CatalogPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.local = new CatalogImpl();
        this.catalogs = Collections.emptyList();
        this.serviceFactory = new ServiceFactoryImpl();
        this.resolveManager = new ResolveManager2();
        this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        try {
            if (Display.getCurrent() != null) {
                CatalogPlugin.log("Restoring Local Catalog", null);
            }
            plugin.restoreFromPreferences();
        }
        catch (Throwable e) {
            CatalogPlugin.log("Unable to restore catalog:" + e, e);
            this.handlerLoadingError(e);
        }
        this.addSaveLocalCatalogShutdownHook();
    }

    private void addSaveLocalCatalogShutdownHook() {
        ShutdownTaskList.instance().addPreShutdownTask(new PreShutdownTask(){

            public int getProgressMonitorSteps() {
                try {
                    return CatalogPlugin.this.getLocalCatalog().members(ProgressManager.instance().get(new Object[0])).size();
                }
                catch (IOException iOException) {
                    return 0;
                }
            }

            public boolean handlePreShutdownException(Throwable t, boolean forced) {
                CatalogPlugin.log("Error storing local catalog", t);
                return true;
            }

            public boolean preShutdown(IProgressMonitor monitor, IWorkbench workbench, boolean forced) throws Exception {
                ISearch[] toDispose = CatalogPlugin.this.getCatalogs();
                monitor.beginTask(Messages.CatalogPlugin_SavingCatalog, 4 + 4 * toDispose.length);
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 4);
                CatalogPlugin.this.storeToPreferences((IProgressMonitor)subProgressMonitor);
                subProgressMonitor.done();
                ISearch[] iSearchArray = toDispose;
                int n = toDispose.length;
                int n2 = 0;
                while (n2 < n) {
                    ISearch catalog = iSearchArray[n2];
                    subProgressMonitor = new SubProgressMonitor(monitor, 4);
                    catalog.dispose((IProgressMonitor)subProgressMonitor);
                    subProgressMonitor.done();
                    ++n2;
                }
                return true;
            }
        });
    }

    private void handlerLoadingError(Throwable e) {
        try {
            File backup = new File(this.getLocalCatalogFile().getParentFile(), "corruptedLocalCatalog");
            this.copy(this.getLocalCatalogFile(), backup);
        }
        catch (IOException ioe) {
            CatalogPlugin.log("Coulding make a back up of the corrupted local catalog", ioe);
        }
        boolean addShutdownHook = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.CatalogPlugin_ErrorLoading, (String)Messages.CatalogPlugin__ErrorLoadingMessage);
        if (addShutdownHook) {
            this.addSaveLocalCatalogShutdownHook();
        }
    }

    private void copy(File file, File backup) throws IOException {
        FileChannel in = new FileInputStream(file).getChannel();
        FileChannel out = new FileOutputStream(backup).getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.write(buffer);
            buffer.clear();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public void restoreFromPreferences() {
        try {
            if (this.getLocalCatalog() instanceof CatalogImpl) {
                CatalogImpl localCatalog = (CatalogImpl)this.getLocalCatalog();
                File catalogFile = this.getLocalCatalogFile();
                IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
                localCatalog.loadFromFile(catalogFile, serviceFactory);
            }
        }
        catch (Throwable t) {
            CatalogPlugin.log("Trouble restoring local catalog:" + t, t);
        }
        try {
            this.loadCatalogs();
        }
        catch (Throwable t) {
            CatalogPlugin.log("Trouble connectin remote catalogs:" + t, t);
        }
    }

    private List<ISearch> loadCatalogs() {
        final LinkedList<ISearch> availableCatalogs = new LinkedList<ISearch>();
        ExtensionPointUtil.process((Plugin)CatalogPlugin.getDefault(), (String)EXTENSION_POINT_ICATALOG, (ExtensionPointProcessor)new ExtensionPointProcessor(){

            public void process(IExtension extension, IConfigurationElement element) throws Exception {
                ISearch externalCatalog = (ISearch)element.createExecutableExtension("class");
                availableCatalogs.add(externalCatalog);
            }
        });
        return availableCatalogs;
    }

    public void storeToPreferences(IProgressMonitor monitor) throws BackingStoreException, IOException {
        ((CatalogImpl)this.getLocalCatalog()).saveToFile(this.getLocalCatalogFile(), this.getServiceFactory(), monitor);
    }

    private File getLocalCatalogFile() throws IOException {
        File userLocation = new File(FileLocator.toFileURL((URL)Platform.getInstanceLocation().getURL()).getFile());
        if (!userLocation.exists()) {
            userLocation.mkdirs();
        }
        File catalogLocation = new File(userLocation, ".localCatalog");
        return catalogLocation;
    }

    public static CatalogPlugin getDefault() {
        return plugin;
    }

    public static void addListener(IResolveChangeListener listener) {
        ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).addCatalogListener(listener);
    }

    public static void removeListener(IResolveChangeListener listener) {
        ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).removeCatalogListener(listener);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CatalogPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("net.refractions.udig.catalog.CatalogPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public synchronized ISearch[] getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = this.loadCatalogs();
        }
        ArrayList<ISearch> c = new ArrayList<ISearch>();
        c.add(this.local);
        c.addAll(this.catalogs);
        return c.toArray(new ISearch[c.size()]);
    }

    public synchronized void addSearchCatalog(ISearch searchCatalog) {
        this.getCatalogs();
        this.catalogs.add(searchCatalog);
    }

    public ICatalog getLocalCatalog() {
        return this.local;
    }

    public IRepository getLocal() {
        return this.local;
    }

    public IServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public List<ServiceExtension> getServiceExtensions() {
        ArrayList<ServiceExtension> list = new ArrayList<ServiceExtension>(this.getRegisteredExtensions().values());
        return Collections.unmodifiableList(list);
    }

    public void register(String id, ServiceExtension extension) {
        try {
            this.registeredLock.lock();
            this.getRegisteredExtensions();
            if (this.registered.containsKey(id)) {
                ServiceExtension existing = this.registered.get(id);
                String exsistingName = existing != null ? existing.getClass().getSimpleName() : null;
                throw new IllegalStateException("ServiceExtension " + id + " already registered with " + exsistingName);
            }
            this.registered.put(id, extension);
        }
        finally {
            this.registeredLock.unlock();
        }
    }

    Map<String, ServiceExtension> getRegisteredExtensions() {
        try {
            this.registeredLock.lock();
            if (this.registered == null) {
                this.registered = new HashMap<String, ServiceExtension>();
                ExtensionPointUtil.process((Plugin)CatalogPlugin.getDefault(), (String)"net.refractions.udig.catalog.ServiceExtension", (ExtensionPointProcessor)new ExtensionPointProcessor(){

                    public void process(IExtension extension, IConfigurationElement element) throws Exception {
                        String id = element.getAttribute("id");
                        ServiceExtension se = (ServiceExtension)element.createExecutableExtension("class");
                        if (id == null || id.length() == 0) {
                            id = se.getClass().getSimpleName();
                        }
                        CatalogPlugin.this.registered.put(id, se);
                    }
                });
            }
            Map<String, ServiceExtension> map = this.registered;
            return map;
        }
        finally {
            this.registeredLock.unlock();
        }
    }

    public <E extends ServiceExtension> E serviceImplementation(Class<E> implementation) {
        for (Map.Entry<String, ServiceExtension> entry : this.getRegisteredExtensions().entrySet()) {
            String id = entry.getKey();
            ServiceExtension serviceExtension = entry.getValue();
            if (id == null || serviceExtension == null || !implementation.isInstance(serviceExtension)) continue;
            return (E)((ServiceExtension)implementation.cast(serviceExtension));
        }
        return null;
    }

    public ServiceExtension serviceImplementation(String serviceExtensionId) {
        for (Map.Entry<String, ServiceExtension> entry : this.getRegisteredExtensions().entrySet()) {
            String id = entry.getKey();
            ServiceExtension serviceExtension = entry.getValue();
            if (id == null || serviceExtension == null || !serviceExtensionId.equalsIgnoreCase(id)) continue;
            return serviceExtension;
        }
        return null;
    }

    public static URL locateURL(Object data) {
        ID id = net.refractions.udig.catalog.ID.cast(data);
        if (id == null) {
            return null;
        }
        return id.toURL();
    }

    public static void log(String message, Throwable t) {
        String msg = message == null ? "" : message;
        int status = t instanceof Exception || message != null ? 4 : 1;
        CatalogPlugin.getDefault().getLog().log((IStatus)new Status(status, ID, 0, msg, t));
    }

    public static void trace(String message, Throwable e) {
        if (CatalogPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDebugging(String trace) {
        return CatalogPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IResolveManager getResolveManager() {
        return this.resolveManager;
    }
}

