/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.WMSTile;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSTileSet
implements TileSet {
    private static final double SCALE_FACTOR = 0.2;
    private int id;
    private AbstractOpenWebService<?, ?> server;
    private CoordinateReferenceSystem crs;
    private String epsgCode;
    private ReferencedEnvelope bboxSrs;
    private int width;
    private int height;
    private String format;
    private String layers;
    private String resolutions;
    private double[] dresolutions;
    private double[] mresolutions;
    private String styles;
    ObjectCache tiles = ObjectCaches.create((String)"soft", (int)50);

    public WMSTileSet() {
        this.updateID();
    }

    @Override
    public void setCoorindateReferenceSystem(String epsg) {
        this.epsgCode = epsg;
        try {
            this.crs = CRS.decode((String)epsg);
        }
        catch (Exception exception) {}
        this.updateID();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public void setBoundingBox(CRSEnvelope bbox) {
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)bbox.getEPSGCode());
        }
        catch (Exception exception) {
            System.out.println("Cannot decode tile epsg code: " + bbox.getEPSGCode());
        }
        this.bboxSrs = new ReferencedEnvelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), crs);
        this.updateID();
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.updateID();
    }

    @Override
    public void setStyles(String styles) {
        this.styles = styles;
        this.updateID();
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.updateID();
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
        this.updateID();
    }

    @Override
    public void setLayers(String layers) {
        this.layers = layers;
        this.updateID();
    }

    @Override
    public void setResolutions(String res) {
        this.resolutions = res;
        String[] sres = this.resolutions.split(" ");
        double[] dres = new double[sres.length];
        int i = 0;
        while (i < sres.length) {
            dres[i] = Double.parseDouble(sres[i]);
            ++i;
        }
        this.dresolutions = dres;
        this.mresolutions = new double[this.dresolutions.length - 1];
        i = 0;
        while (i < this.dresolutions.length - 1) {
            this.mresolutions[i] = (this.dresolutions[i] - this.dresolutions[i + 1]) * 0.2 + this.dresolutions[i + 1];
            ++i;
        }
        this.updateID();
    }

    @Override
    public int getNumLevels() {
        return this.dresolutions.length;
    }

    private double findAppropriateZoomLevel(double scale) {
        if (scale > this.mresolutions[0]) {
            return this.dresolutions[0];
        }
        int i = 1;
        while (i < this.mresolutions.length) {
            if (this.mresolutions[i - 1] >= scale && this.mresolutions[i] < scale) {
                return this.dresolutions[i];
            }
            ++i;
        }
        return this.dresolutions[this.dresolutions.length - 1];
    }

    public String createQueryString(Envelope tile) {
        String query = "service=WMS&request=getMap&tiled=true&width=" + this.width + "&height=" + this.height + "&format=" + this.getFormat() + "&srs=" + this.getEPSGCode() + "&layers=" + this.getLayers() + "&bbox=" + tile.getMinX() + "," + tile.getMinY() + "," + tile.getMaxX() + "," + tile.getMaxY() + "&styles=" + this.getStyles();
        return query;
    }

    @Override
    public Map<String, Tile> getTilesFromViewportScale(Envelope bounds, double viewportScale) {
        double scale = this.findAppropriateZoomLevel(viewportScale);
        return this.getTilesFromZoom(bounds, scale);
    }

    @Override
    public Map<String, Tile> getTilesFromZoom(Envelope bounds, double zoom) {
        double xscale = (double)this.width * zoom;
        double value = bounds.getMinX() - this.bboxSrs.getMinX();
        double minx = Math.floor(value / xscale) * xscale + this.bboxSrs.getMinX();
        value = bounds.getMaxX() - this.bboxSrs.getMinX();
        double maxx = Math.ceil(value / xscale) * xscale + this.bboxSrs.getMinX();
        double yscale = (double)this.height * zoom;
        value = bounds.getMinY() - this.bboxSrs.getMinY();
        double miny = Math.floor(value / yscale) * yscale + this.bboxSrs.getMinY();
        value = bounds.getMaxY() - this.bboxSrs.getMinY();
        double maxy = Math.ceil(value / yscale) * yscale + this.bboxSrs.getMinY();
        HashMap<String, Tile> viewportTiles = new HashMap<String, Tile>();
        int xNum = (int)Math.round((maxx - minx) / xscale);
        int yNum = (int)Math.round((maxy - miny) / yscale);
        int x = 0;
        while (x < xNum) {
            double xmin = WMSTileSet.roundDouble((double)x * xscale + minx);
            double xmax = WMSTileSet.roundDouble((double)(x + 1) * xscale + minx);
            int y = 0;
            while (y < yNum) {
                double ymax;
                double ymin = WMSTileSet.roundDouble((double)y * yscale + miny);
                Envelope e = new Envelope(xmin, xmax, ymin, ymax = WMSTileSet.roundDouble((double)(y + 1) * yscale + miny));
                if (!(e.getMaxX() <= this.bboxSrs.getMinX() || e.getMinX() >= this.bboxSrs.getMaxX() || e.getMaxY() <= this.bboxSrs.getMinY() || e.getMinY() >= this.bboxSrs.getMaxY())) {
                    Tile tile;
                    String tileid = WMSTile.buildId(e, zoom);
                    if (this.tiles.peek((Object)tileid) == null || this.tiles.get((Object)tileid) == null) {
                        tile = new WMSTile(this.server, this, e, zoom);
                        this.tiles.put((Object)tileid, (Object)tile);
                        double topleft_x = this.bboxSrs.getMinX();
                        double topleft_y = this.bboxSrs.getMaxY();
                        double tileleft_x = e.getMinX();
                        double tileleft_y = e.getMaxY();
                        double spacex = tileleft_x - topleft_x;
                        double spacey = topleft_y - tileleft_y;
                        int posx = (int)Math.round(spacex / xscale);
                        int posy = (int)Math.round(spacey / yscale);
                        String position = String.valueOf(posx) + "_" + posy;
                        tile.setPosition(position);
                    } else {
                        tile = (Tile)this.tiles.get((Object)tileid);
                    }
                    viewportTiles.put(tileid, tile);
                }
                ++y;
            }
            ++x;
        }
        return viewportTiles;
    }

    private static double roundDouble(double number) {
        Long xBits = Double.doubleToLongBits(number);
        int nBits = 8;
        long invMask = (1L << nBits) - 1L;
        long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
        xBits = xBits & mask;
        return Double.longBitsToDouble(xBits);
    }

    @Override
    public List<Envelope> getBoundsListForZoom(Envelope bounds, double zoom) {
        int maxTilesPerBound = 1024;
        ArrayList<Envelope> boundsList = new ArrayList<Envelope>();
        double xscale = (double)this.width * zoom;
        double value = bounds.getMinX() - this.bboxSrs.getMinX();
        double minx = Math.floor(value / xscale) * xscale + this.bboxSrs.getMinX();
        value = bounds.getMaxX() - this.bboxSrs.getMinX();
        double maxx = Math.ceil(value / xscale) * xscale + this.bboxSrs.getMinX();
        double yscale = (double)this.height * zoom;
        value = bounds.getMinY() - this.bboxSrs.getMinY();
        double miny = Math.floor(value / yscale) * yscale + this.bboxSrs.getMinY();
        value = bounds.getMaxY() - this.bboxSrs.getMinY();
        double maxy = Math.ceil(value / yscale) * yscale + this.bboxSrs.getMinY();
        long tilesPerRow = Math.round((maxx - minx) / xscale);
        long tilesPerCol = Math.round((maxy - miny) / yscale);
        long totalTiles = tilesPerCol * tilesPerRow;
        if (totalTiles <= (long)maxTilesPerBound) {
            boundsList.add(bounds);
            return boundsList;
        }
        double scaleDownFactor = Math.ceil(totalTiles / (long)maxTilesPerBound);
        double boundsWidth = Math.ceil((double)tilesPerRow / scaleDownFactor) * xscale;
        double boundsHeight = Math.ceil((double)tilesPerCol / scaleDownFactor) * yscale;
        double x = minx;
        while (x <= maxx) {
            double y = miny;
            while (y <= maxy) {
                double y2;
                double x2 = x + boundsWidth;
                if (x2 > maxx) {
                    x2 = maxx;
                }
                if ((y2 = y + boundsHeight) > maxy) {
                    y2 = maxy;
                }
                boundsList.add(new Envelope(x, x2, y, y2));
                y += boundsHeight;
            }
            x += boundsWidth;
        }
        return boundsList;
    }

    @Override
    public long getTileCount(Envelope bounds, double zoom) {
        double xscale = (double)this.width * zoom;
        double value = bounds.getMinX() - this.bboxSrs.getMinX();
        double minx = Math.floor(value / xscale) * xscale + this.bboxSrs.getMinX();
        value = bounds.getMaxX() - this.bboxSrs.getMinX();
        double maxx = Math.ceil(value / xscale) * xscale + this.bboxSrs.getMinX();
        double yscale = (double)this.height * zoom;
        value = bounds.getMinY() - this.bboxSrs.getMinY();
        double miny = Math.floor(value / yscale) * yscale + this.bboxSrs.getMinY();
        value = bounds.getMaxY() - this.bboxSrs.getMinY();
        double maxy = Math.ceil(value / yscale) * yscale + this.bboxSrs.getMinY();
        long tilesPerRow = Math.round((maxx - minx) / xscale);
        long tilesPerCol = Math.round((maxy - miny) / yscale);
        return tilesPerCol * tilesPerRow;
    }

    @Override
    public String getLayers() {
        return this.layers;
    }

    @Override
    public String getStyles() {
        return this.styles;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getEPSGCode() {
        return this.epsgCode;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bboxSrs;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public double[] getResolutions() {
        double[] d = new double[this.dresolutions.length];
        System.arraycopy(this.dresolutions, 0, d, 0, d.length);
        return d;
    }

    private void updateID() {
        StringBuffer sb = new StringBuffer();
        if (this.epsgCode != null) {
            sb.append(this.epsgCode);
        }
        if (this.format != null) {
            sb.append(this.format);
        }
        if (this.layers != null) {
            sb.append(this.layers);
        }
        if (this.resolutions != null) {
            sb.append(this.resolutions);
        }
        if (this.styles != null) {
            sb.append(this.styles);
        }
        if (this.bboxSrs != null) {
            sb.append(this.bboxSrs.getMinX());
            sb.append(this.bboxSrs.getMaxX());
            sb.append(this.bboxSrs.getMinY());
            sb.append(this.bboxSrs.getMaxY());
            sb.append(this.bboxSrs.getMinX());
        }
        if (this.bboxSrs != null && this.bboxSrs.getCoordinateReferenceSystem() != null) {
            sb.append(this.bboxSrs.getCoordinateReferenceSystem().toString().hashCode());
        }
        sb.append(this.width);
        sb.append(this.height);
        this.id = sb.toString().hashCode();
    }

    @Override
    public AbstractOpenWebService<?, ?> getServer() {
        return this.server;
    }

    @Override
    public void setServer(AbstractOpenWebService<?, ?> server) {
        this.server = server;
    }
}

