/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import net.refractions.udig.catalog.wmsc.server.WMSCSchema;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.xml.DocumentFactory;
import org.xml.sax.SAXException;

public class WMSCCapabilitiesResponse
extends GetCapabilitiesResponse {
    private String getCaps_xml;

    public WMSCCapabilitiesResponse(HTTPResponse response) throws ServiceException, IOException {
        super(response);
        try {
            this.getCaps_xml = WMSCCapabilitiesResponse.convertStreamToString(response.getResponseStream());
        }
        finally {
            response.dispose();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getCaps_xml.getBytes());
        try {
            Object object;
            HashMap<String, Object> hints = new HashMap<String, Object>();
            hints.put("org.geotools.xml.handlers.DocumentHandler.DEFAULT_NAMESPACE_HINT_KEY", WMSCSchema.getInstance());
            hints.put("DocumentFactory_VALIDATION_HINT", Boolean.FALSE);
            try {
                object = DocumentFactory.getInstance((InputStream)inputStream, hints, (Level)Level.WARNING);
            }
            catch (SAXException e) {
                throw (ServiceException)new ServiceException("Error while parsing XML.").initCause((Throwable)e);
            }
            if (object instanceof ServiceException) {
                throw (ServiceException)((Object)object);
            }
            this.capabilities = (Capabilities)object;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String getCapabilitiesXml() {
        return this.getCaps_xml;
    }
}

