/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import java.util.LinkedList;
import net.refractions.udig.catalog.CatalogPlugin;

public class TileWorkerQueue {
    private final int nThreads;
    private final PoolWorker[] threads;
    private final LinkedList<Runnable> queue;
    public static final int maxWorkingQueueSize = 64;
    public static final int minWorkingQueueSize = 1;
    public static final int defaultWorkingQueueSize = 16;
    private boolean isTerminated = false;

    public TileWorkerQueue() {
        int nThreads = CatalogPlugin.getDefault().getPreferenceStore().getInt("P_WMSCTILE_MAX_CON_REQUESTS");
        if (nThreads <= 0) {
            nThreads = 16;
        }
        this.nThreads = nThreads;
        this.queue = new LinkedList();
        this.threads = new PoolWorker[nThreads];
        this.initThreads();
    }

    public TileWorkerQueue(int nThreads) {
        if (nThreads > 64) {
            nThreads = 64;
        }
        if (nThreads < 1) {
            nThreads = 1;
        }
        this.nThreads = nThreads;
        this.queue = new LinkedList();
        this.threads = new PoolWorker[nThreads];
        this.initThreads();
    }

    private void initThreads() {
        int i = 0;
        while (i < this.nThreads) {
            this.threads[i] = new PoolWorker();
            this.threads[i].start();
            ++i;
        }
    }

    public int getThreadPoolSize() {
        return this.nThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable r) {
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(r);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isTerminated = true;
        int i = 0;
        while (i < this.nThreads) {
            this.threads[i] = null;
            ++i;
        }
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
            this.queue.notifyAll();
        }
    }

    private class PoolWorker
    extends Thread {
        private PoolWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (!TileWorkerQueue.this.isTerminated) {
                Runnable r;
                LinkedList linkedList = TileWorkerQueue.this.queue;
                synchronized (linkedList) {
                    while (true) {
                        if (!TileWorkerQueue.this.queue.isEmpty() || TileWorkerQueue.this.isTerminated) {
                            r = !TileWorkerQueue.this.queue.isEmpty() ? (Runnable)TileWorkerQueue.this.queue.removeFirst() : null;
                        }
                        try {
                            TileWorkerQueue.this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    r.run();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }
}

