/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.wmsc.server.AbstractTileRange;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileImageReadWriter;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TileWorkerQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.ows.AbstractOpenWebService;

public class TileRangeOnDisk
extends AbstractTileRange {
    private TileImageReadWriter tileReadWriter;
    private TileWorkerQueue writeTileWorkQueue;

    public TileRangeOnDisk(AbstractOpenWebService<?, ?> server, TileSet tileset, Envelope bounds, Map<String, Tile> tiles, TileWorkerQueue requestTileWorkQueue, TileWorkerQueue writeTileWorkQueue) {
        this(server, tileset, bounds, tiles, requestTileWorkQueue, writeTileWorkQueue, new TileImageReadWriter(server, CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_DISKDIR")));
    }

    public TileRangeOnDisk(AbstractOpenWebService<?, ?> server, TileSet tileset, Envelope bounds, Map<String, Tile> tiles, TileWorkerQueue requestTileWorkQueue, TileWorkerQueue writeTileWorkQueue, TileImageReadWriter tileImageReadWriter) {
        super(server, tileset, bounds, tiles, requestTileWorkQueue);
        if (writeTileWorkQueue == null) {
            this.using_threadpools = false;
        } else {
            this.writeTileWorkQueue = writeTileWorkQueue;
        }
        this.tileReadWriter = tileImageReadWriter;
        this.checkDiskForLoadedTiles();
    }

    private void checkDiskForLoadedTiles() {
        try {
            this.tilesWaitingToLoad_lock.writeLock().lock();
            String filetype = this.getFileType();
            HashMap<String, Tile> tilesToRemove = new HashMap<String, Tile>();
            for (Map.Entry tileentry : this.tilesWaitingToLoad.entrySet()) {
                boolean success;
                Tile tile = (Tile)tileentry.getValue();
                if (!this.tileReadWriter.tileFileExists(tile, filetype) || this.tileReadWriter.isTileStale(tile, filetype) || !(success = this.tileReadWriter.readTile(tile, filetype))) continue;
                tilesToRemove.put((String)tileentry.getKey(), tile);
            }
            for (Map.Entry tileentry : tilesToRemove.entrySet()) {
                this.tilesWaitingToLoad.remove(tileentry.getKey());
            }
        }
        finally {
            this.tilesWaitingToLoad_lock.writeLock().unlock();
        }
    }

    @Override
    public void cacheTile(Tile tile) {
        if (tile.getTileState() != 1) {
            this.saveTileToDisk(tile, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void saveTileToDisk(final Tile tile, final IProgressMonitor monitor) {
        if (this.using_threadpools) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    TileRangeOnDisk.this.internalSaveTileToDisk(tile, monitor);
                }
            };
            this.writeTileWorkQueue.execute(r);
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    TileRangeOnDisk.this.internalSaveTileToDisk(tile, monitor);
                }
            };
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSaveTileToDisk(Tile tile, IProgressMonitor monitor) {
        Object lock;
        Object object = lock = tile.getTileLock();
        synchronized (object) {
            if (tile.getBufferedImage() != null && tile.getTileState() != 1) {
                String filetype = this.getFileType();
                try {
                    this.tileReadWriter.writeTile(tile, filetype);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String getFileType() {
        String format = this.tileset.getFormat();
        int indexOf = (format = format.replaceAll("\\d+", "")).indexOf("\\");
        if (indexOf < 0 && (indexOf = format.indexOf("/")) < 0) {
            return format;
        }
        if (indexOf >= format.length() - 1) {
            return format;
        }
        return format.substring(indexOf + 1);
    }
}

