/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.wmsc.server;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileListener;
import net.refractions.udig.catalog.wmsc.server.TileRange;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TileWorkerQueue;
import org.apache.commons.collections.MapUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.ows.AbstractOpenWebService;

public abstract class AbstractTileRange
implements TileRange {
    protected Map<String, Tile> allTiles;
    protected Envelope bounds;
    protected AbstractOpenWebService<?, ?> server;
    protected TileSet tileset;
    protected TileWorkerQueue requestTileWorkQueue;
    protected boolean using_threadpools = false;
    protected static final boolean testing = false;
    protected Set<TileListener> tileListeners = new HashSet<TileListener>();
    protected ReentrantReadWriteLock tilesWaitingToLoad_lock = new ReentrantReadWriteLock();
    protected volatile Map<String, Tile> tilesWaitingToLoad = new HashMap<String, Tile>();

    public AbstractTileRange(AbstractOpenWebService<?, ?> server, TileSet tileset, Envelope bounds, Map<String, Tile> tiles, TileWorkerQueue requestTileWorkQueue) {
        this.server = server;
        this.tileset = tileset;
        this.allTiles = tiles != null ? tiles : new HashMap<String, Tile>();
        this.bounds = bounds != null ? bounds : this.calculateBounds();
        if (requestTileWorkQueue == null) {
            this.using_threadpools = false;
        } else {
            this.using_threadpools = true;
            this.requestTileWorkQueue = requestTileWorkQueue;
        }
        this.setTilesNotLoaded();
    }

    protected void setTilesNotLoaded() {
        try {
            this.tilesWaitingToLoad_lock.writeLock().lock();
            for (Map.Entry<String, Tile> tileentry : this.allTiles.entrySet()) {
                if (tileentry.getValue().getBufferedImage() != null) continue;
                this.tilesWaitingToLoad.put(tileentry.getKey(), tileentry.getValue());
            }
        }
        finally {
            this.tilesWaitingToLoad_lock.writeLock().unlock();
        }
    }

    @Override
    public void loadTiles(IProgressMonitor monitor) {
        HashSet<String> removeTiles = new HashSet<String>();
        try {
            this.tilesWaitingToLoad_lock.writeLock().lock();
            if (monitor.isCanceled()) {
                this.dispose();
                return;
            }
            Set<Map.Entry<String, Tile>> entrySet = this.tilesWaitingToLoad.entrySet();
            for (Map.Entry<String, Tile> set : entrySet) {
                String tileid = set.getKey();
                Tile tile = set.getValue();
                if (tile.getBufferedImage() == null) {
                    try {
                        this.loadTile(tile, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        removeTiles.add(tileid);
                    }
                    continue;
                }
                this.tileLoaded(tile);
                removeTiles.add(tileid);
            }
            for (String key : removeTiles) {
                this.tilesWaitingToLoad.remove(key);
            }
        }
        finally {
            this.tilesWaitingToLoad_lock.writeLock().unlock();
        }
    }

    @Override
    public void dispose() {
        for (TileListener listener : this.tileListeners) {
            this.removeListener(listener);
        }
    }

    @Override
    public void tileLoaded(Tile tile) {
        this.notifyListenersTileReady(tile);
    }

    protected void removeTileFromLoadingList(Tile tile) {
        try {
            this.tilesWaitingToLoad_lock.writeLock().lock();
            this.tilesWaitingToLoad.remove(tile.getId());
        }
        finally {
            this.tilesWaitingToLoad_lock.writeLock().unlock();
        }
    }

    protected Envelope calculateBounds() {
        Envelope newBounds = new Envelope();
        for (String key : this.allTiles.keySet()) {
            newBounds.expandToInclude(this.allTiles.get(key).getBounds());
        }
        return newBounds;
    }

    @Override
    public Tile getTile(String tileId) {
        if (tileId == null) {
            return null;
        }
        return this.allTiles.get(tileId);
    }

    @Override
    public Map<String, Tile> getTiles() {
        return MapUtils.unmodifiableMap(this.allTiles);
    }

    @Override
    public int getTileCount() {
        return this.allTiles.keySet().size();
    }

    @Override
    public boolean isComplete() {
        for (Map.Entry<String, Tile> value : this.allTiles.entrySet()) {
            if (value.getValue().getBufferedImage() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Envelope getRangeBounds() {
        return this.bounds;
    }

    protected void loadTile(final Tile tile, final IProgressMonitor monitor) throws Exception {
        if (this.using_threadpools) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AbstractTileRange.this.internalLoadTile(tile, monitor);
                }
            };
            this.requestTileWorkQueue.execute(r);
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    AbstractTileRange.this.internalLoadTile(tile, monitor);
                }
            };
            t.start();
        }
    }

    private void internalLoadTile(Tile tile, IProgressMonitor monitor) {
        tile.loadTile(monitor);
        this.tileLoaded(tile);
        this.removeTileFromLoadingList(tile);
        this.cacheTile(tile);
    }

    protected BufferedImage createErrorImage() {
        BufferedImage bf = new BufferedImage(this.tileset.getWidth(), this.tileset.getHeight(), 2);
        Graphics2D g = bf.createGraphics();
        g.setColor(Color.RED);
        g.drawLine(0, 0, this.tileset.getWidth(), this.tileset.getHeight());
        g.drawLine(0, this.tileset.getHeight(), this.tileset.getWidth(), 0);
        return bf;
    }

    protected void notifyListenersTileReady(Tile tile) {
        for (TileListener listener : this.tileListeners) {
            listener.notifyTileReady(tile);
        }
    }

    @Override
    public void addListener(TileListener listener) {
        this.tileListeners.add(listener);
    }

    @Override
    public void removeListener(TileListener listener) {
        this.tileListeners.remove(listener);
    }
}

