/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc.ui;

import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceExtension;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceImpl;
import net.refractions.udig.catalog.internal.wmsc.ui.WMSCConnectionFactory;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.wms.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WMSCWizardPage
extends AbstractUDIGImportPage
implements ModifyListener,
UDIGConnectionPage {
    private static final String ID = "net.refractions.udig.catalog.ui.WMSC";
    private String url = new String();
    private static final String WMSC_WIZARD = "WMSC_WIZARD";
    private static final String WMSC_RECENT = "WMSC_RECENT";
    private IDialogSettings settings = WmsPlugin.getDefault().getDialogSettings().getSection("WMSC_WIZARD");
    private static final int COMBO_HISTORY_LENGTH = 15;
    private Combo urlCombo;

    public WMSCWizardPage() {
        super(Messages.WMSCWizardPage_WMSCTitle);
        if (this.settings == null) {
            this.settings = WmsPlugin.getDefault().getDialogSettings().addNewSection(WMSC_WIZARD);
        }
    }

    public String getId() {
        return ID;
    }

    protected Map<String, Serializable> defaultParams() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Map<String, Serializable> toParams = this.toParams(selection);
        if (!toParams.isEmpty()) {
            return toParams;
        }
        WMSCConnectionFactory connectionFactory = new WMSCConnectionFactory();
        Map<String, Serializable> params = connectionFactory.createConnectionParameters(this.getState().getWorkflow().getContext());
        if (params != null) {
            return params;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Serializable> toParams(IStructuredSelection context) {
        if (context != null) {
            WMSCConnectionFactory connectionFactory = new WMSCConnectionFactory();
            Iterator itr = context.iterator();
            while (itr.hasNext()) {
                Map<String, Serializable> params = connectionFactory.createConnectionParameters(itr.next());
                if (params.isEmpty()) continue;
                return params;
            }
        }
        return Collections.emptyMap();
    }

    public void createControl(Composite parent) {
        int columns;
        String[] recentWMSs = this.settings.getArray(WMSC_RECENT);
        if (recentWMSs == null) {
            recentWMSs = new String[]{};
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.WMSWizardPage_label_url_text);
        urlLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        Map<String, Serializable> params = this.defaultParams();
        this.urlCombo = new Combo(composite, 2048);
        this.urlCombo.setItems(recentWMSs);
        this.urlCombo.setVisibleItemCount(15);
        this.urlCombo.setLayoutData((Object)gridData);
        URL selectedURL = this.getURL(params);
        if (selectedURL != null) {
            this.urlCombo.setText(selectedURL.toExternalForm());
            this.url = selectedURL.toExternalForm();
            this.setPageComplete(true);
        } else if (this.url != null && this.url.length() != 0) {
            this.urlCombo.setText(this.url);
            this.setPageComplete(true);
        } else {
            this.url = null;
            this.urlCombo.setText("http://");
            this.setPageComplete(false);
        }
        this.urlCombo.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                EndConnectionState currentState = WMSCWizardPage.this.getState();
                Map errors = currentState.getErrors();
                if (errors != null && !errors.isEmpty()) {
                    for (Map.Entry entry : errors.entrySet()) {
                        if (!(entry.getKey() instanceof WMSCServiceImpl)) continue;
                        Throwable value = (Throwable)entry.getValue();
                        if (value instanceof ConnectException) {
                            WMSCWizardPage.this.setErrorMessage(Messages.WMSWizardPage_serverConnectionError);
                            continue;
                        }
                        String message = String.valueOf(Messages.WMSWizardPage_connectionProblem) + value.getLocalizedMessage();
                        WMSCWizardPage.this.setErrorMessage(message);
                    }
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.getWizard().canFinish()) {
            this.getWizard().performFinish();
        }
    }

    public List<URL> getURLs() {
        try {
            ArrayList<URL> l = new ArrayList<URL>();
            l.add(new URL(this.url));
            return l;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void setErrorMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setErrorMessage(newMessage);
    }

    public void setMessage(String newMessage) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage);
    }

    public void setMessage(String newMessage, int messageType) {
        WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
        page.setMessage(newMessage, messageType);
    }

    public EndConnectionState getState() {
        return (EndConnectionState)super.getState();
    }

    public URL getURL(Map<String, Serializable> params) {
        Serializable value = params.get("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY");
        if (value == null) {
            return null;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                URL url = new URL((String)((Object)value));
                return url;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public Collection<URL> getResourceIDs() {
        Collection ids = super.getResourceIDs();
        return ids;
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        URL location = new URL(this.url);
        WMSCServiceExtension creator = new WMSCServiceExtension();
        Map<String, Serializable> params = creator.createParams(location);
        IService service = creator.createService(location, params);
        service.getInfo(monitor);
        ArrayList<IService> servers = new ArrayList<IService>();
        servers.add(service);
        this.saveWidgetValues();
        return servers;
    }

    public void modifyText(ModifyEvent e) {
        try {
            this.getState().getErrors().clear();
            this.url = ((Combo)e.getSource()).getText();
            new URL(this.url);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Messages.WMSWizardPage_error_invalidURL);
            this.setPageComplete(false);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void saveWidgetValues() {
        if (this.settings != null) {
            String[] recentWMSs = this.settings.getArray(WMSC_RECENT);
            if (recentWMSs == null) {
                recentWMSs = new String[]{};
            }
            recentWMSs = this.addToHistory(recentWMSs, this.url);
            this.settings.put(WMSC_RECENT, recentWMSs);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 15) {
            history.remove(15);
        }
    }

    public Map<String, Serializable> getParams() {
        try {
            URL location = new URL(this.url);
            WMSCServiceExtension creator = new WMSCServiceExtension();
            String errorMessage = creator.reasonForFailure(location);
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
                return Collections.emptyMap();
            }
            return creator.createParams(location);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

