/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmsc.WMSCGeoResourceImpl;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceExtension;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceImpl;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WMSCConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object context) {
        if (context instanceof IResolve) {
            IResolve resolve = (IResolve)context;
            return resolve.canResolve(TiledWebMapServer.class);
        }
        return WMSCConnectionFactory.toCapabilitiesURL(context) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object context) {
        Map<String, Serializable> params;
        if (context instanceof IResolve && !(params = WMSCConnectionFactory.createParams((IResolve)context)).isEmpty()) {
            return params;
        }
        URL url = WMSCConnectionFactory.toCapabilitiesURL(context);
        if (url != null) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                Map<String, Serializable> params2 = WMSCConnectionFactory.createParams(resolve);
                if (params2.isEmpty()) continue;
                return params2;
            }
            return WMSCConnectionFactory.createParams(url);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Serializable> createParams(IResolve handle) {
        if (handle instanceof WMSCServiceImpl) {
            WMSCServiceImpl wms = (WMSCServiceImpl)handle;
            return wms.getConnectionParams();
        }
        if (handle instanceof WMSCGeoResourceImpl) {
            WMSCGeoResourceImpl layer = (WMSCGeoResourceImpl)handle;
            try {
                WMSCServiceImpl wms = layer.service((IProgressMonitor)new NullProgressMonitor());
                return wms.getConnectionParams();
            }
            catch (IOException iOException) {
                WMSCConnectionFactory.checkedURL(layer.getIdentifier());
            }
        } else if (handle.canResolve(TiledWebMapServer.class)) {
            return WMSCConnectionFactory.createParams(handle.getIdentifier());
        }
        return Collections.emptyMap();
    }

    public static Map<String, Serializable> createParams(URL url) {
        WMSCServiceExtension factory = new WMSCServiceExtension();
        Map<String, Serializable> params = factory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY", url);
        return params2;
    }

    static URL toCapabilitiesURL(Object data) {
        ID id;
        if (data instanceof IResolve) {
            return WMSCConnectionFactory.toCapabilitiesURL((IResolve)data);
        }
        if (ID.cast((Object)data) != null && (id = ID.cast((Object)data)).toURL() != null) {
            return WMSCConnectionFactory.toCapabilitiesURL(id.toURL());
        }
        return null;
    }

    static URL toCapabilitiesURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return WMSCConnectionFactory.toCapabilitiesURL((IService)resolve);
        }
        return WMSCConnectionFactory.toCapabilitiesURL(resolve.getIdentifier());
    }

    static URL toCapabilitiesURL(IService resolve) {
        if (resolve instanceof WMSCServiceImpl) {
            return WMSCConnectionFactory.toCapabilitiesURL((WMSCServiceImpl)resolve);
        }
        return WMSCConnectionFactory.toCapabilitiesURL(resolve.getIdentifier());
    }

    static URL toCapabilitiesURL(WMSCServiceImpl wms) {
        return wms.getIdentifier();
    }

    static URL toCapabilitiesURL(URL url) {
        String protocol;
        if (url == null) {
            return null;
        }
        String query = url.getQuery() == null ? null : url.getQuery().toLowerCase();
        String string = protocol = url.getProtocol() == null ? null : url.getProtocol().toLowerCase();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return null;
        }
        if (query != null && query.indexOf("tiled=true") != -1) {
            return WMSCConnectionFactory.checkedURL(url);
        }
        return null;
    }

    public static URL checkedURL(URL url) {
        String check = url.toExternalForm();
        int hash = check.indexOf(35);
        if (hash == -1) {
            return url;
        }
        try {
            return new URL(check.substring(0, hash));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL createConnectionURL(Object context) {
        return null;
    }
}

