/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.internal.wmsc.WMSCGeoResourceImpl;
import net.refractions.udig.catalog.internal.wmsc.WMSCServieInfo;
import net.refractions.udig.catalog.wmsc.server.Capability;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import net.refractions.udig.catalog.wmsc.server.VendorSpecificCapabilities;
import net.refractions.udig.catalog.wmsc.server.WMSCCapabilities;
import net.refractions.udig.catalog.wmsc.server.WMSTileSet;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.ows.ServiceException;

public class WMSCServiceImpl
extends IService {
    private static final String CAPABILITIES_KEY = "net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.capabilities";
    public static final String WMSC_URL_KEY = "net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY";
    public static final String WMSC_WMS_KEY = "net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_WMS_KEY";
    private Map<String, Serializable> params;
    private URL url;
    private TiledWebMapServer wmsc;
    private Throwable msg;
    private List<IResolve> members;
    protected final Lock rLock = new UDIGDisplaySafeLock();
    private static final Lock dsLock = new UDIGDisplaySafeLock();

    WMSCServiceImpl(Map<String, Serializable> params) {
        this((URL)params.get(WMSC_URL_KEY), params);
    }

    WMSCServiceImpl(URL url, Map<String, Serializable> params) {
        this.params = params;
        this.url = url;
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public WMSCServieInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WMSCServieInfo)super.getInfo(monitor);
    }

    protected WMSCServieInfo createInfo(IProgressMonitor monitor) throws IOException {
        TiledWebMapServer tileServer = this.getWMSC();
        if (tileServer == null) {
            return null;
        }
        this.rLock.lock();
        try {
            WMSCServieInfo wMSCServieInfo = new WMSCServieInfo(this);
            return wMSCServieInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.getWMSC();
            this.rLock.lock();
            try {
                if (this.members == null) {
                    this.members = new LinkedList<IResolve>();
                    WMSCCapabilities capabilities = this.getWMSC().getCapabilities();
                    Capability capability = capabilities.getCapability();
                    VendorSpecificCapabilities vendorCapabilities = capability.getVSCapabilities();
                    if (vendorCapabilities != null) {
                        ArrayList<WMSTileSet> tiles = vendorCapabilities.getTiles();
                        if (tiles != null) {
                            for (WMSTileSet tileset : tiles) {
                                tileset.setServer(this.getWMSC());
                                this.members.add((IResolve)new WMSCGeoResourceImpl(this, tileset));
                            }
                            this.msg = null;
                        } else {
                            this.msg = new IllegalStateException("VendorCapabilities does not contain titles");
                        }
                    } else {
                        this.msg = new IllegalStateException("VendorCapabilities not available");
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.members;
    }

    public List<WMSCGeoResourceImpl> resources(IProgressMonitor monitor) throws IOException {
        this.members(monitor);
        ArrayList<WMSCGeoResourceImpl> children = new ArrayList<WMSCGeoResourceImpl>();
        Iterator<IResolve> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            children.add((WMSCGeoResourceImpl)iterator.next());
        }
        return children;
    }

    public URL getIdentifier() {
        return this.url;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee.isAssignableFrom(TiledWebMapServer.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee.isAssignableFrom(TiledWebMapServer.class)) {
            return adaptee.cast((Object)this.getWMSC());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public TiledWebMapServer getWMSC() {
        block13: {
            if (this.wmsc == null) {
                dsLock.lock();
                try {
                    try {
                        String xml;
                        if (this.msg != null) {
                            throw (IOException)this.msg;
                        }
                        if (this.wmsc != null) break block13;
                        Serializable serializable = (Serializable)this.getPersistentProperties().get(CAPABILITIES_KEY);
                        if (serializable != null) {
                            try {
                                xml = (String)((Object)serializable);
                                this.wmsc = new TiledWebMapServer(this.url, xml, true);
                            }
                            catch (Exception e) {
                                WmsPlugin.log("Restore from cached capabilities failed", e);
                            }
                        }
                        if (this.wmsc == null) {
                            try {
                                this.wmsc = new TiledWebMapServer(this.url);
                            }
                            catch (ServiceException e) {
                                WmsPlugin.log("Creating Tile Web Server failed", e);
                            }
                            xml = this.wmsc.getCapabilitiesXml();
                            this.getPersistentProperties().put(CAPABILITIES_KEY, xml);
                        }
                        this.msg = null;
                    }
                    catch (IOException couldNotConnext) {
                        this.msg = couldNotConnext;
                        dsLock.unlock();
                    }
                }
                finally {
                    dsLock.unlock();
                }
            }
        }
        return this.wmsc;
    }

    public IResolve.Status getStatus() {
        if (this.wmsc == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
        if (this.wmsc != null) {
            this.wmsc = null;
        }
    }
}

