/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceImpl;
import net.refractions.udig.catalog.wms.internal.Messages;

public class WMSCServiceExtension
implements ServiceExtension2 {
    public IService createService(URL id, Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        if (!params.containsKey("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY") && id != null) {
            return null;
        }
        URL extractedId = this.extractId(params);
        if (extractedId != null) {
            if (id != null) {
                return new WMSCServiceImpl(id, params);
            }
            return new WMSCServiceImpl(extractedId, params);
        }
        return null;
    }

    private URL extractId(Map<String, Serializable> params) {
        if (params.containsKey("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY")) {
            URL base = null;
            if (params.get("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY") instanceof URL) {
                base = (URL)params.get("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY");
            } else {
                try {
                    base = new URL((String)((Object)params.get("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY")));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    return null;
                }
                params.remove(params.get("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY"));
                params.put("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY", base);
            }
            return base;
        }
        return null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!WMSCServiceExtension.isWMSC(url)) {
            return null;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put("net.refractions.udig.catalog.internal.wms.WMSCServiceImpl.WMS_URL_KEY", url);
        return params2;
    }

    public static boolean isWMSC(URL url) {
        return WMSCServiceExtension.processURL(url) == null;
    }

    public String reasonForFailure(URL url) {
        return WMSCServiceExtension.processURL(url);
    }

    private static String processURL(URL url) {
        int found;
        if (url == null) {
            return Messages.WMSServiceExtension_nullURL;
        }
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (PROTOCOL == null || PROTOCOL.indexOf("http") == -1) {
            return String.valueOf(Messages.WMSServiceExtension_protocol) + "'" + PROTOCOL + "'";
        }
        int n = found = QUERY == null ? -1 : QUERY.toUpperCase().indexOf("TILED=TRUE");
        if (found != -1) {
            return null;
        }
        return Messages.WMSCServiceExtension_nottiled;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        URL url = this.extractId(params);
        return this.reasonForFailure(url);
    }
}

