/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.internal.wmsc.WMSCGeoResourceImpl;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.wms.xml.WMSSchema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSCGeoResourceInfo
extends IGeoResourceInfo {
    private final WMSCGeoResourceImpl resource;

    public WMSCGeoResourceInfo(WMSCGeoResourceImpl geoResourceImpl, IProgressMonitor monitor) throws IOException {
        this.resource = geoResourceImpl;
        TileSet tile = this.resource.getTileSet();
        this.name = tile.getLayers();
        this.title = String.valueOf(this.name) + "(" + tile.getEPSGCode() + ":" + tile.getFormat() + ")";
        this.description = String.valueOf(tile.getLayers()) + " : " + tile.getEPSGCode() + " : " + tile.getFormat();
        this.bounds = tile.getBounds();
        ArrayList<String> keywordsFromWMSC = new ArrayList<String>();
        keywordsFromWMSC.add("WMS-C");
        keywordsFromWMSC.add(this.name);
        this.keywords = keywordsFromWMSC.toArray(new String[keywordsFromWMSC.size()]);
        this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
    }

    public CoordinateReferenceSystem getCRS() {
        if (this.bounds == null) {
            return null;
        }
        return this.getBounds().getCoordinateReferenceSystem();
    }

    public URI getSchema() {
        return WMSSchema.NAMESPACE;
    }
}

