/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmsc;

import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.wmsc.WMSCGeoResourceInfo;
import net.refractions.udig.catalog.internal.wmsc.WMSCServiceImpl;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import net.refractions.udig.catalog.wmsc.server.WMSTileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class WMSCGeoResourceImpl
extends IGeoResource {
    private TileSet tile;
    private URL identifier;

    public WMSCGeoResourceImpl(WMSCServiceImpl service, TileSet tile) {
        this.service = service;
        try {
            this.identifier = new URL(String.valueOf(service.getIdentifier().toString()) + "#" + tile.getId());
        }
        catch (Exception exception) {
            this.identifier = service.getIdentifier();
        }
        this.tile = tile;
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.service;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(TiledWebMapServer.class) || adaptee.isAssignableFrom(WMSTileSet.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee.isAssignableFrom(TiledWebMapServer.class)) {
            return adaptee.cast((Object)this.service(monitor).getWMSC());
        }
        if (adaptee.isAssignableFrom(WMSTileSet.class)) {
            return adaptee.cast(this.tile);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public Throwable getMessage() {
        return this.service.getMessage();
    }

    public IResolve.Status getStatus() {
        return this.service.getStatus();
    }

    public WMSCGeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WMSCGeoResourceInfo)super.getInfo(monitor);
    }

    protected WMSCGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        WMSCServiceImpl tileServer = this.service((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        try {
            tileServer.rLock.lock();
            WMSCGeoResourceInfo wMSCGeoResourceInfo = new WMSCGeoResourceInfo(this, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            return wMSCGeoResourceInfo;
        }
        finally {
            tileServer.rLock.unlock();
        }
    }

    public WMSCServiceImpl service(IProgressMonitor monitor) throws IOException {
        return (WMSCServiceImpl)super.service(monitor);
    }

    public TileSet getTileSet() {
        return this.tile;
    }
}

