/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms.tileset;

import java.io.IOException;
import javax.management.ServiceNotFoundException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveAdapterFactory;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wmsc.WMSCTileUtils;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.wms.WebMapServer;

public class WMSCTileSetAdapter
implements IResolveAdapterFactory {
    public boolean canAdapt(IResolve resolve, Class<?> adapter) {
        if (adapter.isAssignableFrom(TileSet.class)) {
            IGeoResource resource = (IGeoResource)resolve;
            Boolean enabled = (Boolean)resource.getPersistentProperties().get("tilesetOnOff");
            return enabled != null && enabled != false;
        }
        return false;
    }

    public <T> T adapt(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
        AbstractOpenWebService server = null;
        if (resolve.canResolve(WebMapServer.class)) {
            server = (AbstractOpenWebService)resolve.resolve(WebMapServer.class, monitor);
        } else if (resolve.canResolve(TiledWebMapServer.class)) {
            server = (AbstractOpenWebService)resolve.resolve(TiledWebMapServer.class, monitor);
        } else {
            WmsPlugin.trace("WMS or WMST required", new ServiceNotFoundException());
            return null;
        }
        if (resolve instanceof IGeoResource && adapter.isAssignableFrom(TileSet.class)) {
            IGeoResource resource = (IGeoResource)resolve;
            TileSet tileSet = WMSCTileUtils.toTileSet(resource, server, monitor);
            return adapter.cast(tileSet);
        }
        return null;
    }
}

