/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import java.net.URI;
import java.net.URISyntaxException;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.wms.WMSServiceImpl;
import net.refractions.udig.catalog.wms.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.xml.WMSSchema;

class WMSServiceInfo
extends IServiceInfo {
    private WMSCapabilities caps = null;
    private final WMSServiceImpl service;

    WMSServiceInfo(WMSServiceImpl serviceImpl, IProgressMonitor monitor) {
        String[] t;
        this.service = serviceImpl;
        try {
            this.caps = this.service.getWMS(monitor).getCapabilities();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            this.caps = null;
        }
        String[] stringArray = this.caps == null ? null : (this.keywords = this.caps.getService() == null ? null : this.caps.getService().getKeywordList());
        if (this.keywords == null) {
            t = new String[2];
        } else {
            t = new String[this.keywords.length + 2];
            System.arraycopy(this.keywords, 0, t, 2, this.keywords.length);
        }
        t[0] = "WMS";
        t[1] = this.service.getIdentifier().toString();
        this.keywords = t;
        this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.internal.wms", (String)"icons/obj16/wms_obj.gif");
    }

    public String getAbstract() {
        return this.caps == null ? null : (this.caps.getService() == null ? null : this.caps.getService().get_abstract());
    }

    public String getDescription() {
        return this.service.getIdentifier().toString();
    }

    public URI getSchema() {
        return WMSSchema.NAMESPACE;
    }

    public URI getSource() {
        try {
            return this.service.getIdentifier().toURI();
        }
        catch (URISyntaxException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public String getTitle() {
        return this.caps == null || this.caps.getService() == null ? (this.service.getIdentifier() == null ? Messages.WMSServiceImpl_broken : this.service.getIdentifier().toString()) : this.caps.getService().getTitle();
    }

    public double getMetric() {
        return 0.9;
    }
}

