/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.wms.WMSFolder;
import net.refractions.udig.catalog.internal.wms.WMSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wms.internal.Messages;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.Specification;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.WMS1_1_0;
import org.geotools.data.wms.WMS1_1_1;
import org.geotools.data.wms.WMS1_3_0;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.ows.ServiceException;
import org.xml.sax.SAXException;

public class WMSServiceImpl
extends IService {
    public static final String WMS_URL_KEY = "net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY";
    public static final String WMS_WMS_KEY = "net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_WMS_KEY";
    private Map<String, Serializable> params;
    private Throwable error;
    private URL url;
    private volatile WebMapServer wms = null;
    protected final Lock rLock = new UDIGDisplaySafeLock();
    private volatile List<IResolve> members;
    private int currentFolderID = 0;
    private static final Lock dsLock = new UDIGDisplaySafeLock();

    public WMSServiceImpl(URL url, Map<String, Serializable> params) {
        Serializable obj;
        this.params = params;
        this.url = url;
        if (params.containsKey(WMS_WMS_KEY) && (obj = params.get(WMS_WMS_KEY)) instanceof WebMapServer) {
            this.wms = (WebMapServer)obj;
        }
    }

    public IResolve.Status getStatus() {
        if (this.wms == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    protected WebMapServer getWMS(IProgressMonitor theUserIsWatching) throws IOException {
        block10: {
            if (this.wms == null) {
                dsLock.lock();
                try {
                    if (this.wms != null) break block10;
                    try {
                        if (theUserIsWatching != null) {
                            String message = MessageFormat.format(Messages.WMSServiceImpl_connecting_to, this.url);
                            theUserIsWatching.beginTask(message, 100);
                        }
                        URL url1 = (URL)this.getConnectionParams().get(WMS_URL_KEY);
                        if (theUserIsWatching != null) {
                            theUserIsWatching.worked(5);
                        }
                        this.wms = new CustomWMS(url1);
                        if (theUserIsWatching != null) {
                            theUserIsWatching.done();
                        }
                    }
                    catch (IOException persived) {
                        this.error = persived;
                        throw persived;
                    }
                    catch (Throwable nak) {
                        IOException broken = new IOException(MessageFormat.format(Messages.WMSServiceImpl_could_not_connect, nak.getLocalizedMessage()));
                        broken.initCause(nak);
                        this.error = broken;
                        throw broken;
                    }
                }
                finally {
                    dsLock.unlock();
                }
            }
        }
        return this.wms;
    }

    public WMSServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WMSServiceInfo)super.getInfo(monitor);
    }

    protected WMSServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        WebMapServer webMapServer = this.getWMS(monitor);
        if (webMapServer == null) {
            return null;
        }
        this.rLock.lock();
        try {
            WMSServiceInfo wMSServiceInfo = new WMSServiceInfo(monitor);
            return wMSServiceInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return adaptee.cast(this.members(monitor));
        }
        if (adaptee.isAssignableFrom(WebMapServer.class)) {
            return adaptee.cast(this.getWMS(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(WebMapServer.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
        if (this.wms != null) {
            this.wms = null;
        }
    }

    public List<WMSGeoResourceImpl> resources(IProgressMonitor monitor) throws IOException {
        this.members(monitor);
        ArrayList<WMSGeoResourceImpl> children = new ArrayList<WMSGeoResourceImpl>();
        this.collectChildren((IResolve)this, children);
        return children;
    }

    private void collectChildren(IResolve resolve, List<WMSGeoResourceImpl> children) throws IOException {
        List resolves = resolve.members((IProgressMonitor)new NullProgressMonitor());
        if (resolves.isEmpty() && resolve instanceof WMSGeoResourceImpl) {
            children.add((WMSGeoResourceImpl)resolve);
        } else {
            for (IResolve resolve2 : resolves) {
                this.collectChildren(resolve2, children);
            }
        }
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.getWMS(monitor);
            this.rLock.lock();
            try {
                if (this.members == null) {
                    this.getWMS(monitor);
                    this.members = new LinkedList<IResolve>();
                    List layers = this.getWMS(monitor).getCapabilities().getLayerList();
                    if (layers != null) {
                        for (Layer layer : layers) {
                            if (layer.getParent() != null) continue;
                            if (layer.getName() == null) {
                                this.members.add((IResolve)new WMSFolder(this, null, layer));
                                continue;
                            }
                            this.members.add((IResolve)new WMSGeoResourceImpl(this, null, layer));
                        }
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.members;
    }

    public Throwable getMessage() {
        return this.error;
    }

    public URL getIdentifier() {
        return this.url;
    }

    public int nextFolderID() {
        return this.currentFolderID++;
    }

    public static class CustomWMS
    extends WebMapServer {
        public CustomWMS(URL serverURL) throws IOException, ServiceException, SAXException {
            super(serverURL);
            if (WmsPlugin.isDebugging("net.refractions.udig.catalog.wms/debug/request")) {
                System.out.println("Connection to WMS located at: " + serverURL);
            }
            if (this.getCapabilities() == null) {
                throw new IOException("Unable to parse capabilities document.");
            }
        }

        public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest arg0) throws IOException, ServiceException {
            WmsPlugin.trace("GetCapabilities: " + arg0.getFinalURL(), null);
            return super.issueRequest(arg0);
        }

        public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest arg0) throws IOException, ServiceException {
            WmsPlugin.trace("GetFeatureInfo: " + arg0.getFinalURL(), null);
            return super.issueRequest(arg0);
        }

        public GetMapResponse issueRequest(GetMapRequest arg0) throws IOException, ServiceException {
            WmsPlugin.trace("GetMap: " + arg0.getFinalURL(), null);
            return super.issueRequest(arg0);
        }

        protected void setupSpecifications() {
            this.specs = new Specification[4];
            this.specs[0] = new WMS1_0_0();
            this.specs[1] = new WMS1_1_0();
            this.specs[2] = new WMS1_1_1();
            this.specs[3] = new WMS1_3_0();
        }
    }

    class WMSServiceInfo
    extends IServiceInfo {
        private WMSCapabilities caps = null;

        WMSServiceInfo(IProgressMonitor monitor) {
            String[] t;
            try {
                this.caps = WMSServiceImpl.this.getWMS(monitor).getCapabilities();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                this.caps = null;
            }
            String[] stringArray = this.caps == null ? null : (this.keywords = this.caps.getService() == null ? null : this.caps.getService().getKeywordList());
            if (this.keywords == null) {
                t = new String[2];
            } else {
                t = new String[this.keywords.length + 2];
                System.arraycopy(this.keywords, 0, t, 2, this.keywords.length);
            }
            t[0] = "WMS";
            t[1] = WMSServiceImpl.this.getIdentifier().toString();
            this.keywords = t;
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.internal.wms", (String)"icons/obj16/wms_obj.gif");
        }

        public String getAbstract() {
            return this.caps == null ? null : (this.caps.getService() == null ? null : this.caps.getService().get_abstract());
        }

        public String getDescription() {
            return WMSServiceImpl.this.getIdentifier().toString();
        }

        public URI getSchema() {
            return WMSSchema.NAMESPACE;
        }

        public URI getSource() {
            try {
                return WMSServiceImpl.this.getIdentifier().toURI();
            }
            catch (URISyntaxException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public String getTitle() {
            return this.caps == null || this.caps.getService() == null ? (WMSServiceImpl.this.getIdentifier() == null ? Messages.WMSServiceImpl_broken : WMSServiceImpl.this.getIdentifier().toString()) : this.caps.getService().getTitle();
        }
    }
}

