/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.internal.wms.WMSGeoResourceImpl;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSGeoResourceInfo
extends IGeoResourceInfo {
    private final WMSGeoResourceImpl resource;

    WMSGeoResourceInfo(WMSGeoResourceImpl geoResourceImpl, IProgressMonitor monitor) throws IOException {
        this.resource = geoResourceImpl;
        WebMapServer wms = this.resource.service(monitor).getWMS(monitor);
        WMSCapabilities caps = wms.getCapabilities();
        this.bounds = WMSGeoResourceInfo.bbox(this.resource.layer);
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        }
        String parentid = this.resource.service(monitor) != null && this.resource.service(monitor).getIdentifier() != null ? this.resource.getIdentifier().toString() : "";
        this.name = this.resource.layer.getName();
        ArrayList<String> keywordsFromWMS = new ArrayList<String>();
        if (caps.getService().getKeywordList() != null) {
            keywordsFromWMS.addAll(Arrays.asList(caps.getService().getKeywordList()));
        }
        if (this.resource.layer.getKeywords() != null) {
            keywordsFromWMS.addAll(Arrays.asList(this.resource.layer.getKeywords()));
        }
        keywordsFromWMS.add("WMS");
        keywordsFromWMS.add(this.resource.layer.getName());
        keywordsFromWMS.add(caps.getService().getName());
        keywordsFromWMS.add(parentid);
        this.keywords = keywordsFromWMS.toArray(new String[keywordsFromWMS.size()]);
        this.description = this.resource.layer.get_abstract() != null && this.resource.layer.get_abstract().length() != 0 ? this.resource.layer.get_abstract() : caps.getService().get_abstract();
        this.description = caps.getService().get_abstract();
        this.title = this.resource.layer.getTitle() != null && this.resource.layer.getTitle().length() != 0 ? this.resource.layer.getTitle() : caps.getService().getTitle();
        this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
    }

    public static ReferencedEnvelope bbox(Layer layer) {
        GeneralEnvelope env;
        DefaultGeographicCRS crs;
        Map boundingBoxes = layer.getBoundingBoxes();
        if (boundingBoxes.isEmpty()) {
            crs = DefaultGeographicCRS.WGS84;
            env = layer.getEnvelope((CoordinateReferenceSystem)crs);
        } else {
            String epsg4326 = "EPSG:4326";
            String epsg4269 = "EPSG:4269";
            CRSEnvelope bbox = boundingBoxes.containsKey(epsg4326) ? (CRSEnvelope)boundingBoxes.get(epsg4326) : (boundingBoxes.containsKey(epsg4269) ? (CRSEnvelope)boundingBoxes.get(epsg4269) : (CRSEnvelope)boundingBoxes.values().iterator().next());
            try {
                crs = CRS.decode((String)bbox.getEPSGCode());
                env = new ReferencedEnvelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), (CoordinateReferenceSystem)crs);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                crs = DefaultGeographicCRS.WGS84;
                env = layer.getEnvelope((CoordinateReferenceSystem)crs);
            }
            catch (FactoryException factoryException) {
                crs = DefaultGeographicCRS.WGS84;
                env = layer.getEnvelope((CoordinateReferenceSystem)crs);
            }
        }
        return new ReferencedEnvelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1), (CoordinateReferenceSystem)crs);
    }

    public String getName() {
        return this.name;
    }

    public URI getSchema() {
        return WMSSchema.NAMESPACE;
    }

    public String getTitle() {
        return this.title;
    }
}

