/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wms.WMSFolder;
import net.refractions.udig.catalog.internal.wms.WMSServiceImpl;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.wms.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetLegendGraphicRequest;
import org.geotools.data.wms.response.GetLegendGraphicResponse;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSGeoResourceImpl
extends IGeoResource {
    Layer layer;
    private ImageDescriptor icon;
    private URL identifier;
    private ArrayList<IResolve> members;
    private IResolve parent;
    private Lock iconLock = new ReentrantLock();

    public WMSGeoResourceImpl(WMSServiceImpl service, IResolve parent, Layer layer) {
        this.service = service;
        this.parent = parent == null ? service : parent;
        this.layer = layer;
        this.members = new ArrayList();
        Layer[] layerArray = layer.getChildren();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer child = layerArray[n2];
            if (child != layer) {
                if (child.getName() == null) {
                    this.members.add((IResolve)new WMSFolder(service, (IResolve)this, child));
                } else {
                    this.members.add((IResolve)new WMSGeoResourceImpl(service, (IResolve)this, child));
                }
            }
            ++n2;
        }
        try {
            String name = layer.getName();
            if (name == null) {
                WmsPlugin.log("Can't get a unique name for the identifier of WMSGeoResource: " + layer, null);
                throw new RuntimeException("This should be a WMSFolder not an IGeoResource");
            }
            this.identifier = new URL(String.valueOf(service.getIdentifier().toString()) + "#" + name);
        }
        catch (Throwable e) {
            WmsPlugin.log(null, e);
            this.identifier = service.getIdentifier();
        }
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public IResolve.Status getStatus() {
        return this.service.getStatus();
    }

    public WMSResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WMSResourceInfo)super.getInfo(monitor);
    }

    protected WMSResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        WMSServiceImpl wmsServer = this.service((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        wmsServer.rLock.lock();
        try {
            WMSResourceInfo wMSResourceInfo = new WMSResourceInfo((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            return wMSResourceInfo;
        }
        finally {
            wmsServer.rLock.unlock();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public List<IResolve> members(IProgressMonitor monitor) {
        return this.members;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            throw new NullPointerException();
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(WebMapServer.class)) {
            return adaptee.cast(this.service(monitor).getWMS(monitor));
        }
        if (adaptee.isAssignableFrom(Layer.class)) {
            return adaptee.cast(this.layer);
        }
        if (adaptee.isAssignableFrom(ImageDescriptor.class)) {
            return adaptee.cast(this.getIcon(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public ImageDescriptor getIcon(IProgressMonitor monitor) throws IOException {
        this.iconLock.lock();
        try {
            if (this.icon == null) {
                this.icon = WMSGeoResourceImpl.fetchIcon(monitor, this.layer, this.service(monitor));
                if (this.icon == null) {
                    this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
                }
            }
            ImageDescriptor imageDescriptor = this.icon;
            return imageDescriptor;
        }
        finally {
            this.iconLock.unlock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static ImageDescriptor fetchIcon(IProgressMonitor monitor, Layer layer, WMSServiceImpl service) {
        try {
            if (monitor != null) {
                monitor.beginTask(Messages.WMSGeoResourceImpl_acquiring_task, 3);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (layer.getChildren() != null && layer.getChildren().length != 0) {
                return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
            }
            ImageDescriptor imageDescriptor = WMSGeoResourceImpl.requestImage(monitor, layer, service);
            Image image = null;
            Image swatch = null;
            try {
                if (monitor != null) {
                    monitor.worked(2);
                }
                if (monitor != null) {
                    monitor.subTask(Messages.WMSGeoResourceImpl_downloading_icon);
                }
                image = imageDescriptor.createImage();
                Rectangle bound = image.getBounds();
                if (bound.width == 16 && bound.height == 16) {
                    final ImageData data = (ImageData)image.getImageData().clone();
                    ImageDescriptor imageDescriptor2 = new ImageDescriptor(){

                        public ImageData getImageData() {
                            return (ImageData)data.clone();
                        }
                    };
                    return imageDescriptor2;
                }
                if (bound.height < 16 || bound.width < 16) {
                    if (WmsPlugin.getDefault().isDebugging()) {
                        System.out.println("Icon scaled up to requested size");
                    }
                    final ImageData data = image.getImageData().scaledTo(16, 16);
                    ImageDescriptor imageDescriptor3 = new ImageDescriptor(){

                        public ImageData getImageData() {
                            return (ImageData)data.clone();
                        }
                    };
                    return imageDescriptor3;
                }
                swatch = new Image(null, 16, 16);
                GC gc = new GC((Drawable)swatch);
                int sy = 0;
                int sx = 0;
                int sw = 0;
                int sh = 0;
                ImageData contents = image.getImageData();
                if (contents == null) {
                    ImageDescriptor imageDescriptor4 = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_missing_obj.gif");
                    return imageDescriptor4;
                }
                if (contents.maskData != null) {
                    byte mask;
                    int maskPad = contents.maskPad;
                    int scanLine = ((contents.width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                    int y = 0;
                    block8: while (y < contents.height / 2) {
                        sy = y;
                        int x = 0;
                        while (x < contents.width / 2) {
                            mask = contents.maskData[y * scanLine + x];
                            if (mask != 0) break block8;
                            ++x;
                        }
                        ++y;
                    }
                    int x = 0;
                    block10: while (x < contents.width / 2) {
                        sx = x;
                        int y2 = sy;
                        while (y2 < contents.height / 2) {
                            mask = contents.maskData[y2 * scanLine + x];
                            if (mask != 0) break block10;
                            ++y2;
                        }
                        ++x;
                    }
                    sh = Math.min(contents.height - sy, 16);
                    sw = Math.min(contents.width - sx, 16);
                    if (WmsPlugin.getDefault().isDebugging()) {
                        System.out.println("Mask offset to " + sx + "x" + sy);
                    }
                } else if (contents.alphaData != null) {
                    byte alpha;
                    int y = 0;
                    block12: while (y < contents.height / 2) {
                        sy = y;
                        int x = 0;
                        while (x < contents.width / 2) {
                            alpha = contents.alphaData[y * contents.width + x];
                            if (alpha != 0) break block12;
                            ++x;
                        }
                        ++y;
                    }
                    int x = 0;
                    block14: while (x < contents.width / 2) {
                        sx = x;
                        int y3 = sy;
                        while (y3 < contents.height / 2) {
                            alpha = contents.alphaData[y3 * contents.width + x];
                            if (alpha != 0) break block14;
                            ++y3;
                        }
                        ++x;
                    }
                    sh = Math.min(contents.height - sy, 16);
                    sw = Math.min(contents.width - sx, 16);
                    if (WmsPlugin.getDefault().isDebugging()) {
                        System.out.println("Alpha offset to " + sx + "x" + sy);
                    }
                } else {
                    byte datum;
                    int depth = contents.depth;
                    int scanLine = contents.bytesPerLine;
                    int y = 0;
                    block16: while (y < contents.height / 2) {
                        sy = y;
                        int x = 0;
                        while (x < contents.width / 2) {
                            datum = contents.data[y * scanLine + x * depth];
                            if (datum != 0) break block16;
                            ++x;
                        }
                        ++y;
                    }
                    int x = 0;
                    block18: while (x < contents.width / 2) {
                        sx = x;
                        int y4 = sy;
                        while (y4 < contents.height / 2) {
                            datum = contents.data[y4 * scanLine + x * depth];
                            if (datum != 0) break block18;
                            ++y4;
                        }
                        ++x;
                    }
                    sh = Math.min(contents.height - sy, 16);
                    sw = Math.min(contents.width - sx, 16);
                    if (WmsPlugin.getDefault().isDebugging()) {
                        System.out.println("Alpha offset to " + sx + "x" + sy);
                    }
                }
                if (WmsPlugin.getDefault().isDebugging()) {
                    System.out.println("Image resized to " + sh + "x" + sw);
                }
                gc.drawImage(image, 0, bound.height - 16, 16, 16, 0, 0, 16, 16);
                final ImageData data = (ImageData)swatch.getImageData().clone();
                ImageDescriptor imageDescriptor5 = new ImageDescriptor(){

                    public ImageData getImageData() {
                        return (ImageData)data.clone();
                    }
                };
                return imageDescriptor5;
            }
            finally {
                if (image != null) {
                    image.dispose();
                }
                if (swatch != null) {
                    swatch.dispose();
                }
                if (monitor != null) {
                    monitor.worked(3);
                }
            }
        }
        catch (IOException t) {
            WmsPlugin.trace("Could not get icon", t);
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_missing_obj.gif");
        }
    }

    private static ImageDescriptor requestImage(IProgressMonitor monitor, Layer layer, WMSServiceImpl service) throws IOException {
        WebMapServer wms = service.getWMS(monitor);
        if (wms.getCapabilities().getRequest().getGetLegendGraphic() == null) {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }
        ImageDescriptor imageDescriptor = null;
        try {
            GetLegendGraphicRequest request = wms.createGetLegendGraphicRequest();
            request.setLayer(layer.getName());
            request.setWidth("16");
            request.setHeight("16");
            List formats = wms.getCapabilities().getRequest().getGetLegendGraphic().getFormats();
            Collections.sort(formats, new Comparator<String>(){

                @Override
                public int compare(String format1, String format2) {
                    if (format1.trim().equalsIgnoreCase("image/png")) {
                        return -1;
                    }
                    if (format2.trim().equalsIgnoreCase("image/png")) {
                        return 1;
                    }
                    if (format1.trim().equalsIgnoreCase("image/gif")) {
                        return -1;
                    }
                    if (format2.trim().equalsIgnoreCase("image/gif")) {
                        return 1;
                    }
                    return 0;
                }
            });
            Iterator iterator = formats.iterator();
            while (iterator.hasNext() && imageDescriptor == null) {
                String format = (String)iterator.next();
                imageDescriptor = WMSGeoResourceImpl.loadImageDescriptor(wms, request, format);
            }
            if (imageDescriptor == null) {
                return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
            }
        }
        catch (UnsupportedOperationException notAvailable) {
            WmsPlugin.trace("Icon is not available", notAvailable);
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }
        catch (ServiceException e) {
            WmsPlugin.trace("Icon is not available", e);
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }
        return imageDescriptor;
    }

    private static ImageDescriptor loadImageDescriptor(WebMapServer wms, GetLegendGraphicRequest request, String desiredFormat) throws IOException, ServiceException {
        if (desiredFormat == null) {
            return null;
        }
        try {
            request.setFormat(desiredFormat);
            if (!wms.getCapabilities().getVersion().startsWith("1.3")) {
                request.setStyle("");
            }
            System.out.println(request.getFinalURL().toExternalForm());
            GetLegendGraphicResponse response = wms.issueRequest(request);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)WMSGeoResourceImpl.getImageData(response.getInputStream()));
            return imageDescriptor;
        }
        catch (SWTException exc) {
            WmsPlugin.trace("Icon is not available or has unsupported format", exc);
            return null;
        }
    }

    private static ImageData getImageData(InputStream in) {
        ImageData result;
        block13: {
            result = null;
            if (in != null) {
                try {
                    try {
                        result = new ImageData(in);
                    }
                    catch (SWTException e) {
                        if (e.code != 40) {
                            throw e;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(WebMapServer.class) || adaptee.isAssignableFrom(Layer.class) || adaptee.isAssignableFrom(ImageDescriptor.class) || adaptee.isAssignableFrom(IService.class) || super.canResolve(adaptee);
    }

    public Throwable getMessage() {
        return this.service.getMessage();
    }

    public WMSServiceImpl service(IProgressMonitor monitor) throws IOException {
        return (WMSServiceImpl)super.service(monitor);
    }

    private class WMSResourceInfo
    extends IGeoResourceInfo {
        WMSResourceInfo(IProgressMonitor monitor) throws IOException {
            WebMapServer wms = WMSGeoResourceImpl.this.service(monitor).getWMS(monitor);
            WMSCapabilities caps = wms.getCapabilities();
            if (WMSGeoResourceImpl.this.layer.getTitle() != null && WMSGeoResourceImpl.this.layer.getTitle().length() != 0) {
                this.title = WMSGeoResourceImpl.this.layer.getTitle();
            }
            this.calculateBounds();
            String parentid = WMSGeoResourceImpl.this.service != null && WMSGeoResourceImpl.this.service.getIdentifier() != null ? WMSGeoResourceImpl.this.getIdentifier().toString() : "";
            this.name = WMSGeoResourceImpl.this.layer.getName();
            this.getKeywords(caps, parentid);
            this.description = WMSGeoResourceImpl.this.layer.get_abstract() != null && WMSGeoResourceImpl.this.layer.get_abstract().length() != 0 ? WMSGeoResourceImpl.this.layer.get_abstract() : caps.getService().get_abstract();
            this.description = caps.getService().get_abstract();
            this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }

        private void getKeywords(WMSCapabilities caps, String parentid) {
            ArrayList<String> keywordsFromWMS = new ArrayList<String>();
            if (caps.getService().getKeywordList() != null) {
                keywordsFromWMS.addAll(Arrays.asList(caps.getService().getKeywordList()));
            }
            if (WMSGeoResourceImpl.this.layer.getKeywords() != null) {
                keywordsFromWMS.addAll(Arrays.asList(WMSGeoResourceImpl.this.layer.getKeywords()));
            }
            keywordsFromWMS.add("WMS");
            keywordsFromWMS.add(WMSGeoResourceImpl.this.layer.getName());
            keywordsFromWMS.add(caps.getService().getName());
            keywordsFromWMS.add(parentid);
            this.keywords = keywordsFromWMS.toArray(new String[keywordsFromWMS.size()]);
        }

        private void calculateBounds() {
            GeneralEnvelope env = null;
            DefaultGeographicCRS crs = null;
            Map boundingBoxes = WMSGeoResourceImpl.this.layer.getBoundingBoxes();
            if (boundingBoxes.isEmpty()) {
                crs = DefaultGeographicCRS.WGS84;
                env = WMSGeoResourceImpl.this.layer.getEnvelope((CoordinateReferenceSystem)crs);
            } else {
                GeneralEnvelope layerDefinedEnv = WMSGeoResourceImpl.this.layer.getEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                String epsg4326 = "EPSG:4326";
                String epsg4269 = "EPSG:4269";
                CRSEnvelope bbox = boundingBoxes.size() < 4 ? (CRSEnvelope)boundingBoxes.values().iterator().next() : (boundingBoxes.containsKey(epsg4326) ? (CRSEnvelope)boundingBoxes.get(epsg4326) : (boundingBoxes.containsKey(epsg4269) ? (CRSEnvelope)boundingBoxes.get(epsg4269) : (CRSEnvelope)boundingBoxes.values().iterator().next()));
                try {
                    if (bbox.getEPSGCode().equals(epsg4269) || bbox.getEPSGCode().equals(epsg4326)) {
                        env = layerDefinedEnv;
                        crs = DefaultGeographicCRS.WGS84;
                    } else {
                        crs = CRS.decode((String)bbox.getEPSGCode());
                        env = new ReferencedEnvelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), (CoordinateReferenceSystem)crs);
                    }
                }
                catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    crs = DefaultGeographicCRS.WGS84;
                    env = WMSGeoResourceImpl.this.layer.getEnvelope((CoordinateReferenceSystem)crs);
                }
                catch (FactoryException factoryException) {
                    crs = DefaultGeographicCRS.WGS84;
                    env = WMSGeoResourceImpl.this.layer.getEnvelope((CoordinateReferenceSystem)crs);
                }
            }
            this.bounds = new ReferencedEnvelope(new Envelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1)), (CoordinateReferenceSystem)crs);
        }

        public String getName() {
            return this.name;
        }

        public URI getSchema() {
            return WMSSchema.NAMESPACE;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

