/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wms;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wms.WMSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wms.WMSServiceImpl;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;

public class WMSFolder
implements IResolveFolder {
    private WMSServiceImpl service;
    private IResolve parent;
    private Layer layer;
    private ArrayList<IResolve> members;
    private URL identifier;
    private ImageDescriptor icon;
    private Lock iconLock = new ReentrantLock();

    public WMSFolder(WMSServiceImpl service, IResolve parent, Layer layer) {
        this.service = service;
        this.parent = parent == null ? service : parent;
        this.layer = layer;
        this.members = new ArrayList();
        Layer[] layerArray = layer.getChildren();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer child = layerArray[n2];
            if (child != layer) {
                if (child.getName() == null) {
                    this.members.add((IResolve)new WMSFolder(service, (IResolve)this, child));
                } else {
                    this.members.add((IResolve)new WMSGeoResourceImpl(service, (IResolve)this, child));
                }
            }
            ++n2;
        }
        try {
            String name = layer.getTitle();
            if (name == null) {
                name = String.valueOf(service.nextFolderID());
            }
            this.identifier = new URL(String.valueOf(service.getIdentifier().toString()) + "#" + name);
        }
        catch (Throwable e) {
            WmsPlugin.log(null, e);
            this.identifier = service.getIdentifier();
        }
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.isAssignableFrom(WMSFolder.class) || adaptee.isAssignableFrom(WebMapServer.class) || adaptee.isAssignableFrom(Layer.class) || adaptee.isAssignableFrom(ImageDescriptor.class) || adaptee.isAssignableFrom(IService.class)) {
            return true;
        }
        return CatalogPlugin.getDefault().getResolveManager().canResolve((IResolve)this, adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public ID getID() {
        return new ID(this.getIdentifier());
    }

    public Throwable getMessage() {
        return null;
    }

    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        return this.members;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            throw new NullPointerException();
        }
        if (adaptee.isAssignableFrom(WMSFolder.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(WebMapServer.class)) {
            return adaptee.cast(this.service.getWMS(monitor));
        }
        if (adaptee.isAssignableFrom(Layer.class)) {
            return adaptee.cast(this.layer);
        }
        if (adaptee.isAssignableFrom(ImageDescriptor.class)) {
            return adaptee.cast(this.getIcon(monitor));
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve((IResolve)this, adaptee)) {
            return (T)rm.resolve((IResolve)this, adaptee, monitor);
        }
        return null;
    }

    public ImageDescriptor getIcon(IProgressMonitor monitor) {
        this.iconLock.lock();
        try {
            if (this.icon == null) {
                this.icon = WMSGeoResourceImpl.fetchIcon(monitor, this.layer, this.service);
                if (this.icon == null) {
                    this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
                }
            }
            ImageDescriptor imageDescriptor = this.icon;
            return imageDescriptor;
        }
        finally {
            this.iconLock.unlock();
        }
    }

    public String getTitle() {
        return this.layer.getTitle();
    }

    public IService getService(IProgressMonitor monitor) {
        return this.service;
    }
}

