/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.logging.Logger;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.impl.AttributeEncodeExecutor;
import org.geotools.xml.impl.BindingVisitorDispatch;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xml.impl.ElementEncodeExecutor;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementEncoder {
    private BindingWalker bindingWalker;
    private MutablePicoContainer context;
    private Logger logger;

    public ElementEncoder(BindingWalker bindingWalker, MutablePicoContainer context) {
        this.bindingWalker = bindingWalker;
        this.context = context;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Element encode(Object value, XSDElementDeclaration element, Document document) {
        return this.encode(value, element, document, null);
    }

    public Element encode(Object value, XSDElementDeclaration element, Document document, XSDTypeDefinition container) {
        ElementEncodeExecutor executor = new ElementEncodeExecutor(value, element, document, this.logger);
        BindingVisitorDispatch.walk(value, this.bindingWalker, (XSDFeature)element, executor, container, this.context);
        return executor.getEncodedElement();
    }

    public Attr encode(Object value, XSDAttributeDeclaration attribute, Document document, XSDTypeDefinition container) {
        AttributeEncodeExecutor executor = new AttributeEncodeExecutor(value, attribute, document, this.logger);
        BindingVisitorDispatch.walk(value, this.bindingWalker, (XSDFeature)attribute, executor, container, this.context);
        return executor.getEncodedAttribute();
    }

    public void setContext(MutablePicoContainer context) {
        this.context = context;
    }
}

