/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DataUtilities {
    public static List parseSimpleData(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Null 's' argument.");
        }
        ArrayList dataset = new ArrayList();
        StringCharacterIterator iterator = new StringCharacterIterator(s, 2);
        ArrayList<Double> series = new ArrayList<Double>();
        while (iterator.current() != '\uffff') {
            char c = iterator.current();
            if (c == ',') {
                dataset.add(series);
                series = new ArrayList();
            } else {
                int v = DataUtilities.googleValue(c);
                if (v < Integer.MAX_VALUE) {
                    series.add(new Double((double)v / 61.0));
                } else {
                    series.add(null);
                }
            }
            iterator.next();
        }
        dataset.add(series);
        return dataset;
    }

    public static List parseExtendedData(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Null 's' argument.");
        }
        ArrayList dataset = new ArrayList();
        StringCharacterIterator iterator = new StringCharacterIterator(s, 2);
        ArrayList<Double> series = new ArrayList<Double>();
        while (iterator.current() != '\uffff') {
            char c1 = iterator.current();
            if (c1 == ',') {
                dataset.add(series);
                series = new ArrayList();
            } else {
                char c2 = iterator.next();
                int c1v = DataUtilities.googleValueExt(c1);
                int c2v = DataUtilities.googleValueExt(c2);
                if (c1v < Integer.MAX_VALUE && c2v < Integer.MAX_VALUE) {
                    series.add(new Double(((double)c1v * 64.0 + (double)c2v) / 4095.0));
                } else {
                    series.add(null);
                }
            }
            iterator.next();
        }
        dataset.add(series);
        return dataset;
    }

    public static List parseTextData(String dataStr, float[] scaling) {
        ArrayList dataset = new ArrayList();
        StringCharacterIterator iterator = new StringCharacterIterator(dataStr, 2);
        ArrayList<Float> series = new ArrayList<Float>();
        int baseIndex = 2;
        float min = DataUtilities.getScalingMin(scaling, 0);
        float max = DataUtilities.getScalingMax(scaling, 0);
        while (iterator.current() != '\uffff') {
            char c = iterator.current();
            if (c >= '0' && c <= '9' || c == '-' || c == '.' || c == 'E') {
                iterator.next();
                continue;
            }
            if (c == ',') {
                series.add(DataUtilities.parseSingleNumber(dataStr.substring(baseIndex, iterator.getIndex()), min, max));
                baseIndex = iterator.getIndex() + 1;
                iterator.next();
                continue;
            }
            if (c == '|') {
                series.add(DataUtilities.parseSingleNumber(dataStr.substring(baseIndex, iterator.getIndex()), min, max));
                baseIndex = iterator.getIndex() + 1;
                dataset.add(series);
                series = new ArrayList();
                iterator.next();
                min = DataUtilities.getScalingMin(scaling, dataset.size());
                max = DataUtilities.getScalingMax(scaling, dataset.size());
                continue;
            }
            throw new IllegalArgumentException("'data' contains bad characters.");
        }
        series.add(DataUtilities.parseSingleNumber(dataStr.substring(baseIndex, iterator.getIndex()), min, max));
        dataset.add(series);
        return dataset;
    }

    private static Float parseSingleNumber(String number, float min, float max) {
        float val = (Float.parseFloat(number) - min) / (max - min);
        if (val >= 0.0f) {
            return new Float(Math.min(val, 1.0f));
        }
        return null;
    }

    private static int googleValue(char c) {
        if (c == '_') {
            return Integer.MAX_VALUE;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        throw new IllegalArgumentException("Invalid character '" + c + "'.");
    }

    private static int googleValueExt(char c) {
        if (c == '_') {
            return Integer.MAX_VALUE;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '-') {
            return 62;
        }
        if (c == '.') {
            return 63;
        }
        throw new IllegalArgumentException("Invalid character '" + c + "'.");
    }

    public static float[] parseDataScaling(String scalingStr) {
        if (scalingStr == null) {
            return new float[]{0.0f, 100.0f};
        }
        String[] parts = scalingStr.split(",");
        if (parts.length == 0) {
            return new float[]{0.0f, 100.0f};
        }
        float[] result = new float[parts.length + 1 >> 1 << 1];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = "".equals(parts[i]) ? 0.0f : Float.parseFloat(parts[i]);
        }
        if (result.length > parts.length) {
            result[result.length - 1] = 100.0f;
        }
        return result;
    }

    private static float getScaling(float[] scaling, int datasetIndex, int offset) {
        int i = datasetIndex * 2;
        if (i < scaling.length) {
            return scaling[i + offset];
        }
        return scaling[scaling.length - 2 + offset];
    }

    private static float getScalingMin(float[] scaling, int datasetIndex) {
        return DataUtilities.getScaling(scaling, datasetIndex, 0);
    }

    private static float getScalingMax(float[] scaling, int datasetIndex) {
        return DataUtilities.getScaling(scaling, datasetIndex, 1);
    }

    public static PieDataset parsePieDataset(String dataStr, String scalingStr) {
        if (dataStr == null) {
            throw new IllegalArgumentException("Null 'dataStr' argument.");
        }
        DefaultPieDataset result = new DefaultPieDataset();
        List dataList = null;
        if (dataStr.startsWith("s:")) {
            dataList = DataUtilities.parseSimpleData(dataStr);
        } else if (dataStr.startsWith("t:")) {
            float[] scaling = DataUtilities.parseDataScaling(scalingStr);
            dataList = DataUtilities.parseTextData(dataStr, scaling);
        } else if (dataStr.startsWith("e:")) {
            dataList = DataUtilities.parseExtendedData(dataStr);
        } else {
            throw new RuntimeException("Unrecognised data encoding: " + dataStr.substring(0, 2));
        }
        if (dataList.size() > 0) {
            List series = (List)dataList.get(0);
            int s = 1;
            Iterator iterator = series.iterator();
            while (iterator.hasNext()) {
                Number i = (Number)iterator.next();
                result.setValue((Comparable)((Object)("S" + s)), i);
                ++s;
            }
        } else {
            throw new RuntimeException("Empty data list.");
        }
        return result;
    }

    public static DefaultCategoryDataset parseCategoryDataset(String dataStr, String scalingStr) {
        if (dataStr == null) {
            throw new IllegalArgumentException("Null 'dataStr' argument.");
        }
        List dataList = null;
        if (dataStr.startsWith("s:")) {
            dataList = DataUtilities.parseSimpleData(dataStr);
        } else if (dataStr.startsWith("t:")) {
            float[] scaling = DataUtilities.parseDataScaling(scalingStr);
            dataList = DataUtilities.parseTextData(dataStr, scaling);
        } else if (dataStr.startsWith("e:")) {
            dataList = DataUtilities.parseExtendedData(dataStr);
        } else {
            throw new RuntimeException("Unrecognised data encoding: " + dataStr.substring(0, 2));
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int i = 0; i < dataList.size(); ++i) {
            List values = (List)dataList.get(i);
            for (int j = 0; j < values.size(); ++j) {
                Number n = (Number)values.get(j);
                if (n != null) {
                    double y = n.doubleValue();
                    result.setValue(y, (Comparable)((Object)String.valueOf(i)), (Comparable)((Object)String.valueOf(j)));
                    continue;
                }
                result.setValue(n, (Comparable)((Object)String.valueOf(i)), (Comparable)((Object)String.valueOf(j)));
            }
        }
        return result;
    }

    public static XYDataset parseXYDataset(String dataStr, String scalingStr) {
        List dataList;
        if (dataStr == null) {
            throw new IllegalArgumentException("Null 'dataStr' argument.");
        }
        if (dataStr.startsWith("s:")) {
            dataList = DataUtilities.parseSimpleData(dataStr);
        } else if (dataStr.startsWith("t:")) {
            float[] scaling = DataUtilities.parseDataScaling(scalingStr);
            dataList = DataUtilities.parseTextData(dataStr, scaling);
        } else if (dataStr.startsWith("e:")) {
            dataList = DataUtilities.parseExtendedData(dataStr);
        } else {
            throw new RuntimeException("Unrecognised data encoding: " + dataStr.substring(0, 2));
        }
        XYSeriesCollection result = new XYSeriesCollection();
        for (int s = 0; s < dataList.size(); ++s) {
            List series = (List)dataList.get(s);
            XYSeries ss = new XYSeries((Comparable)((Object)("Series " + (s + 1))));
            int itemCount = series.size();
            double increment = 1.0 / (double)Math.max(itemCount - 1, 1);
            for (int i = 0; i < itemCount; ++i) {
                Number n = (Number)series.get(i);
                if (n != null) {
                    double y = n.doubleValue();
                    ss.add((double)i * increment, y);
                    continue;
                }
                ss.add((double)i * increment, null);
            }
            result.addSeries(ss);
        }
        return result;
    }

    public static XYDataset parseXYDataset2(String dataStr, String scalingStr) {
        List dataList;
        if (dataStr == null) {
            throw new IllegalArgumentException("Null 'dataStr' argument.");
        }
        if (dataStr.startsWith("s:")) {
            dataList = DataUtilities.parseSimpleData(dataStr);
        } else if (dataStr.startsWith("t:")) {
            float[] scaling = DataUtilities.parseDataScaling(scalingStr);
            dataList = DataUtilities.parseTextData(dataStr, scaling);
        } else if (dataStr.startsWith("e:")) {
            dataList = DataUtilities.parseExtendedData(dataStr);
        } else {
            throw new RuntimeException("Unrecognised data encoding: " + dataStr.substring(0, 2));
        }
        XYSeriesCollection result = new XYSeriesCollection();
        for (int s = 0; s < dataList.size(); s += 2) {
            List xSeries = (List)dataList.get(s);
            List ySeries = (List)dataList.get(s + 1);
            XYSeries ss = new XYSeries((Comparable)((Object)("Series " + s / 2)));
            int itemCount = xSeries.size();
            boolean implicitXValues = false;
            if (itemCount == 1) {
                itemCount = ySeries.size();
                implicitXValues = true;
            }
            for (int i = 0; i < itemCount; ++i) {
                double xx;
                if (implicitXValues) {
                    xx = ((double)i + 0.0) / (double)Math.max(itemCount - 1, 1);
                } else {
                    Number x = (Number)xSeries.get(i);
                    xx = x.doubleValue();
                }
                Number y = (Number)ySeries.get(i);
                if (y != null) {
                    ss.add(xx, y.doubleValue());
                    continue;
                }
                ss.add(xx, null);
            }
            result.addSeries(ss);
        }
        return result;
    }

    public static XYSeriesCollection parseScatterDataset(String dataStr, String scalingStr) {
        List dataList;
        if (dataStr == null) {
            throw new IllegalArgumentException("Null 'dataStr' argument.");
        }
        if (dataStr.startsWith("s:")) {
            dataList = DataUtilities.parseSimpleData(dataStr);
        } else if (dataStr.startsWith("t:")) {
            float[] scaling = DataUtilities.parseDataScaling(scalingStr);
            dataList = DataUtilities.parseTextData(dataStr, scaling);
        } else if (dataStr.startsWith("e:")) {
            dataList = DataUtilities.parseExtendedData(dataStr);
        } else {
            throw new RuntimeException("Unrecognised data encoding: " + dataStr.substring(0, 2));
        }
        XYSeriesCollection result = new XYSeriesCollection();
        List xSeries = (List)dataList.get(0);
        List ySeries = (List)dataList.get(1);
        XYSeries ss = new XYSeries((Comparable)((Object)"Series"));
        int itemCount = xSeries.size();
        for (int i = 0; i < itemCount; ++i) {
            Number x = (Number)xSeries.get(i);
            double xx = x.doubleValue();
            Number y = (Number)ySeries.get(i);
            if (y != null) {
                double yy = y.doubleValue();
                ss.add(xx, yy);
            } else {
                ss.add(xx, null);
            }
            result.addSeries(ss);
        }
        List zSeries = null;
        if (dataList.size() > 2) {
            zSeries = (List)dataList.get(2);
            XYSeries sz = new XYSeries((Comparable)((Object)"Z"));
            for (int i = 0; i < zSeries.size(); ++i) {
                sz.add((double)i, (Number)zSeries.get(i));
            }
        }
        return result;
    }
}

