/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.eastwood.ChartEngine;
import org.jfree.eastwood.Parameters;

public class ChartServlet
extends HttpServlet {
    private Font font;
    private int maximumImageSize = 360000;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String fontSizeParam = config.getInitParameter("fontSize");
        String fontResourceParam = config.getInitParameter("fontResource");
        String fontFileParam = config.getInitParameter("fontFile");
        String fontParam = config.getInitParameter("font");
        String maximumImageSizeParam = config.getInitParameter("maximumImageSize");
        float fontSize = 12.0f;
        if (fontSizeParam != null) {
            fontSize = Integer.parseInt(fontSizeParam);
        }
        if (fontResourceParam != null) {
            ServletContext ctx = config.getServletContext();
            this.font = this.readFontResource(ctx, fontResourceParam, fontSize);
        } else {
            this.font = fontFileParam != null ? this.readFontFile(fontFileParam, fontSize) : (fontParam != null ? new Font(fontParam, 0, (int)fontSize) : new Font("Dialog", 0, (int)fontSize));
        }
        if (maximumImageSizeParam != null) {
            this.maximumImageSize = Integer.parseInt(maximumImageSizeParam);
        }
    }

    private Font readFontResource(ServletContext ctx, String fontResourceParam, float fontSize) throws ServletException {
        InputStream is;
        if (!fontResourceParam.startsWith("/")) {
            fontResourceParam = "/" + fontResourceParam;
        }
        if ((is = ctx.getResourceAsStream(fontResourceParam)) == null) {
            throw new ServletException("Font resource '" + fontResourceParam + "' not found");
        }
        try {
            Font font = Font.createFont(0, is).deriveFont(fontSize);
            return font;
        }
        catch (FontFormatException e) {
            throw new ServletException("Font resource '" + fontResourceParam + "' is not a truetype font", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException("I/O error when reading font resource '" + fontResourceParam + "'", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    private Font readFontFile(String fontFileParam, float fontSize) throws ServletException {
        File f = new File(fontFileParam);
        if (!f.exists()) {
            throw new ServletException("Font file '" + f + "' doesn't exist");
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            Font font = Font.createFont(0, fis).deriveFont(fontSize);
            fis.close();
            return font;
        }
        catch (FontFormatException e) {
            throw new ServletException("Font file '" + f + "' is not a truetype font", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException("I/O error when reading font file '" + f + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            Map params = Parameters.parseQueryString(request.getQueryString());
            JFreeChart chart = ChartEngine.buildChart(params, this.font);
            if (chart != null) {
                response.setContentType("image/png");
                String[] size = (String[])params.get("chs");
                int[] dims = new int[2];
                dims = size != null ? this.parseChartDimensions(size[0]) : new int[]{200, 125};
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)dims[0], (int)dims[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            out.close();
        }
    }

    private int[] parseChartDimensions(String text) throws ServletException {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument (in parseChartDimensions(String)).");
        }
        int[] result = new int[2];
        int splitIndex = text.indexOf(120);
        String xStr = text.substring(0, splitIndex);
        String yStr = text.substring(splitIndex + 1);
        int x = Integer.parseInt(xStr);
        int y = Integer.parseInt(yStr);
        if (x > 1000 || y > 1000 || x * y >= this.maximumImageSize) {
            throw new ServletException("Invalid chart dimensions: " + xStr + ", " + yStr);
        }
        result[0] = x;
        result[1] = y;
        return result;
    }
}

