/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.eastwood;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.eastwood.CentreLayout;
import org.jfree.eastwood.ChartEngine;
import org.jfree.eastwood.Parameters;

public class Application
extends JFrame
implements ActionListener {
    private JComboBox entryField;
    private DefaultComboBoxModel entryModel;
    private JPanel paper;
    private ChartPanel chartPanel;

    public Application(String title) {
        super(title);
        this.setDefaultCloseOperation(2);
        this.entryModel = new DefaultComboBoxModel();
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add(this.createContent());
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("EXIT".equals(cmd)) {
            System.exit(0);
        } else if ("ABOUT".equals(cmd)) {
            JOptionPane.showMessageDialog(this, "Eastwood v1.2.0\n(C)opyright 2008, 2009, by Object Refinery Limited");
        } else if (e.getSource() == this.entryField) {
            String text = (String)this.entryField.getSelectedItem();
            int index = this.entryModel.getIndexOf(text);
            if (index == -1) {
                this.entryModel.addElement(text);
            }
            try {
                this.renderChart(text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic(88);
        exit.setActionCommand("EXIT");
        exit.addActionListener(this);
        fileMenu.add(exit);
        menuBar.add(fileMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem about = new JMenuItem("About");
        about.setActionCommand("ABOUT");
        about.addActionListener(this);
        helpMenu.add(about);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JPanel createContent() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.entryField = new JComboBox(this.entryModel);
        this.entryField.setEditable(true);
        this.entryField.addActionListener(this);
        northPanel.add(this.entryField);
        content.add((Component)northPanel, "North");
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.black)));
        this.chartPanel.setPreferredSize(new Dimension(500, 300));
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.chartPanel.setMaximumDrawWidth(Integer.MAX_VALUE);
        this.chartPanel.setPopupMenu(null);
        this.paper = new JPanel(new CentreLayout());
        this.paper.add((Component)this.chartPanel);
        JScrollPane scroller = new JScrollPane(this.paper);
        centrePanel.add(scroller);
        content.add(centrePanel);
        return content;
    }

    protected void renderChart(String paramStr) throws UnsupportedEncodingException {
        if (paramStr.startsWith("http://chart.apis.google.com/chart?")) {
            paramStr = paramStr.substring(35);
        }
        Map params = Parameters.parseQueryString(paramStr);
        JFreeChart chart = ChartEngine.buildChart(params, new Font("Dialog", 0, 12));
        String[] size = (String[])params.get("chs");
        Dimension d = size != null ? ChartEngine.parseDimensions(size[0]) : new Dimension(200, 125);
        Insets insets = this.chartPanel.getInsets();
        if (insets != null) {
            d.height += insets.top + insets.bottom;
            d.width += insets.left + insets.right;
        }
        this.chartPanel.setPreferredSize(d);
        this.chartPanel.setSize(d);
        this.paper.validate();
        this.chartPanel.setChart(chart);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Application app = new Application("Eastwood Charts 1.2.0");
        app.pack();
        app.setVisible(true);
    }
}

