/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import java.awt.Color;
import java.text.MessageFormat;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.internal.StolenColorEditor;
import net.refractions.udig.style.sld.simple.Mode;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;

public class StrokeViewer {
    boolean enabled = false;
    Color color = null;
    double width = Double.NaN;
    double opacity = Double.NaN;
    Button on;
    StolenColorEditor chooser;
    Combo size;
    Combo percent;
    Listener sync = new Listener();
    SelectionListener listener = null;

    public Composite createControl(Composite parent, KeyListener klisten) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_line_label);
        this.on = new Button(part, 32);
        this.chooser = new StolenColorEditor(part, this.sync);
        this.size = new Combo(part, 4);
        this.size.setItems(new String[]{"1", "2", "3", "5", "10"});
        this.size.setTextLimit(2);
        this.size.addKeyListener(klisten);
        this.size.setToolTipText(Messages.StrokeViewer_size_tooltip);
        this.percent = new Combo(part, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(3);
        this.percent.addKeyListener(klisten);
        this.percent.setToolTipText(Messages.StrokeViewer_percent_tooltip);
        return part;
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(this.sync);
            this.size.addSelectionListener((SelectionListener)this.sync);
            this.size.addModifyListener((ModifyListener)this.sync);
            this.percent.addSelectionListener((SelectionListener)this.sync);
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(null);
            this.size.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeModifyListener((ModifyListener)this.sync);
            this.percent.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void setStroke(Stroke aLine, Mode mode, Color defaultColor) {
        this.listen(false);
        try {
            boolean enabled = true;
            Stroke line = aLine;
            if (line == null) {
                StyleBuilder builder = new StyleBuilder();
                line = builder.createStroke(defaultColor);
                enabled = false;
            }
            this.enabled = enabled && mode != Mode.NONE && line != null;
            this.color = SLDs.color((Stroke)line);
            this.width = SLDs.width((Stroke)line);
            this.opacity = SLDs.opacity((Stroke)line);
            this.on.setEnabled(mode != Mode.NONE);
            this.chooser.setColor(this.color);
            String text = MessageFormat.format("{0,number,#0}", this.width);
            this.size.setText(text);
            this.size.select(this.size.indexOf(text));
            text = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText(text);
            this.percent.select(this.percent.indexOf(text));
            this.on.setSelection(this.enabled);
            this.chooser.setEnabled(this.enabled);
            this.size.setEnabled(this.enabled);
            this.percent.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    public Stroke getStroke(StyleBuilder build) {
        if (!this.enabled) {
            return null;
        }
        if (this.opacity != Double.NaN) {
            return build.createStroke(this.color, this.width, this.opacity);
        }
        if (this.width != Double.NaN) {
            return build.createStroke(this.color, this.width);
        }
        return build.createStroke(this.color);
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent cause) {
            try {
                try {
                    StrokeViewer.this.enabled = StrokeViewer.this.on.getSelection();
                    StrokeViewer.this.color = StrokeViewer.this.chooser.getColor();
                    try {
                        StrokeViewer.this.width = Integer.parseInt(StrokeViewer.this.size.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        String ptext = StrokeViewer.this.percent.getText();
                        if (ptext.endsWith("%")) {
                            ptext = ptext.substring(0, ptext.length() - 1);
                            StrokeViewer.this.opacity = Double.parseDouble(ptext);
                            StrokeViewer.this.opacity /= 100.0;
                        } else {
                            StrokeViewer.this.opacity = Double.parseDouble(ptext);
                            if (StrokeViewer.this.opacity > 1.0) {
                                StrokeViewer.this.opacity /= 100.0;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    StrokeViewer.this.fire(cause);
                }
                catch (Throwable throwable) {
                    StrokeViewer.this.chooser.setEnabled(StrokeViewer.this.enabled);
                    StrokeViewer.this.size.setEnabled(StrokeViewer.this.enabled);
                    StrokeViewer.this.percent.setEnabled(StrokeViewer.this.enabled);
                }
            }
            finally {
                StrokeViewer.this.chooser.setEnabled(StrokeViewer.this.enabled);
                StrokeViewer.this.size.setEnabled(StrokeViewer.this.enabled);
                StrokeViewer.this.percent.setEnabled(StrokeViewer.this.enabled);
            }
        }
    }
}

