/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import java.text.MessageFormat;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;
import org.opengis.filter.expression.Expression;

public class RasterViewer {
    boolean enabled = false;
    double opacity = Double.NaN;
    Button on;
    Combo percent;
    private SelectionListener listener;
    Listener sync = new Listener();

    public Composite createControl(Composite parent, KeyListener listener1) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_raster_label);
        this.on = new Button(part, 32);
        this.percent = new Combo(part, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(4);
        this.percent.addKeyListener(listener1);
        this.percent.setToolTipText(Messages.RasterViewer_percent_tooltip);
        return part;
    }

    void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.percent.addSelectionListener((SelectionListener)this.sync);
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public void set(RasterSymbolizer sym2) {
        this.listen(false);
        try {
            RasterSymbolizer sym = sym2;
            boolean bl = this.enabled = sym != null;
            if (sym == null) {
                StyleBuilder builder = new StyleBuilder();
                sym = builder.createRasterSymbolizer();
                sym.setOpacity((Expression)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()).literal(1.0));
            }
            this.opacity = SLD.rasterOpacity((RasterSymbolizer)sym);
            String text = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText(text);
            this.percent.select(this.percent.indexOf(text));
            this.on.setSelection(this.enabled);
            this.percent.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    public RasterSymbolizer get(StyleBuilder build) {
        return this.opacity == Double.NaN || !this.enabled ? null : build.createRasterSymbolizer(null, this.opacity);
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent e) {
            try {
                try {
                    RasterViewer.this.enabled = RasterViewer.this.on.getSelection();
                    try {
                        String ptext = RasterViewer.this.percent.getText();
                        if (ptext.endsWith("%")) {
                            ptext = ptext.substring(0, ptext.length() - 1);
                            RasterViewer.this.opacity = Double.parseDouble(ptext);
                            RasterViewer.this.opacity /= 100.0;
                        } else {
                            RasterViewer.this.opacity = Double.parseDouble(ptext);
                            if (RasterViewer.this.opacity > 1.0) {
                                RasterViewer.this.opacity /= 100.0;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    RasterViewer.this.fire(e);
                }
                catch (Throwable throwable) {
                    RasterViewer.this.percent.setEnabled(RasterViewer.this.enabled);
                }
            }
            finally {
                RasterViewer.this.percent.setEnabled(RasterViewer.this.enabled);
            }
        }
    }
}

