/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.simple.ChannelViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SelectedChannelType;

public class RGBChannelViewer {
    private ChannelViewer redChannel;
    private ChannelViewer blueChannel;
    private ChannelViewer greenChannel;
    private Button chEnabled;
    private SelectionListener listener;
    private Listener sync = new Listener();

    public RGBChannelViewer(ChannelViewer red, ChannelViewer green, ChannelViewer blue) {
        this.redChannel = red;
        this.blueChannel = blue;
        this.greenChannel = green;
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
        this.redChannel.addListener(listener1);
        this.blueChannel.addListener(listener1);
        this.greenChannel.addListener(listener1);
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public ChannelViewer getRedChannel() {
        return this.redChannel;
    }

    public ChannelViewer getGreenChannel() {
        return this.greenChannel;
    }

    public ChannelViewer getBlueChannel() {
        return this.blueChannel;
    }

    void listen(boolean listen) {
        if (listen) {
            this.chEnabled.addSelectionListener((SelectionListener)this.sync);
        } else {
            this.chEnabled.removeSelectionListener((SelectionListener)this.sync);
        }
    }

    public Composite createControl(Composite parent) {
        Group g = new Group(parent, 16);
        g.setLayout((Layout)new GridLayout(1, false));
        this.chEnabled = new Button((Composite)g, 32);
        this.chEnabled.setText(Messages.RGBChannelViewer_RBGChannelSelectionLabel);
        this.chEnabled.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        this.chEnabled.setSelection(true);
        this.chEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGBChannelViewer.this.setChannelsEnabled(RGBChannelViewer.this.chEnabled.getSelection());
            }
        });
        this.redChannel.createControl((Composite)g);
        this.greenChannel.createControl((Composite)g);
        this.blueChannel.createControl((Composite)g);
        return g;
    }

    public boolean isEnabled() {
        return this.chEnabled.getSelection();
    }

    public void setEnabled(boolean enabled) {
        this.chEnabled.setSelection(enabled);
        this.setChannelsEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.setEnabled(editable);
        this.chEnabled.setEnabled(editable);
    }

    private void setChannelsEnabled(boolean enabled) {
        this.redChannel.setEnabled(enabled);
        this.greenChannel.setEnabled(enabled);
        this.blueChannel.setEnabled(enabled);
    }

    public void updateHistograms(int[][] rgbHistograms) {
        this.redChannel.updateHistogram(rgbHistograms);
        this.blueChannel.updateHistogram(rgbHistograms);
        this.greenChannel.updateHistogram(rgbHistograms);
    }

    public void set(RasterSymbolizer rs) {
        this.listen(false);
        try {
            try {
                ChannelSelection cs = rs.getChannelSelection();
                SelectedChannelType red = null;
                SelectedChannelType green = null;
                SelectedChannelType blue = null;
                if (cs == null) {
                    this.setEnabled(false);
                } else {
                    SelectedChannelType[] sct = cs.getRGBChannels();
                    if (sct[0] == null && sct[1] == null && sct[2] == null) {
                        this.setEnabled(false);
                    } else {
                        this.setEnabled(true);
                        red = sct[0];
                        green = sct[1];
                        blue = sct[2];
                    }
                }
                this.redChannel.set(red, 0);
                this.greenChannel.set(green, 1);
                this.blueChannel.set(blue, 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.listen(true);
            }
        }
        finally {
            this.listen(true);
        }
    }

    public void setBands(String[] bands) {
        this.redChannel.setBands(bands);
        this.greenChannel.setBands(bands);
        this.blueChannel.setBands(bands);
    }

    private class Listener
    implements SelectionListener {
        private Listener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        private void sync(SelectionEvent e) {
            RGBChannelViewer.this.fire(e);
        }
    }
}

