/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import java.text.MessageFormat;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;

public class OpacityViewer {
    double opacity = Double.NaN;
    private Combo percent;
    private SelectionListener listener;
    Listener sync = new Listener();

    public Composite createControl(Composite parent, KeyListener listener1) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_raster_label);
        this.percent = new Combo(part, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(4);
        this.percent.addKeyListener(listener1);
        this.percent.setToolTipText(Messages.RasterViewer_percent_tooltip);
        return part;
    }

    void listen(boolean listen) {
        if (listen) {
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public void set(RasterSymbolizer sym2) {
        this.listen(false);
        try {
            RasterSymbolizer sym = sym2;
            this.opacity = sym == null ? 1.0 : SLD.rasterOpacity((RasterSymbolizer)sym);
            String text = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText(text);
            this.percent.select(this.percent.indexOf(text));
        }
        finally {
            this.listen(true);
        }
    }

    public RasterSymbolizer get(StyleBuilder build) {
        return this.opacity == Double.NaN ? null : build.createRasterSymbolizer(null, this.opacity);
    }

    public double getValue() {
        return this.opacity;
    }

    private class Listener
    implements ModifyListener {
        private Listener() {
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent e) {
            try {
                try {
                    String ptext = OpacityViewer.this.percent.getText();
                    if (ptext.endsWith("%")) {
                        ptext = ptext.substring(0, ptext.length() - 1);
                        OpacityViewer.this.opacity = Double.parseDouble(ptext);
                        OpacityViewer.this.opacity /= 100.0;
                    } else {
                        OpacityViewer.this.opacity = Double.parseDouble(ptext);
                        if (OpacityViewer.this.opacity > 1.0) {
                            OpacityViewer.this.opacity /= 100.0;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                OpacityViewer.this.fire(e);
            }
            catch (Throwable throwable) {}
        }
    }
}

