/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.simple;

import java.awt.Color;
import java.text.MessageFormat;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.simple.Mode;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.opengis.style.GraphicalSymbol;

public class GraphicViewer {
    boolean enabled;
    String type;
    double width;
    Button on;
    Combo name;
    Combo size;
    Listener sync = new Listener();
    private SelectionListener listener;

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public Composite createControl(Composite parent, KeyListener klisten, StyleBuilder build) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_point_label);
        this.on = new Button(part, 32);
        this.size = new Combo(part, 4);
        this.size.setItems(new String[]{"1", "2", "3", "5", "10", "15"});
        this.size.setTextLimit(2);
        this.size.addKeyListener(klisten);
        this.size.setToolTipText(Messages.GraphicViewer_size_tooltip);
        this.name = new Combo(part, 4);
        this.name.setItems(build.getWellKnownMarkNames());
        this.name.setTextLimit(9);
        this.name.addKeyListener(klisten);
        this.name.setToolTipText(Messages.GraphicViewer_name_tooltip);
        return part;
    }

    public Graphic getGraphic(Fill filll, Stroke stroke, StyleBuilder build) {
        if (!this.enabled) {
            Mark mark = null;
            if (this.type == null) {
                build.createMark("square", null, null);
            } else {
                mark = build.createMark(this.type, null, null);
            }
            return build.createGraphic(null, mark, null);
        }
        Mark mark = build.createMark(this.type, filll, stroke);
        Graphic graphic = build.createGraphic(null, mark, null);
        graphic.setSize(build.literalExpression(this.width));
        return graphic;
    }

    public void setGraphic(Graphic graphic, Mode mode, Color defaultColor) {
        boolean enabled = true;
        if (graphic == null) {
            StyleBuilder builder = new StyleBuilder();
            graphic = builder.createGraphic(null, builder.createMark("square", defaultColor), null);
            enabled = true;
        }
        this.width = SLDs.size((org.opengis.style.Graphic)graphic);
        String text = MessageFormat.format("{0,number,#0}", this.width);
        if (text != null) {
            this.size.setText(text);
            this.size.select(this.size.indexOf(text));
        }
        boolean marked = false;
        if (graphic != null && graphic.graphicalSymbols() != null && !graphic.graphicalSymbols().isEmpty()) {
            for (GraphicalSymbol symbol : graphic.graphicalSymbols()) {
                if (!(symbol instanceof Mark)) continue;
                Mark mark = (Mark)symbol;
                this.setMark(mark, mode);
                marked = true;
                break;
            }
        }
        if (!marked) {
            this.setMark(null, mode);
        }
        this.enabled = this.enabled && enabled;
    }

    private void setMark(Mark mark, Mode mode) {
        this.listen(false);
        try {
            this.enabled = mode == Mode.POINT && mark != null;
            this.type = SLD.wellKnownName((Mark)mark);
            this.on.setEnabled(mode == Mode.POINT || mode == Mode.ALL);
            if (this.type != null) {
                this.name.setText(this.type);
                this.name.select(this.name.indexOf(this.type));
            }
            this.on.setSelection(this.enabled);
            this.size.setEnabled(this.enabled);
            this.name.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.size.addSelectionListener((SelectionListener)this.sync);
            this.size.addModifyListener((ModifyListener)this.sync);
            this.name.addSelectionListener((SelectionListener)this.sync);
            this.name.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeSelectionListener((SelectionListener)this.sync);
            this.size.removeModifyListener((ModifyListener)this.sync);
            this.name.removeSelectionListener((SelectionListener)this.sync);
            this.name.removeModifyListener((ModifyListener)this.sync);
        }
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent selectionEvent) {
            try {
                try {
                    GraphicViewer.this.enabled = GraphicViewer.this.on.getSelection();
                    GraphicViewer.this.type = GraphicViewer.this.name.getText();
                    try {
                        GraphicViewer.this.width = Integer.parseInt(GraphicViewer.this.size.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    GraphicViewer.this.fire(selectionEvent);
                }
                catch (Throwable throwable) {
                    GraphicViewer.this.name.setEnabled(GraphicViewer.this.enabled);
                    GraphicViewer.this.size.setEnabled(GraphicViewer.this.enabled);
                }
            }
            finally {
                GraphicViewer.this.name.setEnabled(GraphicViewer.this.enabled);
                GraphicViewer.this.size.setEnabled(GraphicViewer.this.enabled);
            }
        }
    }
}

