/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.internal;

import java.awt.Color;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.style.sld.internal.FontEditor;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.internal.StolenColorEditor;
import net.refractions.udig.style.sld.internal.SymbolizerContent;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.Font;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.Fill;
import org.opengis.style.Halo;

public class SLDTextEditorPart
extends SLDEditorPart {
    private static final int LABEL = 1;
    private static final int FONTCOLOR = 2;
    private static final int HALOCOLOR = 2;
    private StolenColorEditor labelHaloColorEditor;
    private FontEditor labelFont;
    private Combo labelCombo;
    private Button labelHaloEnabled;
    private Spinner haloWidthScale;
    private Spinner haloOpacityScale;
    private int opacityMaxValue = 100;
    private double opacityMaxValueFloat = 100.0;

    @Override
    public Class getContentType() {
        return TextSymbolizer.class;
    }

    private Composite subpart(Composite parent, String tag, int width) {
        Composite subpart = new Composite(parent, 0);
        RowLayout across = new RowLayout();
        across.type = 256;
        across.wrap = true;
        across.pack = true;
        across.fill = true;
        across.marginBottom = 1;
        across.marginRight = 2;
        subpart.setLayout((Layout)across);
        Label label = new Label(subpart, 0);
        label.setText(tag);
        label.setAlignment(131072);
        RowData data = new RowData();
        data.width = 40;
        data.height = 10;
        label.setLayoutData((Object)data);
        return subpart;
    }

    private void labelPart(Composite parent) {
        Composite part = this.subpart(parent, Messages.SLDTextEditorPart_label_label, 2);
        this.labelCombo = new Combo(part, 8);
        this.labelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SLDTextEditorPart.this.apply(1);
            }
        });
        this.labelFont = new FontEditor(part, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SLDTextEditorPart.this.apply(2);
            }
        });
    }

    private void haloPart(Composite parent) {
        Composite halo = this.subpart(parent, Messages.SLDTextEditorPart_label_halo, 3);
        this.labelHaloEnabled = new Button(halo, 32);
        this.labelHaloEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SLDTextEditorPart.this.apply(2);
            }
        });
        this.labelHaloColorEditor = new StolenColorEditor(halo, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SLDTextEditorPart.this.apply(2);
            }
        });
        this.haloWidthScale = new Spinner(halo, 256);
        this.haloWidthScale.setMinimum(0);
        this.haloWidthScale.setMaximum(10);
        this.haloWidthScale.setPageIncrement(1);
        this.haloWidthScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SLDTextEditorPart.this.apply(2);
            }
        });
        this.haloOpacityScale = new Spinner(halo, 256);
        this.haloOpacityScale.setMinimum(0);
        this.haloOpacityScale.setMaximum(this.opacityMaxValue);
        this.haloOpacityScale.setPageIncrement(10);
        this.haloOpacityScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SLDTextEditorPart.this.apply(2);
            }
        });
    }

    @Override
    protected Control createPartControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.labelPart(parent);
        this.haloPart(parent);
        return parent;
    }

    @Override
    public void init() {
    }

    private void setStylingElements(TextSymbolizer symbolizer) {
        Color fontFill = SLDs.textFontFill((TextSymbolizer)symbolizer);
        FontData[] tempFD = SLDs.textFont((TextSymbolizer)symbolizer);
        Expression label = SLDs.textLabel((TextSymbolizer)symbolizer);
        if (fontFill == null) {
            fontFill = SymbolizerContent.DEFAULT_FONT_COLOR;
        }
        this.labelFont.setColorValue(new RGB(fontFill.getRed(), fontFill.getGreen(), fontFill.getBlue()));
        if (tempFD == null) {
            tempFD = new FontData[]{new FontData("Arial", 10, 0)};
        }
        this.labelFont.setFontList(tempFD);
        Layer currLayer = this.getLayer();
        List attributeList = null;
        GeometryDescriptor defaultGeom = null;
        if (currLayer.hasResource(FeatureSource.class)) {
            SimpleFeatureType ft = currLayer.getSchema();
            attributeList = ft.getAttributeDescriptors();
            defaultGeom = ft.getGeometryDescriptor();
        }
        this.labelCombo.removeAll();
        if (attributeList != null) {
            int i = 0;
            while (i < attributeList.size()) {
                AttributeDescriptor attributeDescriptor = (AttributeDescriptor)attributeList.get(i);
                if (attributeDescriptor != defaultGeom) {
                    this.labelCombo.add(attributeDescriptor.getName().getLocalPart());
                }
                if (label != null && attributeDescriptor != null && attributeDescriptor.getName().equals((Object)label.toString())) {
                    this.labelCombo.select(i);
                } else if (i == 0) {
                    this.labelCombo.select(i);
                }
                ++i;
            }
        }
        this.labelCombo.pack(true);
        Color haloFill = SLDs.textHaloFill((TextSymbolizer)symbolizer);
        if (haloFill == null) {
            haloFill = SymbolizerContent.DEFAULT_HALO_COLOR;
            this.labelHaloEnabled.setSelection(false);
        } else {
            this.labelHaloEnabled.setSelection(true);
        }
        this.labelHaloColorEditor.setColorValue(new RGB(haloFill.getRed(), haloFill.getGreen(), haloFill.getBlue()));
        int width = SLDs.textHaloWidth((TextSymbolizer)symbolizer);
        if (width == 0) {
            width = 1;
        }
        this.haloWidthScale.setSelection(width);
        double opacity = SLDs.textHaloOpacity((TextSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.haloOpacityScale.setSelection((int)(opacity * (double)this.opacityMaxValue));
    }

    @Override
    public void reset() {
        this.setStylingElements((TextSymbolizer)this.getContent());
    }

    private void apply(int mask) {
        TextSymbolizer textSymbolizer = (TextSymbolizer)this.getContent();
        if ((mask & 1) != 0) {
            this.applyLabel(textSymbolizer, this.getStyleBuilder());
        }
        if ((mask & 2) != 0) {
            this.applyLabel(textSymbolizer, this.getStyleBuilder());
        }
    }

    private void applyLabel(TextSymbolizer textSymbolizer, StyleBuilder styleBuilder) {
        PropertyName currLabel = null;
        if (this.labelCombo.getSelectionIndex() != -1) {
            String selectedLabel = this.labelCombo.getItem(this.labelCombo.getSelectionIndex());
            RGB xfontColor = this.labelFont.getColorValue();
            textSymbolizer.setFill((Fill)styleBuilder.createFill(new Color(xfontColor.red, xfontColor.green, xfontColor.blue)));
            FontData[] fd = this.labelFont.getFontList();
            String fontName = fd[0].getName();
            boolean fontBold = fd[0].getStyle() == 1;
            boolean fontItalic = fd[0].getStyle() == 2;
            double fontSize = fd[0].getHeight();
            Font[] font = new Font[]{styleBuilder.createFont(fontName, fontItalic, fontBold, fontSize)};
            textSymbolizer.setFonts(font);
            if (this.labelHaloEnabled.getSelection()) {
                RGB haloColor = this.labelHaloColorEditor.getColorValue();
                if (textSymbolizer.getHalo() != null) {
                    if (textSymbolizer.getHalo().getFill() != null) {
                        textSymbolizer.getHalo().getFill().setColor(styleBuilder.colorExpression(new Color(haloColor.red, haloColor.green, haloColor.blue)));
                    } else {
                        textSymbolizer.getHalo().setFill((Fill)styleBuilder.createFill(new Color(haloColor.red, haloColor.green, haloColor.blue)));
                    }
                    textSymbolizer.getHalo().setRadius(styleBuilder.literalExpression(this.haloWidthScale.getSelection()));
                    textSymbolizer.getHalo().getFill().setOpacity(styleBuilder.literalExpression((double)this.haloOpacityScale.getSelection() / this.opacityMaxValueFloat));
                } else {
                    HaloImpl halo = new HaloImpl();
                    textSymbolizer.setHalo((Halo)halo);
                    textSymbolizer.getHalo().setFill((Fill)styleBuilder.createFill(new Color(haloColor.red, haloColor.green, haloColor.blue)));
                    textSymbolizer.getHalo().setRadius(styleBuilder.literalExpression(this.haloWidthScale.getSelection()));
                    textSymbolizer.getHalo().getFill().setOpacity(styleBuilder.literalExpression((double)this.haloOpacityScale.getSelection() / this.opacityMaxValueFloat));
                }
            } else {
                textSymbolizer.setHalo(null);
            }
            currLabel = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()).property(selectedLabel);
            textSymbolizer.setLabel((Expression)currLabel);
        }
    }
}

