/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.internal;

import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleBuilder;

public class SLDRasterEditorPart
extends SLDEditorPart
implements SelectionListener {
    private Composite myparent;
    private Scale opacityScale;
    private Text opacityText;

    @Override
    public Class getContentType() {
        return RasterSymbolizer.class;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.setStylingElements((RasterSymbolizer)this.getContent());
    }

    private void setStylingElements(RasterSymbolizer symbolizer) {
        double number = SLDs.rasterOpacity((RasterSymbolizer)symbolizer);
        int opacity = new Double(number * 100.0).intValue();
        this.opacityScale.setSelection(opacity);
        this.opacityText.setText(String.valueOf(Integer.toString(opacity)) + "%");
        this.opacityText.pack(true);
    }

    @Override
    protected Control createPartControl(Composite parent) {
        this.myparent = parent;
        RowLayout layout = new RowLayout();
        this.myparent.setLayout((Layout)layout);
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        Group borderOpacityArea = new Group(this.myparent, 0);
        borderOpacityArea.setLayout((Layout)new GridLayout(2, false));
        borderOpacityArea.setText("Raster Opacity");
        this.opacityScale = new Scale((Composite)borderOpacityArea, 256);
        this.opacityScale.setMinimum(0);
        this.opacityScale.setMaximum(100);
        this.opacityScale.setPageIncrement(10);
        this.opacityScale.setBounds(0, 0, 10, -1);
        this.opacityScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SLDRasterEditorPart.this.opacityText.setText(String.valueOf(String.valueOf(SLDRasterEditorPart.this.opacityScale.getSelection())) + "%");
                SLDRasterEditorPart.this.opacityText.pack(true);
            }
        });
        this.opacityScale.addSelectionListener((SelectionListener)this);
        this.opacityText = new Text((Composite)borderOpacityArea, 2056);
        this.opacityText.pack(true);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.apply();
    }

    public void apply() {
        RasterSymbolizer symbolizer = (RasterSymbolizer)this.getContent();
        StyleBuilder styleBuilder = this.getStyleBuilder();
        double opacity = (double)this.opacityScale.getSelection() / 100.0;
        symbolizer.setOpacity(styleBuilder.literalExpression(opacity));
    }
}

