/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.internal;

import java.awt.Color;
import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.internal.StolenColorEditor;
import net.refractions.udig.style.sld.internal.SymbolizerContent;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.opengis.style.Fill;

public class SLDPolygonEditorPart
extends SLDEditorPart
implements SelectionListener {
    private StolenColorEditor borderColour;
    private Button borderEnabled;
    private Spinner borderWidth;
    private StolenColorEditor fillColour;
    private Button fillEnabled;
    private Spinner borderOpacity;
    private int opacityMaxValue = 100;
    private double opacityMaxValueFloat = 100.0;
    private Spinner fillOpacity;

    @Override
    public Class getContentType() {
        return PolygonSymbolizer.class;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
        this.setStylingElements(this.getContent());
    }

    private void setStylingElements(PolygonSymbolizer symbolizer) {
        Color fill = SLDs.polyFill((PolygonSymbolizer)symbolizer);
        Color border = SLDs.polyColor((PolygonSymbolizer)symbolizer);
        int width = SLDs.polyWidth((PolygonSymbolizer)symbolizer);
        if (fill == null) {
            fill = SymbolizerContent.DEFAULT_FILL_COLOR;
            this.fillEnabled.setSelection(false);
        } else {
            this.fillEnabled.setSelection(true);
        }
        this.fillColour.setColorValue(new RGB(fill.getRed(), fill.getGreen(), fill.getBlue()));
        if (border == null) {
            border = SymbolizerContent.DEFAULT_BORDER_COLOR;
            this.borderEnabled.setSelection(false);
        } else {
            this.borderEnabled.setSelection(true);
        }
        this.borderColour.setColorValue(new RGB(border.getRed(), border.getGreen(), border.getBlue()));
        if (width == -1) {
            width = 1;
        }
        this.borderWidth.setSelection(width);
        double opacity = SLDs.polyBorderOpacity((PolygonSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.borderOpacity.setSelection((int)(opacity * (double)this.opacityMaxValue));
        opacity = SLDs.polyFillOpacity((PolygonSymbolizer)symbolizer);
        if (Double.isNaN(opacity)) {
            opacity = 1.0;
        }
        this.fillOpacity.setSelection((int)(opacity * (double)this.opacityMaxValue));
    }

    public PolygonSymbolizer getContent() {
        return (PolygonSymbolizer)super.getContent();
    }

    private void applyFill(PolygonSymbolizer polygonSymbolizer, StyleBuilder styleBuilder) {
        if (this.fillEnabled.getSelection()) {
            RGB c = this.fillColour.getColorValue();
            org.geotools.styling.Fill fill = polygonSymbolizer.getFill();
            if (fill == null) {
                fill = styleBuilder.createFill();
                polygonSymbolizer.setFill((Fill)fill);
            }
            fill.setColor(styleBuilder.colorExpression(new Color(c.red, c.green, c.blue)));
            fill.setOpacity(styleBuilder.literalExpression((double)this.fillOpacity.getSelection() / this.opacityMaxValueFloat));
        } else {
            polygonSymbolizer.setFill(null);
        }
    }

    private void applyBorder(PolygonSymbolizer polygonSymbolizer, StyleBuilder styleBuilder) {
        if (this.borderEnabled.getSelection()) {
            RGB c = this.borderColour.getColorValue();
            Stroke stroke = polygonSymbolizer.getStroke();
            if (stroke == null) {
                stroke = styleBuilder.createStroke();
                polygonSymbolizer.setStroke((org.opengis.style.Stroke)stroke);
            }
            stroke.setColor(styleBuilder.colorExpression(new Color(c.red, c.green, c.blue)));
            stroke.setWidth(styleBuilder.literalExpression(this.borderWidth.getSelection()));
            stroke.setOpacity(styleBuilder.literalExpression((double)this.borderOpacity.getSelection() / this.opacityMaxValueFloat));
        } else {
            polygonSymbolizer.setStroke(null);
        }
    }

    private Composite subpart(Composite parent, String tag, int width) {
        Composite subpart = new Composite(parent, 0);
        RowLayout across = new RowLayout();
        across.type = 256;
        across.wrap = true;
        across.pack = true;
        across.fill = true;
        across.marginBottom = 1;
        across.marginRight = 2;
        subpart.setLayout((Layout)across);
        Label label = new Label(subpart, 0);
        label.setText(tag);
        label.setAlignment(131072);
        RowData data = new RowData();
        data.width = 40;
        data.height = 10;
        label.setLayoutData((Object)data);
        return subpart;
    }

    private void borderPart(Composite parent) {
        Composite border = this.subpart(parent, Messages.SLDPolygonEditorPart_label_border, 4);
        this.borderEnabled = new Button(border, 32);
        this.borderEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SLDPolygonEditorPart.this.borderColour.getButton().setEnabled(SLDPolygonEditorPart.this.borderEnabled.getSelection());
                SLDPolygonEditorPart.this.borderWidth.setEnabled(SLDPolygonEditorPart.this.borderEnabled.getSelection());
                SLDPolygonEditorPart.this.borderOpacity.setEnabled(SLDPolygonEditorPart.this.borderEnabled.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.borderColour = new StolenColorEditor(border, this);
        this.borderWidth = new Spinner(border, 0);
        this.borderWidth.setMinimum(1);
        this.borderWidth.setMaximum(30);
        this.borderWidth.setPageIncrement(5);
        this.borderWidth.addSelectionListener((SelectionListener)this);
        this.borderOpacity = new Spinner(border, 0);
        this.borderOpacity.setMinimum(0);
        this.borderOpacity.setMaximum(this.opacityMaxValue);
        this.borderOpacity.setPageIncrement(10);
    }

    private void fillPart(Composite parent) {
        Composite fill = this.subpart(parent, Messages.SLDPolygonEditorPart_label_fill, 3);
        this.fillEnabled = new Button(fill, 32);
        this.fillEnabled.addSelectionListener((SelectionListener)this);
        this.fillEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SLDPolygonEditorPart.this.fillColour.getButton().setEnabled(SLDPolygonEditorPart.this.fillEnabled.getSelection());
                SLDPolygonEditorPart.this.fillOpacity.setEnabled(SLDPolygonEditorPart.this.fillEnabled.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fillColour = new StolenColorEditor(fill, this);
        this.fillOpacity = new Spinner(fill, 0);
        this.fillOpacity.setMinimum(0);
        this.fillOpacity.setMaximum(this.opacityMaxValue);
        this.fillOpacity.setPageIncrement(10);
    }

    @Override
    protected Control createPartControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.borderPart(parent);
        this.fillPart(parent);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.applyFill(this.getContent(), this.getStyleBuilder());
        this.applyBorder(this.getContent(), this.getStyleBuilder());
    }
}

