/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ColorEntry;
import net.refractions.udig.style.sld.editor.raster.IColorMapTypePanel;
import net.refractions.udig.style.sld.editor.raster.SingleBandEditorPage;
import net.refractions.udig.style.sld.editor.raster.UniqueValuesDialog;
import net.refractions.udig.style.sld.editor.raster.ValueFormatter;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.builder.ColorMapEntryBuilder;
import org.opengis.coverage.grid.GridCoverageReader;

public class UniqueValuesPanel
implements IColorMapTypePanel {
    private TableViewer tblViewer;
    protected ArrayList<ColorEntry> colors = new ArrayList();
    private BrewerPalette currentPalette;
    private boolean reverseColors;
    protected ValueFormatter formatter;
    protected SingleBandEditorPage page;

    public UniqueValuesPanel(SingleBandEditorPage page) {
        this.page = page;
    }

    @Override
    public Composite createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(2, false));
        this.tblViewer = new TableViewer(main, 268503042);
        this.tblViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tblViewer.getTable().setHeaderVisible(true);
        this.tblViewer.getTable().setLinesVisible(true);
        ((GridData)this.tblViewer.getTable().getLayoutData()).heightHint = 250;
        TableLabelProvider labelProvider = new TableLabelProvider();
        int i = 0;
        while (i < TableColumn.values().length) {
            final TableColumn col = TableColumn.values()[i];
            TableViewerColumn colOpacity = new TableViewerColumn(this.tblViewer, 0x1000000);
            colOpacity.setLabelProvider((CellLabelProvider)labelProvider);
            colOpacity.getColumn().setText(col.guiName);
            colOpacity.getColumn().setWidth(col.size);
            colOpacity.setEditingSupport(new EditingSupport(colOpacity.getViewer()){

                protected CellEditor getCellEditor(Object element) {
                    return col.getCellEditor(UniqueValuesPanel.this.tblViewer);
                }

                protected boolean canEdit(Object element) {
                    return element instanceof ColorEntry;
                }

                protected Object getValue(Object element) {
                    if (col == TableColumn.COLOR) {
                        Color c = ((ColorEntry)element).getColor();
                        return new RGB(c.getRed(), c.getGreen(), c.getBlue());
                    }
                    return col.getValue((ColorEntry)element, UniqueValuesPanel.this.formatter);
                }

                protected void setValue(Object element, Object value) {
                    col.updateValue((ColorEntry)element, value);
                    UniqueValuesPanel.this.tblViewer.refresh();
                }
            });
            ++i;
        }
        this.tblViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tblViewer.setInput((Object)this.colors.toArray(new Object[this.colors.size()]));
        this.createButtonPanel(main);
        return main;
    }

    private void createButtonPanel(Composite parent) {
        Composite btnPanel = new Composite(parent, 0);
        btnPanel.setLayout((Layout)new GridLayout(1, false));
        btnPanel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Button btnAdd = new Button(btnPanel, 8);
        btnAdd.setText(Messages.UniqueValuesPanel_AddButton);
        btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorEntry ce = new ColorEntry();
                UniqueValuesPanel.this.colors.add(ce);
                UniqueValuesPanel.this.updateColors();
                UniqueValuesPanel.this.refresh();
                UniqueValuesPanel.this.validate();
            }
        });
        final Button btnRemove = new Button(btnPanel, 8);
        btnRemove.setText(Messages.UniqueValuesPanel_RemoveButton);
        btnRemove.setEnabled(false);
        btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.tblViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                btnRemove.setEnabled(!UniqueValuesPanel.this.tblViewer.getSelection().isEmpty());
            }
        });
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object type : (IStructuredSelection)UniqueValuesPanel.this.tblViewer.getSelection()) {
                    if (!(type instanceof ColorEntry)) continue;
                    UniqueValuesPanel.this.colors.remove(type);
                }
                UniqueValuesPanel.this.updateColors();
                UniqueValuesPanel.this.refresh();
                UniqueValuesPanel.this.validate();
            }
        });
        Button btnSort = new Button(btnPanel, 8);
        btnSort.setText(Messages.UniqueValuesPanel_SortButton);
        btnSort.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        btnSort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UniqueValuesPanel.this.sort();
                UniqueValuesPanel.this.updateColors();
                UniqueValuesPanel.this.refresh();
            }
        });
        Button btnAddNoData = new Button(btnPanel, 8);
        btnAddNoData.setText(Messages.UniqueValuesPanel_NoDataButton);
        btnAddNoData.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        btnAddNoData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UniqueValuesPanel.this.page.getNoDataValues() != null) {
                    double[] dArray = UniqueValuesPanel.this.page.getNoDataValues();
                    int n = dArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double noData = dArray[n2];
                        ColorEntry ce = new ColorEntry(Color.WHITE, 0.0, noData, "-no data-");
                        UniqueValuesPanel.this.colors.add(ce);
                        ++n2;
                    }
                } else {
                    ColorEntry ce = new ColorEntry(Color.WHITE, 0.0, DEFAULT_NO_DATA, "-no data-");
                    UniqueValuesPanel.this.colors.add(ce);
                }
                UniqueValuesPanel.this.updateColors();
                UniqueValuesPanel.this.sort();
                UniqueValuesPanel.this.refresh();
            }
        });
    }

    protected void sort() {
        Collections.sort(this.colors, new Comparator<ColorEntry>(){

            @Override
            public int compare(ColorEntry arg0, ColorEntry arg1) {
                return Double.valueOf(arg0.getValue()).compareTo(arg1.getValue());
            }
        });
    }

    @Override
    public ColorMap getColorMap() throws Exception {
        this.sort();
        this.refresh();
        ColorMapImpl colorMap = new ColorMapImpl();
        colorMap.setType(3);
        for (ColorEntry c : this.colors) {
            ColorMapEntryBuilder cme = new ColorMapEntryBuilder();
            ColorMapEntry e = cme.color(c.getColor()).opacity(c.getOpacity()).quantity(this.formatter.formatNumber(c.getValue())).build();
            if (c.getLabel() != null && !c.getLabel().trim().isEmpty()) {
                e.setLabel(c.getLabel());
            }
            colorMap.addColorMapEntry(e);
        }
        return colorMap;
    }

    @Override
    public void setColorPalette(BrewerPalette palette, boolean reverse) {
        this.currentPalette = palette;
        this.reverseColors = reverse;
        this.updateColors();
        this.refresh();
    }

    private void reverse(Color[] cls) {
        if (cls == null) {
            return;
        }
        int i = 0;
        int j = cls.length - 1;
        while (i < j) {
            Color tmp = cls[i];
            cls[i] = cls[j];
            cls[j] = tmp;
            --j;
            ++i;
        }
    }

    private void updateColors() {
        block10: {
            if (this.currentPalette == null) break block10;
            if (this.currentPalette.getMaxColors() >= this.colors.size()) {
                int i = 0;
                Color[] clrs = this.currentPalette.getColors(this.colors.size());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                for (ColorEntry ce : this.colors) {
                    if (ce.getLabel() != null && ce.getLabel().equals("-no data-")) continue;
                    ce.setColor(clrs[i++]);
                }
            } else if (this.currentPalette.getType().isSuitableUnique()) {
                Color[] clrs = this.currentPalette.getColors(this.currentPalette.getMaxColors());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                int i = 0;
                for (ColorEntry ce : this.colors) {
                    if (ce.getLabel() != null && ce.getLabel().equals("-no data-")) continue;
                    ce.setColor(clrs[i % clrs.length]);
                    ++i;
                }
            } else {
                Color[] clrs = this.currentPalette.getColors(this.currentPalette.getMaxColors());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                int i = 0;
                for (ColorEntry ce : this.colors) {
                    if (ce.getLabel() != null && ce.getLabel().equals("-no data-")) continue;
                    ce.setColor(clrs[i]);
                    if (i >= clrs.length - 1) continue;
                    ++i;
                }
            }
        }
    }

    @Override
    public void refresh() {
        this.tblViewer.setInput((Object)this.colors.toArray(new Object[this.colors.size()]));
        this.tblViewer.refresh();
    }

    @Override
    public void init(ColorMap cm) {
        this.colors.clear();
        ColorMapEntry[] entries = cm.getColorMapEntries();
        int i = 0;
        while (i < entries.length) {
            ColorEntry ce = new ColorEntry();
            ce.setColor((Color)entries[i].getColor().evaluate(null, Color.class));
            ce.setValue((Double)entries[i].getQuantity().evaluate(null, Double.class));
            if (entries[i].getOpacity() != null) {
                ce.setOpacity((Double)entries[i].getOpacity().evaluate(null, Double.class));
            } else {
                ce.setOpacity(1.0);
            }
            ce.setLabel(entries[i].getLabel());
            this.colors.add(ce);
            ++i;
        }
        this.refresh();
        this.validate();
    }

    public void setBreaks(List<ColorEntry> newValues) {
        this.colors.clear();
        this.colors.addAll(newValues);
        this.updateColors();
        this.refresh();
        this.validate();
    }

    private void validate() {
        if (this.colors.size() > 256) {
            this.page.setErrorMessage(MessageFormat.format(Messages.UniqueValuesPanel_MaxValueError, 256));
        } else {
            this.page.setErrorMessage(null);
        }
    }

    @Override
    public String getName() {
        return Messages.UniqueValuesPanel_UniqueValuesLabel;
    }

    @Override
    public void computeValues() {
        GridCoverageReader reader = this.page.getGridCoverageReader();
        try {
            UniqueValuesDialog dialog = new UniqueValuesDialog(this.page.getShell(), reader);
            if (dialog.open() == 0) {
                dialog.updatePanel(this);
            }
        }
        finally {
            try {
                reader.dispose();
            }
            catch (IOException e) {
                SLDPlugin.log("Error disposing of reader", e);
            }
        }
    }

    @Override
    public String getComputeValuesLabel() {
        return Messages.UniqueValuesPanel_ComputeValuesLabel;
    }

    @Override
    public boolean canSupport(int colorMapType) {
        return colorMapType == 3;
    }

    @Override
    public void setFormatter(ValueFormatter format) {
        this.formatter = format;
    }

    @Override
    public void setInitialColorPalette(BrewerPalette palette) {
        if (this.currentPalette == null) {
            this.currentPalette = palette;
        }
        this.refresh();
    }

    private static enum TableColumn {
        COLOR(Messages.UniqueValuesPanel_ColorColumnName, 50),
        OPACITY(Messages.UniqueValuesPanel_OpacityColumnName, 60),
        VALUE(Messages.UniqueValuesPanel_ValueColumnName, 60),
        LABEL(Messages.UniqueValuesPanel_LabelColumnName, 100);

        String guiName;
        int size;

        private TableColumn(String guiName, int size) {
            this.guiName = guiName;
            this.size = size;
        }

        public CellEditor getCellEditor(TableViewer tableViewer) {
            if (this == COLOR) {
                return new ColorCellEditor((Composite)tableViewer.getTable());
            }
            if (this == OPACITY || this == VALUE || this == LABEL) {
                return new TextCellEditor((Composite)tableViewer.getTable());
            }
            return null;
        }

        public void updateValue(ColorEntry entry, Object newValue) {
            if (this == COLOR) {
                if (newValue instanceof Color) {
                    entry.setColor((Color)newValue);
                } else if (newValue instanceof RGB) {
                    RGB r = (RGB)newValue;
                    entry.setColor(new Color(r.red, r.green, r.blue));
                }
            } else if (this == OPACITY) {
                if (newValue instanceof Double) {
                    entry.setOpacity((Double)newValue);
                } else if (newValue instanceof String) {
                    try {
                        Double d = Double.parseDouble((String)newValue);
                        if (d >= 0.0 && d <= 1.0) {
                            entry.setOpacity(d);
                        } else if (d >= 0.0 && d <= 100.0) {
                            entry.setOpacity(d / 100.0);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (this == VALUE) {
                if (newValue instanceof Double) {
                    entry.setValue((Double)newValue);
                } else if (newValue instanceof String) {
                    try {
                        entry.setValue(Double.parseDouble((String)newValue));
                    }
                    catch (Exception exception) {}
                }
            } else if (this == LABEL) {
                entry.setLabel(newValue.toString());
            }
        }

        private String getValue(ColorEntry entry, ValueFormatter formatter) {
            if (this == OPACITY) {
                return String.valueOf(String.valueOf(entry.getOpacity() * 100.0)) + "%";
            }
            if (this == VALUE) {
                return formatter.formatNumber(entry.getValue());
            }
            if (this == LABEL) {
                if (entry.getLabel() == null) {
                    return "";
                }
                return entry.getLabel();
            }
            return "";
        }
    }

    private class TableLabelProvider
    extends CellLabelProvider {
        private TableLabelProvider() {
        }

        public Image getImage(Object element, int index) {
            if (element instanceof ColorEntry && TableColumn.values()[index] == TableColumn.COLOR) {
                return ((ColorEntry)element).getImage();
            }
            return null;
        }

        public String getText(Object element, int index) {
            if (element instanceof ColorEntry) {
                return TableColumn.values()[index].getValue((ColorEntry)element, UniqueValuesPanel.this.formatter);
            }
            return "";
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element, cell.getColumnIndex()));
            Image image = this.getImage(element, cell.getColumnIndex());
            cell.setImage(image);
        }
    }
}

