/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.CustomDynamicPalette;
import net.refractions.udig.style.sld.editor.CustomPalettesLoader;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.style.sld.editor.internal.BrewerPaletteLabelProvider;
import net.refractions.udig.style.sld.editor.raster.FormatDialog;
import net.refractions.udig.style.sld.editor.raster.IColorMapTypePanel;
import net.refractions.udig.style.sld.editor.raster.IntervalValuesPanel;
import net.refractions.udig.style.sld.editor.raster.PredefinedColorRules;
import net.refractions.udig.style.sld.editor.raster.RampValuesPanel;
import net.refractions.udig.style.sld.editor.raster.UniqueValuesPanel;
import net.refractions.udig.style.sld.editor.raster.ValueFormatter;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.style.ColorMap;

public class SingleBandEditorPage
extends StyleEditorPage {
    public static final int MAX_ENTRIES = 256;
    private static final String SLD_EXTENSION = ".sld";
    private double[] noDataValues = null;
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private LabelProvider brewerLblProvider = new BrewerPaletteLabelProvider();
    private final IColorMapTypePanel[] stylePanels = new IColorMapTypePanel[]{new UniqueValuesPanel(this), new RampValuesPanel(this), new IntervalValuesPanel(this)};
    private String errorMessage = null;
    private ComboViewer cmbThemingStyle;
    private ComboViewer cmbPalette;
    private Composite tableComp;
    private ColorBrewer brewer = null;
    private boolean reverseColors = false;
    private ValueFormatter formatter = new ValueFormatter();
    private PredefinedColorRules colorRules;

    @Override
    public boolean okToLeave() {
        return this.errorMessage == null;
    }

    @Override
    public boolean performOk() {
        return this.performApply();
    }

    @Override
    public boolean performApply() {
        try {
            this.updateStyle();
        }
        catch (Exception ex) {
            SLDPlugin.log("Error applying style.", ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SingleBandEditorPage_Error, (String)(String.valueOf(Messages.SingleBandEditorPage_ApplyError) + ex.getLocalizedMessage()));
            return false;
        }
        return true;
    }

    @Override
    public void refresh() {
        this.init();
    }

    @Override
    public void createPageContent(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(3, false));
        Label lbl = new Label(main, 0);
        lbl.setText(Messages.SingleBandEditorPage_ThemingStyleLabel);
        this.cmbThemingStyle = new ComboViewer(main, 12);
        this.cmbThemingStyle.getControl().setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        ((GridData)this.cmbThemingStyle.getControl().getLayoutData()).widthHint = 150;
        this.cmbThemingStyle.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cmbThemingStyle.setInput((Object)this.stylePanels);
        this.cmbThemingStyle.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IColorMapTypePanel) {
                    return ((IColorMapTypePanel)element).getName();
                }
                return super.getText(element);
            }
        });
        lbl = new Label(main, 0);
        lbl.setText(Messages.SingleBandEditorPage_ColorPaletteLabel);
        this.cmbPalette = this.createPaletteViewer(main);
        final Button btnTest = new Button(main, 8);
        btnTest.setText(Messages.SingleBandEditorPage_ComputeBreaksButtonText);
        btnTest.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        btnTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleBandEditorPage.this.getCurrentSelection().computeValues();
            }
        });
        this.tableComp = new Composite(main, 0);
        this.tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tableComp.setLayout((Layout)new StackLayout());
        final HashMap<IColorMapTypePanel, Composite> stacks = new HashMap<IColorMapTypePanel, Composite>();
        IColorMapTypePanel[] iColorMapTypePanelArray = this.stylePanels;
        int n = this.stylePanels.length;
        int n2 = 0;
        while (n2 < n) {
            IColorMapTypePanel pnl = iColorMapTypePanelArray[n2];
            Composite stack = pnl.createControl(this.tableComp);
            stacks.put(pnl, stack);
            ++n2;
        }
        Composite linkPnl = new Composite(main, 0);
        linkPnl.setLayout((Layout)new GridLayout(4, false));
        linkPnl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Link lnk = new Link(linkPnl, 0);
        lnk.setText("<a>" + Messages.SingleBandEditorPage_ReverseColorLabel + "</a>");
        lnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleBandEditorPage.this.reverseColors = !SingleBandEditorPage.this.reverseColors;
                if (SingleBandEditorPage.this.getCurrentSelection() != null) {
                    org.geotools.styling.ColorMap cm;
                    Object x = ((IStructuredSelection)SingleBandEditorPage.this.cmbPalette.getSelection()).getFirstElement();
                    if (x instanceof BrewerPalette) {
                        BrewerPalette palette = (BrewerPalette)((IStructuredSelection)SingleBandEditorPage.this.cmbPalette.getSelection()).getFirstElement();
                        SingleBandEditorPage.this.getCurrentSelection().setColorPalette(palette, SingleBandEditorPage.this.reverseColors);
                    } else if (x instanceof PredefinedColorRules.PredefinedColorRule && (cm = ((PredefinedColorRules.PredefinedColorRule)x).getColorMap()) != null && SingleBandEditorPage.this.getCurrentSelection() != null) {
                        if (SingleBandEditorPage.this.reverseColors) {
                            ColorMapImpl reverse = new ColorMapImpl();
                            int i = 0;
                            while (i < cm.getColorMapEntries().length) {
                                ColorMapEntry entry = cm.getColorMapEntries()[i];
                                ColorMapEntryImpl clone = new ColorMapEntryImpl();
                                clone.setColor(cm.getColorMapEntry(cm.getColorMapEntries().length - 1 - i).getColor());
                                clone.setLabel(entry.getLabel());
                                clone.setQuantity(entry.getQuantity());
                                clone.setOpacity(entry.getOpacity());
                                reverse.addColorMapEntry((ColorMapEntry)clone);
                                ++i;
                            }
                            cm = reverse;
                        }
                        SingleBandEditorPage.this.getCurrentSelection().init(cm);
                    }
                }
            }
        });
        Label lblSep = new Label(linkPnl, 514);
        GridData gd = new GridData(4, 4, false, false);
        gd.heightHint = 10;
        lblSep.setLayoutData((Object)gd);
        lnk = new Link(linkPnl, 0);
        lnk.setText("<a>" + Messages.SingleBandEditorPage_FormatExportLink + "</a>");
        lnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleBandEditorPage.this.getFormat();
            }
        });
        Link lnk2 = new Link(linkPnl, 0);
        lnk2.setText("<a>" + Messages.SingleBandEditorPage_OneClickExportLink + "</a>");
        lnk2.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        lnk2.setToolTipText(Messages.SingleBandEditorPage_OneClickTooltip);
        lnk2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleBandEditorPage.this.oneClickExport();
            }
        });
        this.cmbThemingStyle.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IColorMapTypePanel panel = SingleBandEditorPage.this.getCurrentSelection();
                if (panel != null) {
                    org.geotools.styling.ColorMap cm;
                    ((StackLayout)((SingleBandEditorPage)SingleBandEditorPage.this).tableComp.getLayout()).topControl = (Control)stacks.get(panel);
                    SingleBandEditorPage.this.tableComp.layout();
                    btnTest.setText(panel.getComputeValuesLabel());
                    btnTest.getParent().layout();
                    Object x = ((IStructuredSelection)SingleBandEditorPage.this.cmbPalette.getSelection()).getFirstElement();
                    if (x instanceof BrewerPalette) {
                        BrewerPalette palette = (BrewerPalette)x;
                        SingleBandEditorPage.this.getCurrentSelection().setInitialColorPalette(palette);
                    } else if (x instanceof PredefinedColorRules.PredefinedColorRule && (cm = ((PredefinedColorRules.PredefinedColorRule)x).getColorMap()) != null && SingleBandEditorPage.this.getCurrentSelection() != null) {
                        SingleBandEditorPage.this.getCurrentSelection().init(cm);
                    }
                }
            }
        });
        this.cmbPalette.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                org.geotools.styling.ColorMap cm;
                Object x = ((IStructuredSelection)SingleBandEditorPage.this.cmbPalette.getSelection()).getFirstElement();
                if (x instanceof BrewerPalette) {
                    BrewerPalette palette = (BrewerPalette)x;
                    if (SingleBandEditorPage.this.getCurrentSelection() != null) {
                        SingleBandEditorPage.this.getCurrentSelection().setColorPalette(palette, SingleBandEditorPage.this.reverseColors);
                    }
                } else if (x instanceof PredefinedColorRules.PredefinedColorRule && (cm = ((PredefinedColorRules.PredefinedColorRule)x).getColorMap()) != null && SingleBandEditorPage.this.getCurrentSelection() != null) {
                    SingleBandEditorPage.this.getCurrentSelection().init(cm);
                }
            }
        });
        this.cmbThemingStyle.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SingleBandEditorPage.this.colorRules != null) {
                    SingleBandEditorPage.this.colorRules.dispose();
                }
            }
        });
        this.init();
    }

    private void getFormat() {
        FormatDialog fd = new FormatDialog(this.getShell(), this.formatter);
        if (fd.open() == 0) {
            if (fd.getSelectedDataType() != null) {
                this.formatter.setDataType(fd.getSelectedDataType());
                this.formatter.setNumberFormatter(null);
            } else if (fd.getSelectedDataType() == null && fd.getCustom() == null) {
                this.formatter.setDataType(null);
                this.formatter.setNumberFormatter(null);
            } else {
                this.formatter.setNumberFormatter(fd.getCustom());
            }
            IColorMapTypePanel[] iColorMapTypePanelArray = this.stylePanels;
            int n = this.stylePanels.length;
            int n2 = 0;
            while (n2 < n) {
                IColorMapTypePanel pnl = iColorMapTypePanelArray[n2];
                pnl.refresh();
                ++n2;
            }
        }
    }

    private void oneClickExport() {
        IGeoResource geoResource = this.getSelectedLayer().getGeoResource();
        ID id = geoResource.getID();
        if (id.isFile()) {
            try {
                File file = id.toFile();
                SLDTransformer aTransformer = new SLDTransformer();
                aTransformer.setIndentation(4);
                String xml = aTransformer.transform((Object)this.getSLD());
                File newFile = new File(file.getParent(), String.valueOf(FilenameUtils.getBaseName((String)file.getAbsolutePath())) + SLD_EXTENSION);
                FileUtils.writeStringToFile((File)newFile, (String)xml);
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SingleBandEditorPage_ExportOkDialogTitle, (String)Messages.SingleBandEditorPage_ExportOkDialogMessage);
            }
            catch (Exception e1) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SingleBandEditorPage_ErrorDialogTitle, (String)Messages.SingleBandEditorPage_ErrorMessage);
                e1.printStackTrace();
            }
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SingleBandEditorPage_WarningDialogTitle, (String)Messages.SingleBandEditorPage_WarningMessage);
        }
    }

    private IColorMapTypePanel getCurrentSelection() {
        return (IColorMapTypePanel)((IStructuredSelection)this.cmbThemingStyle.getSelection()).getFirstElement();
    }

    public GridCoverageReader getGridCoverageReader() {
        try {
            GridCoverageReader reader = (GridCoverageReader)this.getSelectedLayer().getGeoResource().resolve(GridCoverageReader.class, null);
            return reader;
        }
        catch (Exception ex) {
            SLDPlugin.log("Error getting grid coverage.", ex);
            return null;
        }
    }

    public static final void sortEntries(ColorMapEntry[] entries) {
        Arrays.sort(entries, new Comparator<ColorMapEntry>(){

            @Override
            public int compare(ColorMapEntry c0, ColorMapEntry c1) {
                Number v1 = (Number)c0.getQuantity().evaluate(null, Double.class);
                Number v2 = (Number)c1.getQuantity().evaluate(null, Double.class);
                return Double.valueOf(v1.doubleValue()).compareTo(v2.doubleValue());
            }
        });
    }

    private void updateStyle() throws Exception {
        RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
        org.geotools.styling.ColorMap colorMap = this.getCurrentSelection().getColorMap();
        rasterSym.setColorMap((ColorMap)colorMap);
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        newStyle.setName(this.getSelectedLayer().getName());
        StyleBlackboard styleBlackboard = this.getSelectedLayer().getStyleBlackboard();
        styleBlackboard.put("net.refractions.udig.style.sld", (Object)newStyle);
        styleBlackboard.setSelected(new String[]{"net.refractions.udig.style.sld"});
        Object x = ((IStructuredSelection)this.cmbPalette.getSelection()).getFirstElement();
        if (x instanceof BrewerPalette) {
            BrewerPalette palette = (BrewerPalette)x;
            if (palette != null) {
                styleBlackboard.put("net.refractions.udig.style.raster.palette", (Object)palette.getName());
            }
        } else if (x instanceof PredefinedColorRules.PredefinedColorRule) {
            styleBlackboard.put("net.refractions.udig.style.raster.palette", (Object)((PredefinedColorRules.PredefinedColorRule)x).getName());
        }
    }

    private ComboViewer createPaletteViewer(Composite parent) {
        ComboViewer thiscv = new ComboViewer(parent, 12);
        thiscv.getControl().setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        ((GridData)thiscv.getControl().getLayoutData()).widthHint = 150;
        thiscv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof BrewerPalette) {
                    return SingleBandEditorPage.this.brewerLblProvider.getText(element);
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof PredefinedColorRules.PredefinedColorRule) {
                    return ((PredefinedColorRules.PredefinedColorRule)element).getName();
                }
                return super.getText(element);
            }
        });
        thiscv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return thiscv;
    }

    private ColorBrewer getBrewer() {
        if (this.brewer == null) {
            this.brewer = PlatformGIS.getColorBrewer();
            List<BrewerPalette> palettesList = CustomPalettesLoader.PALETTESLIST;
            for (BrewerPalette brewerPalette : palettesList) {
                this.brewer.registerPalette(brewerPalette);
            }
            CustomDynamicPalette customDynamicPalette = new CustomDynamicPalette(CustomDynamicPalette.TABLE.RAINBOW);
            this.brewer.registerPalette((BrewerPalette)customDynamicPalette);
            customDynamicPalette = new CustomDynamicPalette(CustomDynamicPalette.TABLE.GREY);
            this.brewer.registerPalette((BrewerPalette)customDynamicPalette);
        }
        return this.brewer;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public boolean performCancel() {
        return false;
    }

    @Override
    public void gotFocus() {
        this.cmbPalette.getControl().setFocus();
    }

    @Override
    public void styleChanged(Object source) {
    }

    public double[] getNoDataValues() {
        return this.noDataValues;
    }

    private void init() {
        Object dvalue;
        int n;
        StyleLayer l = this.getSelectedLayer();
        IColorMapTypePanel[] iColorMapTypePanelArray = this.stylePanels;
        int n2 = this.stylePanels.length;
        int n3 = 0;
        while (n3 < n2) {
            IColorMapTypePanel pnl = iColorMapTypePanelArray[n3];
            pnl.setFormatter(this.formatter);
            ++n3;
        }
        try {
            GridCoverage coverage = (GridCoverage)l.getGeoResource().resolve(GridCoverage.class, null);
            if (coverage.getNumSampleDimensions() > 0) {
                this.formatter.setRawDataType(coverage.getSampleDimension(0).getSampleDimensionType());
                this.noDataValues = coverage.getSampleDimension(0).getNoDataValues();
            }
        }
        catch (Exception exception) {}
        if (this.colorRules != null) {
            this.colorRules.dispose();
            this.colorRules = null;
        }
        this.colorRules = new PredefinedColorRules(this.getGridCoverageReader(), this.noDataValues);
        Style style = (Style)l.getStyleBlackboard().get("net.refractions.udig.style.sld");
        RasterSymbolizer symbolizer = SLD.rasterSymbolizer((Style)style);
        if (symbolizer != null && symbolizer.getColorMap() != null) {
            org.geotools.styling.ColorMap cm = symbolizer.getColorMap();
            IColorMapTypePanel[] iColorMapTypePanelArray2 = this.stylePanels;
            n = this.stylePanels.length;
            int n4 = 0;
            while (n4 < n) {
                IColorMapTypePanel pnl = iColorMapTypePanelArray2[n4];
                if (pnl.canSupport(cm.getType())) {
                    pnl.init(cm);
                    this.cmbThemingStyle.setSelection((ISelection)new StructuredSelection((Object)pnl));
                    this.cmbThemingStyle.getControl().notifyListeners(13, new Event());
                }
                ++n4;
            }
            if (this.formatter.getRawDataType() == ValueFormatter.DataType.INTEGER) {
                try {
                    iColorMapTypePanelArray2 = cm.getColorMapEntries();
                    n = iColorMapTypePanelArray2.length;
                    n4 = 0;
                    while (n4 < n) {
                        IColorMapTypePanel e = iColorMapTypePanelArray2[n4];
                        dvalue = (Double)e.getQuantity().evaluate(null, Double.class);
                        Integer ivalue = (Integer)e.getQuantity().evaluate(null, Integer.class);
                        if (ivalue.doubleValue() != ((Double)dvalue).doubleValue()) {
                            this.formatter.setDataType(ValueFormatter.DataType.DOUBLE);
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {}
            }
        }
        ArrayList<Object> inputs = new ArrayList<Object>();
        BrewerPalette[] palettes = this.getBrewer().getPalettes(ColorBrewer.ALL);
        Arrays.sort(palettes, 0, palettes.length, new Comparator<BrewerPalette>(){

            @Override
            public int compare(BrewerPalette arg0, BrewerPalette arg1) {
                return Collator.getInstance().compare(SingleBandEditorPage.this.brewerLblProvider.getText((Object)arg0), SingleBandEditorPage.this.brewerLblProvider.getText((Object)arg1));
            }
        });
        dvalue = palettes;
        int n5 = palettes.length;
        n = 0;
        while (n < n5) {
            BrewerPalette p = dvalue[n];
            inputs.add(p);
            ++n;
        }
        inputs.add(Messages.SingleBandEditorPage_predefinedStyleSeperator);
        for (PredefinedColorRules.PredefinedColorRule key : this.colorRules.getPredefinedSets()) {
            inputs.add(key);
        }
        this.cmbPalette.setInput(inputs);
        String paletteName = (String)l.getStyleBlackboard().get("net.refractions.udig.style.raster.palette");
        if (paletteName != null) {
            ColorBrewer cb = this.getBrewer();
            BrewerPalette palette = cb.getPalette(paletteName);
            if (palette != null) {
                this.cmbPalette.setSelection((ISelection)new StructuredSelection((Object)cb.getPalette(paletteName)));
            } else {
                PredefinedColorRules.PredefinedColorRule cm = this.colorRules.getPredefinedRule(paletteName);
                if (cm != null) {
                    this.cmbPalette.setSelection((ISelection)new StructuredSelection((Object)cm));
                }
            }
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        super.getContainer().updateMessage();
    }
}

