/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.io.IOException;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ClassifyDialog;
import net.refractions.udig.style.sld.editor.raster.ColorEntry;
import net.refractions.udig.style.sld.editor.raster.SingleBandEditorPage;
import net.refractions.udig.style.sld.editor.raster.UniqueValuesPanel;
import net.refractions.udig.style.sld.internal.Messages;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.builder.ColorMapEntryBuilder;
import org.opengis.coverage.grid.GridCoverageReader;

public class RampValuesPanel
extends UniqueValuesPanel {
    public RampValuesPanel(SingleBandEditorPage page) {
        super(page);
    }

    @Override
    public ColorMap getColorMap() throws Exception {
        this.sort();
        this.refresh();
        ColorMapImpl colorMap = new ColorMapImpl();
        colorMap.setType(1);
        int i = 0;
        while (i < this.colors.size()) {
            ColorEntry c1 = (ColorEntry)this.colors.get(i);
            ColorMapEntryBuilder cme = new ColorMapEntryBuilder();
            ColorMapEntry e = cme.color(c1.getColor()).opacity(c1.getOpacity()).quantity(this.formatter.formatNumber(c1.getValue())).build();
            if (c1.getLabel() != null && !c1.getLabel().trim().isEmpty()) {
                e.setLabel(c1.getLabel());
            }
            colorMap.addColorMapEntry(e);
            ++i;
        }
        return colorMap;
    }

    @Override
    public boolean canSupport(int colorMapType) {
        return colorMapType == 1;
    }

    @Override
    public String getName() {
        return Messages.RampValuesPanel_RampTypeName;
    }

    @Override
    public void computeValues() {
        GridCoverageReader reader = this.page.getGridCoverageReader();
        try {
            ClassifyDialog dialog = new ClassifyDialog(this.page.getShell(), reader, this.page.getNoDataValues());
            if (dialog.open() == 0) {
                dialog.updatePanel(this);
            }
        }
        finally {
            try {
                reader.dispose();
            }
            catch (IOException e) {
                SLDPlugin.log("Error disposing of reader", e);
            }
        }
    }

    @Override
    public String getComputeValuesLabel() {
        return Messages.RampValuesPanel_ComputeIntervalsButtonName;
    }
}

