/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.raster.ClassifyDialog;
import net.refractions.udig.style.sld.editor.raster.ColorEntry;
import net.refractions.udig.style.sld.editor.raster.IColorMapTypePanel;
import net.refractions.udig.style.sld.editor.raster.SingleBandEditorPage;
import net.refractions.udig.style.sld.editor.raster.ValueFormatter;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.builder.ColorMapEntryBuilder;
import org.opengis.coverage.grid.GridCoverageReader;

public class IntervalValuesPanel
implements IColorMapTypePanel {
    private TableViewer tblViewer;
    protected ArrayList<ColorEntry> colors = new ArrayList();
    private Composite control = null;
    private BrewerPalette currentPalette;
    private SingleBandEditorPage page;
    private boolean reverseColors = false;
    private ValueFormatter formatter;

    public IntervalValuesPanel(SingleBandEditorPage page) {
        this.page = page;
    }

    public Composite getControl() {
        return this.control;
    }

    @Override
    public Composite createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(2, false));
        this.tblViewer = new TableViewer(main, 67586);
        this.tblViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.tblViewer.getTable().getLayoutData()).heightHint = 250;
        this.tblViewer.getTable().setHeaderVisible(true);
        this.tblViewer.getTable().setLinesVisible(true);
        TableLabelProvider labelProvider = new TableLabelProvider();
        int i = 0;
        while (i < TableColumn.values().length) {
            final TableColumn col = TableColumn.values()[i];
            TableViewerColumn colOpacity = new TableViewerColumn(this.tblViewer, 0x1000000);
            colOpacity.setLabelProvider((CellLabelProvider)labelProvider);
            colOpacity.getColumn().setText(col.guiName);
            colOpacity.getColumn().setWidth(col.size);
            colOpacity.setEditingSupport(new EditingSupport(colOpacity.getViewer()){

                protected CellEditor getCellEditor(Object element) {
                    return col.getCellEditor(IntervalValuesPanel.this.tblViewer);
                }

                protected boolean canEdit(Object element) {
                    return element instanceof ColorEntry;
                }

                protected Object getValue(Object element) {
                    if (col == TableColumn.COLOR) {
                        Color c = ((ColorEntry)element).getColor();
                        return new RGB(c.getRed(), c.getGreen(), c.getBlue());
                    }
                    return col.getValue((ColorEntry)element, IntervalValuesPanel.this.colors, IntervalValuesPanel.this.formatter);
                }

                protected void setValue(Object element, Object value) {
                    col.updateValue((ColorEntry)element, value);
                    IntervalValuesPanel.this.tblViewer.refresh();
                }
            });
            ++i;
        }
        this.tblViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tblViewer.setInput((Object)this.colors.toArray(new Object[this.colors.size()]));
        this.createButtonPanel(main);
        return main;
    }

    private void createButtonPanel(Composite parent) {
        Composite btnPanel = new Composite(parent, 0);
        btnPanel.setLayout((Layout)new GridLayout(1, false));
        btnPanel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Button btnAdd = new Button(btnPanel, 8);
        btnAdd.setText(Messages.IntervalValuesPanel_AddButton);
        btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorEntry ce = new ColorEntry();
                IntervalValuesPanel.this.colors.add(ce);
                IntervalValuesPanel.this.updateColors();
                IntervalValuesPanel.this.refresh();
                IntervalValuesPanel.this.validate();
            }
        });
        final Button btnRemove = new Button(btnPanel, 8);
        btnRemove.setText(Messages.IntervalValuesPanel_RemoveButton);
        btnRemove.setEnabled(false);
        btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.tblViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                btnRemove.setEnabled(!IntervalValuesPanel.this.tblViewer.getSelection().isEmpty());
            }
        });
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object type : (IStructuredSelection)IntervalValuesPanel.this.tblViewer.getSelection()) {
                    if (!(type instanceof ColorEntry)) continue;
                    IntervalValuesPanel.this.colors.remove(type);
                }
                IntervalValuesPanel.this.updateColors();
                IntervalValuesPanel.this.refresh();
                IntervalValuesPanel.this.validate();
            }
        });
        Button btnSort = new Button(btnPanel, 8);
        btnSort.setText(Messages.IntervalValuesPanel_SortButton);
        btnSort.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        btnSort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntervalValuesPanel.this.sort();
                IntervalValuesPanel.this.refresh();
            }
        });
        final Button btnSetNoData = new Button(btnPanel, 8);
        btnSetNoData.setText(Messages.IntervalValuesPanel_NoDataFlagButton);
        btnSetNoData.setEnabled(false);
        btnSetNoData.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.tblViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                btnSetNoData.setEnabled(!IntervalValuesPanel.this.tblViewer.getSelection().isEmpty());
            }
        });
        btnSetNoData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object type : (IStructuredSelection)IntervalValuesPanel.this.tblViewer.getSelection()) {
                    if (!(type instanceof ColorEntry)) continue;
                    ((ColorEntry)type).setLabel("-no data-");
                }
                IntervalValuesPanel.this.updateColors();
                IntervalValuesPanel.this.refresh();
            }
        });
    }

    private void updateColors() {
        block10: {
            if (this.currentPalette == null) break block10;
            if (this.currentPalette.getMaxColors() >= this.colors.size()) {
                int i = 0;
                Color[] clrs = this.currentPalette.getColors(this.colors.size());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                for (ColorEntry ce : this.colors) {
                    ce.setColor(clrs[i++]);
                }
            } else if (this.currentPalette.getType().isSuitableUnique()) {
                Color[] clrs = this.currentPalette.getColors(this.currentPalette.getMaxColors());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                int i = 0;
                for (ColorEntry ce : this.colors) {
                    ce.setColor(clrs[i % clrs.length]);
                    ++i;
                }
            } else {
                Color[] clrs = this.currentPalette.getColors(this.currentPalette.getMaxColors());
                if (this.reverseColors) {
                    this.reverse(clrs);
                }
                int i = 0;
                for (ColorEntry ce : this.colors) {
                    ce.setColor(clrs[i]);
                    if (i >= clrs.length - 1) continue;
                    ++i;
                }
            }
        }
    }

    private void sort() {
        Collections.sort(this.colors, new Comparator<ColorEntry>(){

            @Override
            public int compare(ColorEntry o1, ColorEntry o2) {
                return Double.valueOf(o1.getValue()).compareTo(o2.getValue());
            }
        });
    }

    @Override
    public ColorMap getColorMap() throws Exception {
        this.sort();
        this.refresh();
        ColorMapImpl colorMap = new ColorMapImpl();
        colorMap.setType(2);
        ArrayList<ColorMapEntry> entries = new ArrayList<ColorMapEntry>();
        int i = 0;
        while (i < this.colors.size()) {
            ColorEntry c1 = this.colors.get(i);
            ColorMapEntryBuilder cme = new ColorMapEntryBuilder();
            ColorMapEntry e = cme.color(c1.getColor()).opacity(c1.getOpacity()).quantity(this.formatter.formatNumber(c1.getValue())).build();
            if (c1.getLabel() != null && !c1.getLabel().trim().isEmpty()) {
                e.setLabel(c1.getLabel());
            }
            entries.add(e);
            ++i;
        }
        ColorMapEntry[] sorted = entries.toArray(new ColorMapEntry[0]);
        SingleBandEditorPage.sortEntries(sorted);
        int i2 = 0;
        while (i2 < sorted.length) {
            colorMap.addColorMapEntry(sorted[i2]);
            ++i2;
        }
        return colorMap;
    }

    private void reverse(Color[] cls) {
        if (cls == null) {
            return;
        }
        int i = 0;
        int j = cls.length - 1;
        while (i < j) {
            Color tmp = cls[i];
            cls[i] = cls[j];
            cls[j] = tmp;
            --j;
            ++i;
        }
    }

    @Override
    public void setColorPalette(BrewerPalette palette, boolean reverse) {
        this.currentPalette = palette;
        this.reverseColors = reverse;
        this.updateColors();
        this.tblViewer.refresh();
    }

    @Override
    public void refresh() {
        this.tblViewer.setInput((Object)this.colors.toArray(new Object[this.colors.size()]));
        this.tblViewer.refresh();
    }

    @Override
    public void init(ColorMap cm) {
        this.colors.clear();
        ColorMapEntry[] entries = cm.getColorMapEntries();
        int i = 0;
        while (i < entries.length) {
            ColorEntry ce = new ColorEntry();
            ce.setColor((Color)entries[i].getColor().evaluate(null, Color.class));
            ce.setValue((Double)entries[i].getQuantity().evaluate(null, Double.class));
            if (entries[i].getOpacity() != null) {
                ce.setOpacity((Double)entries[i].getOpacity().evaluate(null, Double.class));
            } else {
                ce.setOpacity(1.0);
            }
            ce.setLabel(entries[i].getLabel());
            this.colors.add(ce);
            ++i;
        }
        this.refresh();
        this.validate();
    }

    public void setBreaks(List<ColorEntry> entries) {
        this.colors.clear();
        this.colors.addAll(entries);
        this.updateColors();
        this.refresh();
        this.validate();
    }

    private void validate() {
        if (this.colors.size() > 256) {
            this.page.setErrorMessage(MessageFormat.format(Messages.IntervalValuesPanel_MaxValueError, 256));
        } else {
            this.page.setErrorMessage(null);
        }
    }

    @Override
    public String getName() {
        return Messages.IntervalValuesPanel_IntervalsName;
    }

    @Override
    public void computeValues() {
        GridCoverageReader reader = this.page.getGridCoverageReader();
        try {
            ClassifyDialog dialog = new ClassifyDialog(this.page.getShell(), reader, this.page.getNoDataValues());
            if (dialog.open() == 0) {
                dialog.updatePanel(this);
            }
        }
        finally {
            try {
                reader.dispose();
            }
            catch (IOException e) {
                SLDPlugin.log("Error disposing of reader", e);
            }
        }
    }

    @Override
    public String getComputeValuesLabel() {
        return Messages.IntervalValuesPanel_ComputeIntervalsButtonText;
    }

    @Override
    public boolean canSupport(int colorMapType) {
        return colorMapType == 2;
    }

    @Override
    public void setFormatter(ValueFormatter format) {
        this.formatter = format;
    }

    @Override
    public void setInitialColorPalette(BrewerPalette palette) {
        if (this.currentPalette == null) {
            this.currentPalette = palette;
        }
        this.refresh();
    }

    private static enum TableColumn {
        COLOR(Messages.IntervalValuesPanel_ColorColumnName, 50),
        OPACITY(Messages.IntervalValuesPanel_OpacityColumnName, 60),
        VALUE(Messages.IntervalValuesPanel_ValueColumnName, 60),
        LABEL(Messages.IntervalValuesPanel_LabelColumnName, 100);

        String guiName;
        int size;

        private TableColumn(String guiName, int size) {
            this.guiName = guiName;
            this.size = size;
        }

        public CellEditor getCellEditor(TableViewer tableViewer) {
            if (this == COLOR) {
                return new ColorCellEditor((Composite)tableViewer.getTable());
            }
            if (this == OPACITY || this == VALUE || this == LABEL) {
                return new TextCellEditor((Composite)tableViewer.getTable());
            }
            return null;
        }

        public void updateValue(ColorEntry entry, Object newValue) {
            if (this == COLOR) {
                if (newValue instanceof Color) {
                    entry.setColor((Color)newValue);
                } else if (newValue instanceof RGB) {
                    RGB r = (RGB)newValue;
                    entry.setColor(new Color(r.red, r.green, r.blue));
                }
            } else if (this == OPACITY) {
                if (newValue instanceof Double) {
                    entry.setOpacity((Double)newValue);
                } else if (newValue instanceof String) {
                    try {
                        Double d = Double.parseDouble((String)newValue);
                        if (d >= 0.0 && d <= 1.0) {
                            entry.setOpacity(d);
                        } else if (d >= 0.0 && d <= 100.0) {
                            entry.setOpacity(d / 100.0);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (this == VALUE) {
                if (newValue instanceof Double) {
                    entry.setValue((Double)newValue);
                } else if (newValue instanceof String) {
                    try {
                        entry.setValue(Double.parseDouble((String)newValue));
                    }
                    catch (Exception exception) {}
                }
            } else if (this == LABEL) {
                entry.setLabel(newValue.toString());
            }
        }

        public String getValue(ColorEntry entry, List<ColorEntry> currentEntries, ValueFormatter formatter) {
            if (this == OPACITY) {
                return String.valueOf(String.valueOf(entry.getOpacity() * 100.0)) + "%";
            }
            if (this == VALUE) {
                int currentIndex = currentEntries.indexOf(entry);
                if (currentIndex <= 0) {
                    return "< " + formatter.formatNumber(entry.getValue());
                }
                ColorEntry prev = currentEntries.get(currentIndex - 1);
                return String.valueOf(formatter.formatNumber(prev.getValue())) + " <= x < " + formatter.formatNumber(entry.getValue());
            }
            if (this == LABEL) {
                if (entry.getLabel() == null) {
                    return "";
                }
                return entry.getLabel();
            }
            return "";
        }
    }

    class TableLabelProvider
    extends CellLabelProvider {
        TableLabelProvider() {
        }

        public Image getImage(Object element, int index) {
            if (element instanceof ColorEntry && TableColumn.values()[index] == TableColumn.COLOR) {
                return ((ColorEntry)element).getImage();
            }
            return null;
        }

        public String getText(Object element, int index) {
            if (element instanceof ColorEntry) {
                return TableColumn.values()[index].getValue((ColorEntry)element, IntervalValuesPanel.this.colors, IntervalValuesPanel.this.formatter);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element, cell.getColumnIndex()));
            Image image = this.getImage(element, cell.getColumnIndex());
            cell.setImage(image);
        }
    }
}

