/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.raster;

import java.text.DecimalFormat;
import net.refractions.udig.style.sld.editor.raster.ValueFormatter;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FormatDialog
extends TitleAreaDialog {
    private ValueFormatter.DataType selectedDataType = null;
    private DecimalFormat custom = null;
    private ValueFormatter currentFormat;
    private Text txtCustom;
    private Combo formatCombo;
    private Label lblInfo;
    private Label lblCustom;

    public FormatDialog(Shell parentShell, ValueFormatter currentformat) {
        super(parentShell);
        this.currentFormat = currentformat;
    }

    public void okPressed() {
        String invalid = null;
        if (this.formatCombo.getSelectionIndex() == 3) {
            if (this.txtCustom.getText().contains(",")) {
                invalid = Messages.FormatDialog_CommaInvalidFormatError;
            }
            try {
                this.custom = (DecimalFormat)DecimalFormat.getInstance();
                this.custom.applyPattern(this.txtCustom.getText());
            }
            catch (Exception ex) {
                invalid = String.valueOf(Messages.FormatDialog_InvalidFormatError) + ex.getLocalizedMessage();
            }
        } else {
            this.custom = null;
        }
        if (invalid != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.FormatDialog_ErrorDialotTitle, (String)invalid);
            return;
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FormatDialog_DialogTitle);
        this.setMessage(Messages.FormatDialog_DialogMessage);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(composite, 2048);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(main, 0);
        lbl.setText(Messages.FormatDialog_FormatTypeLabel);
        this.formatCombo = new Combo(main, 12);
        this.formatCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.formatCombo.add(Messages.FormatDialog_RawOp);
        this.formatCombo.add(Messages.FormatDialog_IntegerOp);
        this.formatCombo.add(Messages.FormatDialog_DoubleOp);
        this.formatCombo.add(Messages.FormatDialog_CustomOp);
        this.lblCustom = new Label(main, 0);
        this.lblCustom.setText(Messages.FormatDialog_CustomLabel);
        this.txtCustom = new Text(main, 2048);
        this.txtCustom.setText(Messages.FormatDialog_CustomFormat);
        this.txtCustom.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(main, 0);
        this.lblInfo = new Label(main, 64);
        this.lblInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)this.lblInfo.getLayoutData()).widthHint = 100;
        this.lblInfo.setText(Messages.FormatDialog_CustomHelp);
        this.formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDialog.this.comboSelected();
            }
        });
        ValueFormatter.DataType type = this.currentFormat.getDataType();
        DecimalFormat curr = this.currentFormat.getFormat();
        if (type == null && curr == null) {
            this.formatCombo.select(0);
        } else if (curr == null && type == ValueFormatter.DataType.INTEGER) {
            this.formatCombo.select(1);
        } else if (curr == null && type == ValueFormatter.DataType.DOUBLE) {
            this.formatCombo.select(2);
        } else if (curr != null) {
            this.formatCombo.select(3);
            this.txtCustom.setText(curr.toPattern());
        }
        this.comboSelected();
        return composite;
    }

    private void comboSelected() {
        boolean hide = true;
        int index = this.formatCombo.getSelectionIndex();
        if (index == 0) {
            this.selectedDataType = null;
            this.custom = null;
        } else if (index == 1) {
            this.selectedDataType = ValueFormatter.DataType.INTEGER;
            this.custom = null;
        } else if (index == 2) {
            this.selectedDataType = ValueFormatter.DataType.DOUBLE;
            this.custom = null;
        } else if (index == 3) {
            this.selectedDataType = null;
            this.custom = null;
            hide = false;
        }
        this.lblCustom.setVisible(!hide);
        this.txtCustom.setVisible(!hide);
        this.lblInfo.setVisible(!hide);
    }

    public ValueFormatter.DataType getSelectedDataType() {
        return this.selectedDataType;
    }

    public DecimalFormat getCustom() {
        return this.custom;
    }
}

