/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.refractions.udig.style.sld.editor.internal.FilteredEditorDialog;
import net.refractions.udig.style.sld.editor.internal.PageHistoryEntry;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

class PageHistoryHolder {
    private ToolBarManager historyToolbar;
    private List<PageHistoryEntry> history = new ArrayList<PageHistoryEntry>();
    private int historyIndex = -1;
    private final FilteredEditorDialog dialog;
    private Set<IHandlerActivation> activations = new HashSet<IHandlerActivation>();

    public PageHistoryHolder(FilteredEditorDialog dialog) {
        this.dialog = dialog;
    }

    private PageHistoryEntry getHistoryEntry(int index) {
        if (index >= 0 && index < this.history.size()) {
            return this.history.get(index);
        }
        return null;
    }

    public void addHistoryEntry(PageHistoryEntry entry) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(entry)) {
            this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            this.history.add(entry);
            ++this.historyIndex;
            this.updateHistoryControls();
        }
    }

    private void jumpToHistory(int index) {
        if (index >= 0 && index < this.history.size()) {
            this.historyIndex = index;
            this.dialog.setCurrentPageId(this.getHistoryEntry(index).getId());
        }
        this.updateHistoryControls();
    }

    private void updateHistoryControls() {
        this.historyToolbar.update(false);
        IContributionItem[] items = this.historyToolbar.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update("enabled");
            items[i].update("toolTipText");
            ++i;
        }
    }

    public ToolBar createHistoryControls(ToolBar historyBar, ToolBarManager manager) {
        this.historyToolbar = manager;
        abstract class HistoryNavigationAction
        extends Action
        implements IMenuCreator {
            private Menu lastMenu;
            protected static final int MAX_ENTRIES = 5;

            HistoryNavigationAction() {
                super("", 4);
            }

            public IMenuCreator getMenuCreator() {
                return this;
            }

            public void dispose() {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                    this.lastMenu = null;
                }
            }

            public Menu getMenu(Control parent) {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                }
                this.lastMenu = new Menu(parent);
                this.createEntries(this.lastMenu);
                return this.lastMenu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            protected void addActionToMenu(Menu parent, IAction action) {
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(parent, -1);
            }

            protected abstract void createEntries(Menu var1);
        }
        HistoryNavigationAction backward = new HistoryNavigationAction(){
            {
            }

            public void run() {
                PageHistoryHolder.this.jumpToHistory(PageHistoryHolder.this.historyIndex - 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = PageHistoryHolder.this.historyIndex > 0;
                if (enabled) {
                    this.setToolTipText(NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_backward_toolTipName, (Object)PageHistoryHolder.this.getHistoryEntry(PageHistoryHolder.this.historyIndex - 1).getLabel()));
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int limit = Math.max(0, PageHistoryHolder.this.historyIndex - 5);
                int i = PageHistoryHolder.this.historyIndex - 1;
                while (i >= limit) {
                    class HistoryItemAction
                    extends Action {
                        private final int index;

                        HistoryItemAction(int index, String label) {
                            super(label, 1);
                            this.index = index;
                        }

                        public void run() {
                            PageHistoryHolder.this.jumpToHistory(this.index);
                        }
                    }
                    HistoryItemAction action = new HistoryItemAction(i, PageHistoryHolder.this.getHistoryEntry(i).getLabel());
                    this.addActionToMenu(menu, (IAction)action);
                    --i;
                }
            }
        };
        backward.setText(WorkbenchMessages.NavigationHistoryAction_backward_text);
        backward.setActionDefinitionId("org.eclipse.ui.navigate.backwardHistory");
        backward.setImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.registerKeybindings((IAction)backward);
        this.historyToolbar.add((IAction)backward);
        HistoryNavigationAction forward = new HistoryNavigationAction(){
            {
            }

            public void run() {
                PageHistoryHolder.this.jumpToHistory(PageHistoryHolder.this.historyIndex + 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = PageHistoryHolder.this.historyIndex < PageHistoryHolder.this.history.size() - 1;
                if (enabled) {
                    this.setToolTipText(NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_forward_toolTipName, (Object)PageHistoryHolder.this.getHistoryEntry(PageHistoryHolder.this.historyIndex + 1).getLabel()));
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int limit = Math.min(PageHistoryHolder.this.history.size(), PageHistoryHolder.this.historyIndex + 5 + 1);
                int i = PageHistoryHolder.this.historyIndex + 1;
                while (i < limit) {
                    HistoryItemAction action = new HistoryItemAction(i, PageHistoryHolder.this.getHistoryEntry(i).getLabel());
                    this.addActionToMenu(menu, (IAction)action);
                    ++i;
                }
            }
        };
        forward.setText(WorkbenchMessages.NavigationHistoryAction_forward_text);
        forward.setActionDefinitionId("org.eclipse.ui.navigate.forwardHistory");
        forward.setImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.registerKeybindings((IAction)forward);
        this.historyToolbar.add((IAction)forward);
        return historyBar;
    }

    private void registerKeybindings(IAction action) {
        ActionHandler handler = new ActionHandler(action);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        IHandlerActivation activation = handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)handler);
        this.activations.add(activation);
    }

    public void dispose() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        Iterator<IHandlerActivation> iterator = this.activations.iterator();
        while (iterator.hasNext()) {
            handlerService.deactivateHandler(iterator.next());
        }
        this.activations.clear();
    }

    public Control createHistoryControls(Composite parent) {
        ToolBar historyBar = new ToolBar(parent, 0x800100);
        ToolBarManager historyManager = new ToolBarManager(historyBar);
        this.createHistoryControls(historyBar, historyManager);
        return historyBar;
    }
}

