/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor.internal;

import net.refractions.udig.style.sld.editor.internal.FilteredTree;
import net.refractions.udig.style.sld.editor.internal.PatternItemFilter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class FilteredComboTree
extends FilteredTree {
    private Combo filterCombo;
    private static final String SEARCHHISTORY = "search";
    private static final int maxNumItems = 20;

    public FilteredComboTree(Composite parent, int treeStyle) {
        super(parent, treeStyle);
    }

    public FilteredComboTree(Composite parent, int treeStyle, PatternItemFilter filter) {
        super(parent, treeStyle, filter);
    }

    @Override
    protected void createFilterControl(Composite parent) {
        this.filterCombo = new Combo(parent, 2052);
        this.filterCombo.setFont(parent.getFont());
        this.getPreferenceSearchHistory();
        this.filterCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredComboTree.this.getViewer().getTree().getItemCount() == 0) {
                        FilteredComboTree.this.setFilterText("");
                    } else {
                        FilteredComboTree.this.getViewer().getTree().setFocus();
                    }
                }
            }
        });
        this.filterCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String[] textValues = FilteredComboTree.this.filterCombo.getItems();
                String newText = FilteredComboTree.this.filterCombo.getText();
                if (newText.equals("") || newText.equals(FilteredComboTree.this.initialText)) {
                    return;
                }
                int i = 0;
                while (i < textValues.length) {
                    if (textValues[i].equals(newText)) {
                        return;
                    }
                    ++i;
                }
                if (textValues.length >= 20) {
                    FilteredComboTree.this.filterCombo.remove(19);
                }
                FilteredComboTree.this.filterCombo.add(newText, 0);
            }
        });
        this.filterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredComboTree.this.textChanged();
            }
        });
        this.filterCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredComboTree.this.saveDialogSettings();
            }
        });
        this.filterCombo.getAccessible().addAccessibleListener((AccessibleListener)this.getAccessibleListener());
    }

    @Override
    public Control getFilterControl() {
        return this.filterCombo;
    }

    @Override
    protected String getFilterControlText() {
        return this.filterCombo.getText();
    }

    @Override
    protected void setFilterText(String string) {
        this.filterCombo.setText(string);
        this.selectAll();
    }

    @Override
    protected void selectAll() {
        this.filterCombo.setSelection(new Point(0, this.filterCombo.getText().length()));
    }

    public Combo getFilterCombo() {
        return this.filterCombo;
    }

    @Override
    protected String getFilterText() {
        return this.filterCombo.getText();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings thisSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (thisSettings == null) {
            thisSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return thisSettings;
    }

    public void getPreferenceSearchHistory() {
        IDialogSettings settings = this.getDialogSettings();
        String[] search = settings.getArray(SEARCHHISTORY);
        if (search == null) {
            return;
        }
        int i = 0;
        while (i < search.length) {
            this.filterCombo.add(search[i]);
            ++i;
        }
    }

    private void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SEARCHHISTORY, this.filterCombo.getItems());
    }
}

