/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.style.sld.editor.SLDValidator;
import net.refractions.udig.style.sld.editor.StyleEditor;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.FeatureSource;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayerDescriptor;
import org.opengis.coverage.grid.GridCoverage;
import org.xml.sax.SAXParseException;

public class StyleXMLPage
extends StyleEditorPage {
    SashForm sash;
    Text sldTextBox;
    Text errTextBox;
    SLDValidator validator;
    Label validateStatus;
    Button validateButton;
    boolean validSLD = true;
    boolean dirty = false;

    @Override
    public void createPageContent(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        comp.setLayout((Layout)new GridLayout(3, false));
        this.sash = new SashForm(comp, 512);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = parent.getBounds().x;
        gd.heightHint = parent.getBounds().y;
        gd.horizontalSpan = 3;
        this.sash.setLayoutData((Object)gd);
        this.sldTextBox = new Text((Composite)this.sash, 2818);
        this.sldTextBox.setEditable(true);
        this.sldTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyleXMLPage.this.dirty = true;
                StyleXMLPage.this.validateStatus.setText(Messages.StyleEditor_xml_validation_needed);
                StyleXMLPage.this.validateButton.setEnabled(true);
            }
        });
        this.sldTextBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.errTextBox = new Text((Composite)this.sash, 2818);
        this.errTextBox.setVisible(false);
        this.errTextBox.setEditable(false);
        this.validateStatus = new Label(comp, 16384);
        this.validateStatus.setText(Messages.StyleEditor_xml_validation_needed);
        gd = new GridData(16384, 1024, true, false);
        this.validateStatus.setLayoutData((Object)gd);
        this.validateButton = new Button(comp, 131072);
        this.validateButton.setText(Messages.StyleEditor_xml_validate);
        gd = new GridData(131072, 0, false, false);
        this.validateButton.setLayoutData((Object)gd);
        this.validateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyleXMLPage.this.validateSLD();
                if (StyleXMLPage.this.validSLD) {
                    StyleXMLPage.this.updateSLD();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.styleChanged(null);
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        if (!this.validSLD) {
            return Messages.StyleEditor_xml_invalid;
        }
        return null;
    }

    public void validateSLD() {
        List<SAXParseException> result;
        Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
        this.setDisplayCursor(waitCursor);
        this.validateButton.setEnabled(false);
        this.validateStatus.setText(Messages.StyleEditor_xml_validation_progress);
        String xml = this.sldTextBox.getText();
        this.dirty = false;
        if (xml.length() == 0) {
            this.validSLD = false;
            this.sldTextBox.setText(this.styleToXML());
            return;
        }
        InputStream is = this.getXMLasInputStream(xml, "UTF-8");
        if (this.validator == null) {
            this.validator = new SLDValidator();
        }
        if ((result = this.validator.validateSLD(is, "http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd")) instanceof List) {
            List<SAXParseException> errorList = result;
            if (errorList.size() == 0) {
                this.validSLD = true;
                this.errTextBox.setText("");
                this.validateStatus.setText(Messages.StyleEditor_xml_validation_success);
                this.errTextBox.setVisible(false);
            } else {
                this.validSLD = false;
                this.errTextBox.setText(SLDValidator.getErrorMessage(is, errorList));
                this.validateStatus.setText(Messages.StyleEditor_xml_validation_failure);
                this.errTextBox.setVisible(true);
            }
            this.errTextBox.getParent().layout();
            this.getContainer().updateMessage();
        }
        try {
            try {
                is.close();
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        finally {
            this.resetCursor(waitCursor);
        }
        if (this.dirty) {
            this.validateButton.setEnabled(true);
            this.validateStatus.setText(Messages.StyleEditor_xml_validation_needed);
        }
    }

    private void resetCursor(Cursor c) {
        this.setDisplayCursor(null);
        c.dispose();
        c = null;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells = Display.getCurrent().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean okToLeave() {
        boolean readyToLeave = false;
        if (this.validSLD || !this.validSLD && this.dirty) {
            readyToLeave = this.updateSLD();
        }
        if (readyToLeave) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.StyleEditor_xml_lose_changes_1, (String)Messages.StyleEditor_xml_lose_changes_2);
    }

    @Override
    public boolean performOk() {
        return true;
    }

    private String styleToXML() {
        return StyleEditor.styleToXML(this.getSLD());
    }

    private StyledLayerDescriptor XMLtoSLD(String xml) {
        return this.XMLtoSLD(xml, "UTF-8");
    }

    private StyledLayerDescriptor XMLtoSLD(String xml, String encoding) {
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        InputStream is = this.getXMLasInputStream(xml, encoding);
        if (is == null) {
            return null;
        }
        SLDParser stylereader = new SLDParser(factory, is);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        return sld;
    }

    private InputStream getXMLasInputStream(String xml, String encoding) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xml.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e1) {
            throw (RuntimeException)new RuntimeException().initCause(e1);
        }
        return is;
    }

    @Override
    public void gotFocus() {
        this.refresh();
        this.dirty = false;
    }

    @Override
    public void styleChanged(Object source) {
        this.dirty = true;
        this.validateButton.setEnabled(true);
    }

    @Override
    public void refresh() {
        String xmlOrig = this.sldTextBox.getText();
        String xml = this.styleToXML();
        if (xml != null && !xml.equals(xmlOrig)) {
            this.sldTextBox.setText(xml);
            this.validSLD = true;
            this.dirty = true;
        }
    }

    private boolean updateSLD() {
        Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
        this.setDisplayCursor(waitCursor);
        StyledLayerDescriptor sld = null;
        Style style = null;
        String xml = this.sldTextBox.getText();
        if (xml == null) {
            this.resetCursor(waitCursor);
            return false;
        }
        try {
            sld = this.XMLtoSLD(xml);
            style = SLDs.getDefaultStyle((StyledLayerDescriptor)sld);
        }
        catch (Exception exception) {
            this.validSLD = false;
            boolean result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.StyleEditor_xml_failure_1, (String)Messages.StyleEditor_xml_failure_2);
            this.resetCursor(waitCursor);
            if (result) {
                try {
                    StyleLayer layer = this.getContainer().getSelectedLayer();
                    IGeoResource resource = layer.findGeoResource(FeatureSource.class);
                    if (resource != null) {
                        style = (Style)new SLDContent().createDefaultStyle(resource, layer.getDefaultColor(), null);
                    } else {
                        resource = layer.findGeoResource(GridCoverage.class);
                        if (resource != null) {
                            style = (Style)new SLDContent().createDefaultStyle(resource, layer.getDefaultColor(), null);
                        }
                    }
                    if (style != null) {
                        sld = SLDContent.createDefaultStyledLayerDescriptor(style);
                        this.setStyle(style);
                        this.refresh();
                    }
                }
                catch (IOException e1) {
                    throw (RuntimeException)new RuntimeException().initCause(e1);
                }
            }
            return false;
        }
        if (sld != null && style != null) {
            this.validSLD = true;
            this.setStyle(style);
            this.resetCursor(waitCursor);
            return true;
        }
        this.resetCursor(waitCursor);
        return false;
    }

    @Override
    public void dispose() {
        this.validator = null;
        super.dispose();
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public boolean performApply() {
        return this.updateSLD();
    }
}

