/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.BorderColorComboListener;
import net.refractions.udig.style.sld.editor.BrewerPaletteContentProvider;
import net.refractions.udig.style.sld.editor.BrewerPaletteViewerFilter;
import net.refractions.udig.style.sld.editor.BrewerPaletteViewerSorter;
import net.refractions.udig.style.sld.editor.CustomDynamicPalette;
import net.refractions.udig.style.sld.editor.CustomPalettesLoader;
import net.refractions.udig.style.sld.editor.CustomSampleScheme;
import net.refractions.udig.style.sld.editor.CustomUnknownPaletteSuitability;
import net.refractions.udig.style.sld.editor.IPaletteCellEditor;
import net.refractions.udig.style.sld.editor.StyleEditorDialog;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.style.sld.editor.internal.BrewerPaletteLabelProvider;
import net.refractions.udig.style.sld.editor.internal.StyleTreeContentProvider;
import net.refractions.udig.style.sld.editor.internal.StyleTreeLabelProvider;
import net.refractions.udig.style.sld.editor.internal.StyleTreeSorter;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.DecoratorOverlayIcon;
import net.refractions.udig.ui.ErrorManager;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.SLDs;
import net.refractions.udig.ui.graphics.TableSettings;
import net.refractions.udig.ui.graphics.TableUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.PaletteType;
import org.geotools.brewer.color.SampleScheme;
import org.geotools.brewer.color.StyleGenerator;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.filter.function.StandardDeviationFunction;
import org.geotools.filter.function.UniqueIntervalFunction;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.util.NullProgressListener;
import org.geotools.util.ProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class StyleThemePage
extends StyleEditorPage {
    private static final int COMBO_ATTRIBUTES = 1;
    static final int COMBO_CLASSES = 2;
    static final int COMBO_BREAKTYPE = 3;
    private static final int COMBO_NORMALIZE = 4;
    private static final int COMBO_ELSE = 5;
    static final int COMBO_PALETTES = 6;
    private static final int COMBO_OPACITY = 7;
    private static final int COMBO_BORDER_COLOR = 8;
    private static final int LABEL_SEPARATOR_BOTTOM = 12;
    private static final int LABEL_STATUSBAR = 13;
    private static final int LABEL_ICON_COLORBLIND = 14;
    private static final int LABEL_ICON_PHOTOCOPY = 15;
    private static final int LABEL_ICON_PROJECTOR = 16;
    private static final int LABEL_ICON_LCD = 17;
    private static final int LABEL_ICON_CRT = 18;
    private static final int LABEL_ICON_PRINT = 19;
    static final int BUTTON_COLORBLIND = 20;
    static final int BUTTON_PHOTOCOPY = 21;
    static final int BUTTON_PROJECTOR = 22;
    static final int BUTTON_LCD = 23;
    static final int BUTTON_CRT = 24;
    static final int BUTTON_PRINT = 25;
    private static final int BUTTON_REMOVE = 26;
    private static final int COMPOSITE_PARENT = 30;
    private static final int COMPOSITE_TOP = 31;
    private static final int COMPOSITE_MIDDLE = 32;
    private static final int COMPOSITE_BOTTOM = 33;
    private static final int COMPOSITE_BOTTOM_LEFT = 34;
    private static final String BORDER_COLOR_KEY = "theme_page_border_color";
    private static final String OPACITY_KEY = "theme_page_opacity";
    private static final String ATTRIBUTE_KEY = "theme_page_attribute";
    private static final String CLASSES_KEY = "theme_page_classes";
    private static final String BREAK_KEY = "theme_page_break";
    private static final String NORMALIZE_KEY = "theme_page_normalize";
    private static final String ELSE_KEY = "theme_page_else";
    private static final String PALETTE_CATEGORY_KEY = "theme_page_palette_category";
    private static final String COLOR_BLIND_KEY = "theme_page_color_blind";
    private static final String CRT_KEY = "theme_page_crt";
    private static final String PROJECTOR_KEY = "theme_page_projector";
    private static final String LCD_KEY = "theme_page_lcd";
    private static final String PRINT_KEY = "theme_page_print";
    private static final String PHOTO_COPY_KEY = "theme_page_copy";
    private static final String PALETTE_KEY = "theme_page_palette";
    private static final String CUSTOM_PALETTE = "custom_palette_key";
    private HashMap<Integer, Control> pageControls = new HashMap();
    private List<String> numericAttr = new ArrayList<String>();
    private double[] opacity;
    private HashMap<Integer, String> controlNames = new HashMap();
    private HashMap<Integer, Integer> viewerQuality = new HashMap();
    private HashMap<String, Integer> uniqueCounts = new HashMap();
    private ColorBrewer brewer;
    private boolean reverseColours = false;
    private StyleGenerator sg;
    private AttributeDescriptor selectedAttributeType;
    private AttributeDescriptor normalize;
    private ClassificationFunction function;
    private Classifier classifier;
    private TableSettings tableSettings;
    private boolean elseSelection = true;
    private FilterFactory2 ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    private FeatureCollection<SimpleFeatureType, SimpleFeature> collection;
    private FeatureSource<SimpleFeatureType, SimpleFeature> source;
    private StyleBuilder sb = new StyleBuilder((FilterFactory)this.ff);
    TableViewer paletteTable;
    TreeViewer treeViewer;
    BrewerPalette customPalette = null;
    Classifier customBreak = null;

    public StyleThemePage() {
        this.controlNames.put(14, Messages.StyleEditor_theme_suitability_colour);
        this.controlNames.put(18, Messages.StyleEditor_theme_suitability_crt);
        this.controlNames.put(17, Messages.StyleEditor_theme_suitability_lcd);
        this.controlNames.put(15, Messages.StyleEditor_theme_suitability_pcopy);
        this.controlNames.put(19, Messages.StyleEditor_theme_suitability_print);
        this.controlNames.put(16, Messages.StyleEditor_theme_suitability_proj);
        this.controlNames.put(20, Messages.StyleEditor_theme_suitability_colour);
        this.controlNames.put(24, Messages.StyleEditor_theme_suitability_crt);
        this.controlNames.put(23, Messages.StyleEditor_theme_suitability_lcd);
        this.controlNames.put(21, Messages.StyleEditor_theme_suitability_pcopy);
        this.controlNames.put(25, Messages.StyleEditor_theme_suitability_print);
        this.controlNames.put(22, Messages.StyleEditor_theme_suitability_proj);
        this.viewerQuality.put(0, 14);
        this.viewerQuality.put(4, 18);
        this.viewerQuality.put(3, 17);
        this.viewerQuality.put(1, 15);
        this.viewerQuality.put(5, 19);
        this.viewerQuality.put(2, 16);
    }

    public Button getButton(int widgetID) {
        return (Button)this.getControl(widgetID);
    }

    public Combo getCombo(int widgetID) {
        return (Combo)this.getControl(widgetID);
    }

    public Composite getComposite(int widgetID) {
        return (Composite)this.getControl(widgetID);
    }

    public Label getLabel(int widgetID) {
        return (Label)this.getControl(widgetID);
    }

    public GridData getLayoutData(int widgetID) {
        Object widget = this.getControl(widgetID);
        Object layout = null;
        if (widget instanceof Composite) {
            layout = ((Composite)widget).getLayoutData();
        }
        if (layout instanceof GridData) {
            return (GridData)layout;
        }
        return new GridData();
    }

    public Object getControl(int widgetID) {
        return this.pageControls.get(widgetID);
    }

    private boolean isNumber(String attributeType) {
        return this.numericAttr.contains(attributeType);
    }

    private boolean isNumber(AttributeDescriptor attributeType) {
        return Number.class.isAssignableFrom(attributeType.getType().getBinding());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean okToLeave() {
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performOk() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.collection = null;
        this.source = null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    public ColorBrewer getBrewer() {
        if (this.brewer == null) {
            CustomDynamicPalette.TABLE[] dynamicPalettes;
            this.createBrewer();
            List<BrewerPalette> palettesList = CustomPalettesLoader.PALETTESLIST;
            for (BrewerPalette brewerPalette : palettesList) {
                this.brewer.registerPalette(brewerPalette);
            }
            CustomDynamicPalette.TABLE[] tABLEArray = dynamicPalettes = CustomDynamicPalette.TABLE.values();
            int n = dynamicPalettes.length;
            int n2 = 0;
            while (n2 < n) {
                CustomDynamicPalette.TABLE colorTable = tABLEArray[n2];
                CustomDynamicPalette customDynamicPalette = new CustomDynamicPalette(colorTable);
                this.brewer.registerPalette((BrewerPalette)customDynamicPalette);
                ++n2;
            }
        }
        return this.brewer;
    }

    private void createToggleButton(Composite parent, int buttonId, Image image) {
        Button toggleButton = new Button(parent, 2);
        GridData gridData = new GridData(0, 0, false, false);
        toggleButton.setLayoutData((Object)gridData);
        toggleButton.setImage(image);
        toggleButton.setSelection(false);
        toggleButton.addSelectionListener((SelectionListener)new SuitabilityToggleListener(buttonId));
        this.pageControls.put(buttonId, (Control)toggleButton);
        this.updateToggleTooltip(buttonId);
    }

    private void updateToggleTooltip(int buttonId) {
        Button toggle = this.getButton(buttonId);
        String tooltip = toggle.getSelection() ? Messages.StyleEditor_theme_suitability_show : Messages.StyleEditor_theme_suitability_hide;
        toggle.setToolTipText(String.valueOf(tooltip) + " " + this.controlNames.get(buttonId));
    }

    private void createSuitabilityIcon(Composite parent, int id, String tooltip, Image image) {
        Label suitabilityIcon = new Label(parent, 0);
        GridData gridData = new GridData(0, 0, false, false);
        suitabilityIcon.setLayoutData((Object)gridData);
        suitabilityIcon.setImage(image);
        suitabilityIcon.setToolTipText(tooltip);
        this.pageControls.put(id, (Control)suitabilityIcon);
    }

    @Override
    public void createPageContent(Composite parent2) {
        Composite parent = new Composite(parent2, 0);
        parent.setLayout((Layout)new GridLayout());
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.heightHint = 500;
        parent.setLayoutData((Object)gridData2);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            this.source = (FeatureSource)this.getSelectedLayer().getResource(FeatureSource.class, (IProgressMonitor)monitor);
            if (this.source == null) {
                return;
            }
            this.collection = this.source.getFeatures();
        }
        catch (IOException e) {
            SLDPlugin.log("StyleThemePage.createPageContent() failed to create FeatureCollection", e);
            return;
        }
        this.pageControls.put(30, (Control)parent);
        Font font = this.getShell().getFont();
        this.createTopComponent(parent, font);
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 128, true, false);
        separator.setLayoutData((Object)gridData);
        separator.setFont(font);
        this.createPaletteChooserComposite(parent, font);
        separator = new Label(parent, 258);
        gridData = new GridData(4, 128, true, false);
        separator.setLayoutData((Object)gridData);
        separator.setVisible(false);
        separator.setFont(font);
        this.pageControls.put(12, (Control)separator);
        this.createPaletteEditorComposite(parent, font);
        Label status = new Label(parent, 0);
        gridData = new GridData(4, 1024, true, false);
        status.setLayoutData((Object)gridData);
        status.setVisible(true);
        status.setFont(font);
        status.setText("");
        this.pageControls.put(13, (Control)status);
    }

    private Composite createPaletteEditorComposite(Composite parent, Font font) {
        Composite compBottom = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 0;
        compBottom.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compBottom.setLayout((Layout)layout);
        compBottom.setVisible(false);
        compBottom.setFont(font);
        this.pageControls.put(33, (Control)compBottom);
        Composite compBottomLeft = new Composite(compBottom, 0);
        compBottomLeft.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compBottomLeft.setLayout((Layout)layout);
        this.pageControls.put(34, (Control)compBottomLeft);
        Composite compBottomLeftButtons = new Composite(compBottomLeft, 0);
        compBottomLeftButtons.setLayoutData((Object)new GridData(16384, 4, false, false));
        layout = new GridLayout(4, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compBottomLeftButtons.setLayout((Layout)layout);
        this.createPaletteEditorControls(font, compBottomLeftButtons);
        this.createPaletteEditorTreeViewer(compBottomLeft, font);
        CellEditor[] editors = this.createCellEditors();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((StructuredSelection)event.getSelection()).isEmpty()) {
                    StyleThemePage.this.getButton(26).setEnabled(false);
                } else {
                    StyleThemePage.this.getButton(26).setEnabled(true);
                }
            }
        });
        this.treeViewer.setCellModifier((ICellModifier)new IPaletteCellEditor(this));
        this.treeViewer.setColumnProperties(new String[]{"colour", "title", "styleExpr"});
        this.treeViewer.setCellEditors(editors);
        Composite compBottomRight = new Composite(compBottom, 0);
        compBottomRight.setLayoutData((Object)new GridData(131072, 4, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compBottomRight.setLayout((Layout)layout);
        this.createSuitabilityDisplay(compBottomRight);
        return compBottom;
    }

    private void createSuitabilityDisplay(Composite compBottomRight) {
        Label labelSuitability = new Label(compBottomRight, 0);
        labelSuitability.setLayoutData((Object)new GridData(0, 0, false, false));
        labelSuitability.setText(Messages.StyleEditor_theme_suitability);
        Composite icons = new Composite(compBottomRight, 131072);
        icons.setLayoutData((Object)new GridData(131072, 0, false, false));
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        icons.setLayout((Layout)layout);
        this.createSuitabilityIcon(icons, 14, Messages.StyleEditor_theme_suitability_colour, SLDPlugin.getDefault().getImageDescriptor("eview16/colorblind_friendly_mode.gif").createImage());
        this.createSuitabilityIcon(icons, 18, Messages.StyleEditor_theme_suitability_crt, SLDPlugin.getDefault().getImageDescriptor("eview16/crt_friendly_mode.gif").createImage());
        this.createSuitabilityIcon(icons, 16, Messages.StyleEditor_theme_suitability_proj, SLDPlugin.getDefault().getImageDescriptor("eview16/projector_friendly_mode.gif").createImage());
        this.createSuitabilityIcon(icons, 17, Messages.StyleEditor_theme_suitability_lcd, SLDPlugin.getDefault().getImageDescriptor("eview16/laptop_friendly_mode.gif").createImage());
        this.createSuitabilityIcon(icons, 19, Messages.StyleEditor_theme_suitability_print, SLDPlugin.getDefault().getImageDescriptor("eview16/printer_friendly_mode.gif").createImage());
        this.createSuitabilityIcon(icons, 15, Messages.StyleEditor_theme_suitability_pcopy, SLDPlugin.getDefault().getImageDescriptor("eview16/photocopy_friendly_mode.gif").createImage());
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[3];
        ColorCellEditor celledit0 = new ColorCellEditor((Composite)this.treeViewer.getTree());
        TextCellEditor celledit1 = new TextCellEditor((Composite)this.treeViewer.getTree());
        TextCellEditor celledit2 = new TextCellEditor((Composite)this.treeViewer.getTree());
        editors[0] = celledit0;
        editors[1] = celledit1;
        editors[2] = celledit2;
        return editors;
    }

    private Tree createPaletteEditorTreeViewer(Composite compBottomLeft, Font font) {
        this.treeViewer = new TreeViewer(compBottomLeft, 68352);
        Tree treeTable = this.treeViewer.getTree();
        treeTable.setHeaderVisible(true);
        treeTable.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = compBottomLeft.getBounds().x;
        gridData.heightHint = compBottomLeft.getBounds().y;
        treeTable.setLayoutData((Object)gridData);
        TreeColumn colImage = new TreeColumn(treeTable, 16384);
        colImage.setText(Messages.StyleEditor_theme_column_colour);
        TreeColumn colTitle = new TreeColumn(treeTable, 16384);
        colTitle.setText(Messages.StyleEditor_theme_column_label);
        TreeColumn colExpr = new TreeColumn(treeTable, 16384);
        colExpr.setText(Messages.StyleEditor_theme_column_expression);
        treeTable.layout();
        this.tableSettings = new TableSettings(treeTable);
        this.tableSettings.setColumnMin(0, 40);
        this.tableSettings.setColumnMin(1, 100);
        this.tableSettings.setColumnMin(0, 50);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StyleTreeLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new StyleTreeSorter());
        this.treeViewer.setContentProvider((IContentProvider)new StyleTreeContentProvider());
        this.treeViewer.setInput((Object)this.getFTS());
        this.treeViewer.expandAll();
        Control treeControl = this.treeViewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        treeControl.setLayoutData((Object)gd);
        treeControl.setFont(font);
        treeControl.setVisible(false);
        return treeTable;
    }

    private void createPaletteEditorControls(Font font, Composite compBottomLeftButtons) {
        Composite combos = new Composite(compBottomLeftButtons, 0);
        combos.setLayout((Layout)new GridLayout(2, false));
        this.createOpacityControls(font, combos);
        this.createBorderControls(font, combos);
        this.createReverseButton(compBottomLeftButtons);
        this.createRemoveButton(compBottomLeftButtons);
    }

    private void createRemoveButton(Composite compBottomLeftButtons) {
        Button removeButton = new Button(compBottomLeftButtons, 131072);
        removeButton.setText(Messages.StyleEditor_theme_remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)StyleThemePage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Rule rule = (Rule)selection.getFirstElement();
                if (StyleThemePage.this.removeRule(rule)) {
                    StyleThemePage.this.treeViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.pageControls.put(26, (Control)removeButton);
    }

    private void createReverseButton(Composite compBottomLeftButtons) {
        Button reverseButton = new Button(compBottomLeftButtons, 131072);
        reverseButton.setText(Messages.StyleEditor_theme_reverse);
        reverseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyleThemePage.this.reverseColours = !StyleThemePage.this.reverseColours;
                FeatureTypeStyle fts = StyleThemePage.this.getFTS();
                List ruleList = fts.rules();
                int i = 0;
                while (i < ruleList.size() / 2) {
                    StyleThemePage.this.swapColours((Rule)ruleList.get(i), (Rule)ruleList.get(ruleList.size() - i - 1));
                    ++i;
                }
                StyleThemePage.this.treeViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createBorderControls(Font font, Composite compBottomLeftButtons) {
        Label opacityLabel = new Label(compBottomLeftButtons, 0);
        opacityLabel.setFont(font);
        opacityLabel.setText("Outline");
        GridData gridData = new GridData(16384, -1, false, false);
        opacityLabel.setLayoutData((Object)gridData);
        Combo colorCombo = new Combo(compBottomLeftButtons, 2056);
        this.pageControls.put(8, (Control)colorCombo);
        String[] items = BorderColorComboListener.Outline.labels();
        colorCombo.setItems(items);
        colorCombo.select(0);
        boolean polygonCompatible = this.isPolygonCompatible();
        colorCombo.setEnabled(polygonCompatible);
        if (polygonCompatible) {
            colorCombo.addSelectionListener((SelectionListener)new BorderColorComboListener(this));
        }
    }

    private boolean isPolygonCompatible() {
        Class type = this.getSelectedLayer().getSchema().getGeometryDescriptor().getType().getBinding();
        return !LineString.class.isAssignableFrom(type) && !MultiLineString.class.isAssignableFrom(type) && !LinearRing.class.isAssignableFrom(type);
    }

    private void createOpacityControls(Font font, Composite compBottomLeftButtons) {
        Label opacityLabel = new Label(compBottomLeftButtons, 0);
        opacityLabel.setFont(font);
        opacityLabel.setText(Messages.StyleEditor_theme_opacity);
        GridData gridData = new GridData(16384, -1, false, false);
        opacityLabel.setLayoutData((Object)gridData);
        Combo opacityCombo = new Combo(compBottomLeftButtons, 2056);
        this.pageControls.put(7, (Control)opacityCombo);
        this.opacity = new double[11];
        int i = 0;
        while (i < 11) {
            opacityCombo.add(String.valueOf(Integer.toString(i * 10)) + "%");
            this.opacity[i] = (double)i / 10.0;
            ++i;
        }
        opacityCombo.select(5);
        opacityCombo.setVisibleItemCount(8);
        opacityCombo.addSelectionListener((SelectionListener)new SimpleComboListener());
    }

    private Composite createPaletteChooserComposite(Composite parent, Font font) {
        Composite compMiddle = new Composite(parent, 0);
        compMiddle.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compMiddle.setLayout((Layout)layout);
        compMiddle.setFont(font);
        this.pageControls.put(32, (Control)compMiddle);
        Composite compMiddle2 = this.createPaletteLabel(font, compMiddle);
        Composite compMiddle3 = new Composite(compMiddle2, 0);
        compMiddle3.setLayoutData((Object)new GridData(131072, 0, true, false));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compMiddle3.setLayout((Layout)layout);
        this.createPaletteFilterComposite(font, compMiddle3);
        this.paletteTable = new TableViewer(new Table(compMiddle, 68096));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20, false));
        TableColumn firstColumn = new TableColumn(this.paletteTable.getTable(), 16384);
        firstColumn.setAlignment(16384);
        this.paletteTable.getTable().setLayout((Layout)tableLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        gridData.widthHint = 175;
        this.paletteTable.getControl().setLayoutData((Object)gridData);
        this.paletteTable.setLabelProvider((IBaseLabelProvider)new BrewerPaletteLabelProvider());
        this.paletteTable.setContentProvider((IContentProvider)new BrewerPaletteContentProvider(this));
        this.paletteTable.addFilter((ViewerFilter)new BrewerPaletteViewerFilter(this));
        this.paletteTable.setSorter((ViewerSorter)new BrewerPaletteViewerSorter());
        this.paletteTable.setInput((Object)this.getBrewer());
        this.paletteTable.addSelectionChangedListener((ISelectionChangedListener)new PalettesListener());
        return compMiddle;
    }

    private void createPaletteFilterComposite(Font font, Composite compMiddle3) {
        Label paletteFilterLabel = new Label(compMiddle3, 16384);
        paletteFilterLabel.setFont(font);
        paletteFilterLabel.setText(Messages.StyleEditor_theme_show);
        GridData gridData = new GridData(16384, 4, false, true);
        gridData.verticalSpan = 2;
        paletteFilterLabel.setLayoutData((Object)gridData);
        Combo paletteFilter = new Combo(compMiddle3, 2056);
        this.pageControls.put(6, (Control)paletteFilter);
        paletteFilter.add(Messages.StyleEditor_theme_palette_all, 0);
        paletteFilter.add(Messages.StyleEditor_theme_palette_num, 1);
        paletteFilter.add(Messages.StyleEditor_theme_palette_seq, 2);
        paletteFilter.add(Messages.StyleEditor_theme_palette_div, 3);
        paletteFilter.add(Messages.StyleEditor_theme_palette_cat, 4);
        paletteFilter.select(0);
        paletteFilter.setToolTipText(Messages.StyleEditor_theme_palette_tip);
        paletteFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyleThemePage.this.paletteTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite compMiddle4 = new Composite(compMiddle3, 0);
        compMiddle4.setLayoutData((Object)new GridData(131072, 0, true, false));
        GridLayout layout = new GridLayout(6, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        compMiddle4.setLayout((Layout)layout);
        this.createToggleButton(compMiddle4, 20, SLDPlugin.getDefault().getImageDescriptor("eview16/colorblind_friendly_mode.gif").createImage());
        this.createToggleButton(compMiddle4, 24, SLDPlugin.getDefault().getImageDescriptor("eview16/crt_friendly_mode.gif").createImage());
        this.createToggleButton(compMiddle4, 22, SLDPlugin.getDefault().getImageDescriptor("eview16/projector_friendly_mode.gif").createImage());
        this.createToggleButton(compMiddle4, 23, SLDPlugin.getDefault().getImageDescriptor("eview16/laptop_friendly_mode.gif").createImage());
        this.createToggleButton(compMiddle4, 25, SLDPlugin.getDefault().getImageDescriptor("eview16/printer_friendly_mode.gif").createImage());
        this.createToggleButton(compMiddle4, 21, SLDPlugin.getDefault().getImageDescriptor("eview16/photocopy_friendly_mode.gif").createImage());
    }

    private Composite createPaletteLabel(Font font, Composite compMiddle) {
        Composite compMiddle2 = new Composite(compMiddle, 0);
        compMiddle2.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compMiddle2.setLayout((Layout)layout);
        Label palettesLabel = new Label(compMiddle2, 16384);
        palettesLabel.setFont(font);
        palettesLabel.setText(Messages.StyleEditor_theme_palette);
        GridData gridData = new GridData(16384, 1024, true, false);
        palettesLabel.setLayoutData((Object)gridData);
        return compMiddle2;
    }

    private Composite createTopComponent(Composite parent, Font font) {
        Composite compTop = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, false);
        compTop.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compTop.setLayout((Layout)layout);
        compTop.setFont(font);
        this.pageControls.put(31, (Control)compTop);
        this.createAttributeLabels(font, compTop);
        this.createAttributeCombos(compTop);
        return compTop;
    }

    private void createAttributeLabels(Font font, Composite compTop) {
        Label attributesLabel = new Label(compTop, 0);
        attributesLabel.setFont(font);
        attributesLabel.setText(Messages.StyleEditor_theme_attribute);
        attributesLabel.setLayoutData((Object)this.createDefaultGridData());
        Label classesLabel = new Label(compTop, 0);
        classesLabel.setFont(font);
        classesLabel.setText(Messages.StyleEditor_theme_classes);
        classesLabel.setLayoutData((Object)this.createDefaultGridData());
        Label breaksLabel = new Label(compTop, 0);
        breaksLabel.setFont(font);
        breaksLabel.setText(Messages.StyleEditor_theme_break);
        breaksLabel.setLayoutData((Object)this.createDefaultGridData());
        Label normalizeLabel = new Label(compTop, 16384);
        normalizeLabel.setFont(font);
        normalizeLabel.setText(Messages.StyleEditor_theme_normalize);
        normalizeLabel.setLayoutData((Object)this.createDefaultGridData());
        Label elseLabel = new Label(compTop, 16384);
        elseLabel.setFont(font);
        elseLabel.setText(Messages.StyleEditor_theme_else);
        elseLabel.setLayoutData((Object)this.createDefaultGridData());
    }

    private GridData createDefaultGridData() {
        return new GridData(16384, -1, true, false);
    }

    private void createAttributeCombos(Composite compTop) {
        Combo attributeCombo = new Combo(compTop, 2056);
        this.pageControls.put(1, (Control)attributeCombo);
        attributeCombo.setLayout((Layout)new GridLayout());
        GridData gridData = this.createDefaultGridData();
        attributeCombo.setLayoutData((Object)gridData);
        StyleLayer selectedLayer = this.getSelectedLayer();
        if (selectedLayer != null) {
            this.loadWithAttributeTypes(attributeCombo, selectedLayer);
        }
        attributeCombo.setVisibleItemCount(16);
        attributeCombo.addListener(24, (Listener)new AttributeComboListener());
        Combo classesCombo = new Combo(compTop, 2048);
        this.pageControls.put(2, (Control)classesCombo);
        classesCombo.setLayout((Layout)new GridLayout(1, false));
        gridData = this.createDefaultGridData();
        classesCombo.setLayoutData((Object)gridData);
        int i = 2;
        while (i < 13) {
            Integer j = i;
            classesCombo.add(j.toString());
            ++i;
        }
        classesCombo.select(3);
        classesCombo.setVisibleItemCount(16);
        classesCombo.addListener(24, (Listener)new ClassesComboListener());
        Combo breaksCombo = new Combo(compTop, 2056);
        this.pageControls.put(3, (Control)breaksCombo);
        breaksCombo.setLayout((Layout)new GridLayout(1, false));
        gridData = this.createDefaultGridData();
        breaksCombo.setLayoutData((Object)gridData);
        this.updateBreaks();
        breaksCombo.addSelectionListener((SelectionListener)new SimpleComboListener());
        Combo normalizeCombo = new Combo(compTop, 2056);
        this.pageControls.put(4, (Control)normalizeCombo);
        gridData = this.createDefaultGridData();
        normalizeCombo.setLayoutData((Object)gridData);
        this.updateNormalize();
        normalizeCombo.setToolTipText(Messages.StyleEditor_theme_normalize_tip);
        normalizeCombo.setVisibleItemCount(10);
        normalizeCombo.addSelectionListener((SelectionListener)new SimpleComboListener());
        Combo elseCombo = new Combo(compTop, 2056);
        this.pageControls.put(5, (Control)elseCombo);
        elseCombo.setLayout((Layout)new GridLayout(1, false));
        gridData = this.createDefaultGridData();
        elseCombo.setLayoutData((Object)gridData);
        elseCombo.add(Messages.StyleEditor_theme_else_hide);
        elseCombo.add(Messages.StyleEditor_theme_else_min);
        elseCombo.add(Messages.StyleEditor_theme_else_max);
        elseCombo.select(0);
        elseCombo.setToolTipText(Messages.StyleEditor_theme_else_tip);
        elseCombo.addSelectionListener((SelectionListener)new ElseComboListener());
    }

    private void loadWithAttributeTypes(Combo attributeCombo, StyleLayer selectedLayer) {
        SimpleFeatureType featureType = selectedLayer.getSchema();
        if (featureType != null) {
            int i = 0;
            while (i < featureType.getAttributeCount()) {
                AttributeDescriptor attributeType = featureType.getDescriptor(i);
                if (!(attributeType instanceof GeometryDescriptor)) {
                    attributeCombo.add(attributeType.getName().getLocalPart());
                    if (this.isNumber(attributeType)) {
                        this.numericAttr.add(attributeType.getName().getLocalPart());
                    }
                }
                ++i;
            }
            int index = -1;
            if (this.numericAttr.size() > 1) {
                index = this.numericAttr.get(0).equalsIgnoreCase("id") ? attributeCombo.indexOf(this.numericAttr.get(1)) : attributeCombo.indexOf(this.numericAttr.get(0));
            } else if (this.numericAttr.size() == 1) {
                index = attributeCombo.indexOf(this.numericAttr.get(0));
            }
            if (index > -1) {
                attributeCombo.select(index);
            }
            if (attributeCombo.getSelectionIndex() == -1 && featureType.getAttributeCount() > 0) {
                attributeCombo.select(0);
            }
        }
    }

    private boolean removeRule(Rule rule) {
        Style style = this.getStyle();
        FeatureTypeStyle[] featureTypeStyles = style.getFeatureTypeStyles();
        if (featureTypeStyles == null) {
            return false;
        }
        int i = 0;
        while (i < featureTypeStyles.length) {
            boolean removed;
            FeatureTypeStyle featureTypeStyle = featureTypeStyles[i];
            if (featureTypeStyle != null && (removed = featureTypeStyle.rules().remove(rule))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void styleChanged(Object source) {
    }

    private void swapColours(Rule rule1, Rule rule2) {
        Symbolizer[] symb2;
        Symbolizer[] symb1 = rule1.getSymbolizers();
        if (symb1.length != (symb2 = rule2.getSymbolizers()).length) {
            SLDPlugin.log("StyleThemePage.swapColours(): Number of symbolizers each rule and not equal - aborting colour swap", null);
            return;
        }
        int i = 0;
        while (i < symb1.length) {
            Expression tempColour;
            if (symb1[i] instanceof PolygonSymbolizer) {
                tempColour = ((PolygonSymbolizer)symb1[i]).getFill().getColor();
                ((PolygonSymbolizer)symb1[i]).getFill().setColor(((PolygonSymbolizer)symb2[i]).getFill().getColor());
                ((PolygonSymbolizer)symb2[i]).getFill().setColor(tempColour);
            } else if (symb1[i] instanceof PointSymbolizer) {
                tempColour = ((PointSymbolizer)symb1[i]).getGraphic().getMarks()[0].getFill().getColor();
                ((PointSymbolizer)symb1[i]).getGraphic().getMarks()[0].getFill().setColor(((PointSymbolizer)symb2[i]).getGraphic().getMarks()[0].getFill().getColor());
                ((PointSymbolizer)symb2[i]).getGraphic().getMarks()[0].getFill().setColor(tempColour);
            } else if (symb1[i] instanceof LineSymbolizer) {
                tempColour = ((LineSymbolizer)symb1[i]).getStroke().getColor();
                ((LineSymbolizer)symb1[i]).getStroke().setColor(((LineSymbolizer)symb2[i]).getStroke().getColor());
                ((LineSymbolizer)symb2[i]).getStroke().setColor(tempColour);
            }
            ++i;
        }
    }

    public void setStatusText(String text) {
        this.getLabel(13).setText(text);
    }

    @Override
    public String getLabel() {
        return null;
    }

    private void updatePalettes() {
        this.paletteTable.setInput((Object)this.getBrewer());
    }

    private void updateBreaks() {
        Combo breaksCombo = this.getCombo(3);
        String currentAttr = this.getCombo(1).getText();
        String value = breaksCombo.getText();
        breaksCombo.removeAll();
        if (this.isNumber(currentAttr)) {
            breaksCombo.add(Messages.StyleEditor_theme_equalInterval);
            breaksCombo.add(Messages.StyleEditor_theme_quantile);
            breaksCombo.add(Messages.StyleEditor_theme_uniques);
            int index = breaksCombo.indexOf(value);
            if (index > -1) {
                breaksCombo.select(index);
            } else {
                breaksCombo.select(1);
            }
        } else {
            breaksCombo.add(Messages.StyleEditor_theme_uniques);
            int index = breaksCombo.indexOf(value);
            if (index > -1) {
                breaksCombo.select(index);
            } else {
                breaksCombo.select(0);
            }
        }
    }

    private void updateNormalize() {
        Combo normalizeCombo = this.getCombo(4);
        String value = normalizeCombo.getText();
        String currentAttr = this.getCombo(1).getText();
        normalizeCombo.removeAll();
        normalizeCombo.add(Messages.StyleEditor_theme_none);
        if (this.isNumber(currentAttr)) {
            normalizeCombo.setEnabled(true);
            int i = 0;
            while (i < this.numericAttr.size()) {
                String attr = this.numericAttr.get(i);
                if (!currentAttr.equals(attr)) {
                    normalizeCombo.add(attr);
                }
                ++i;
            }
            int index = normalizeCombo.indexOf(value);
            if (index > 1) {
                normalizeCombo.select(index);
            } else {
                normalizeCombo.select(0);
            }
        } else {
            normalizeCombo.select(0);
            normalizeCombo.setEnabled(false);
        }
    }

    boolean inputsValid() {
        if (this.getCombo(1).getText().length() < 1) {
            return false;
        }
        if (this.paletteTable.getSelection().isEmpty()) {
            return false;
        }
        return this.getCombo(2).getText().length() >= 1;
    }

    void generateTheme() {
        this.customPalette = null;
        if (this.selectedAttributeType == null) {
            this.selectedAttributeType = this.getAttributeType(this.getCombo(1).getText());
        }
        this.normalize = this.getCombo(4).getSelectionIndex() == 0 ? null : this.getAttributeType(this.getCombo(4).getText());
        Runnable genDefault = new Runnable(){

            @Override
            public void run() {
                PropertyName expr = null;
                PropertyName attr = StyleThemePage.this.ff.property(StyleThemePage.this.selectedAttributeType.getName());
                if (StyleThemePage.this.normalize != null) {
                    Divide divide = StyleThemePage.this.ff.divide((Expression)attr, (Expression)StyleThemePage.this.ff.property(StyleThemePage.this.normalize.getName()));
                    expr = divide;
                } else {
                    expr = attr;
                }
                StructuredSelection structuredSelection = (StructuredSelection)StyleThemePage.this.paletteTable.getSelection();
                BrewerPalette pal = (BrewerPalette)structuredSelection.getFirstElement();
                if (pal == null) {
                    StyleBlackboard bb = StyleThemePage.this.getSelectedLayer().getStyleBlackboard();
                    IMemento memento = (IMemento)bb.get("net.refractions.udig.style.dialogSettings");
                    String paletteName = memento.getString(StyleThemePage.PALETTE_KEY);
                    pal = StyleThemePage.this.getBrewer().getPalette(paletteName);
                }
                String paletteName = pal.getName();
                Combo combo = StyleThemePage.this.getCombo(2);
                int numClasses = new Integer(combo.getText());
                int[] suitability = null;
                try {
                    suitability = pal.getPaletteSuitability().getSuitability(numClasses);
                }
                catch (Exception exception) {
                    suitability = CustomUnknownPaletteSuitability.getInstance().getSuitability(numClasses);
                }
                if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_custom)) {
                    StyleThemePage.this.classifier = StyleThemePage.this.customBreak;
                }
                boolean classifierModified = false;
                if (StyleThemePage.this.classifier == null) {
                    classifierModified = true;
                } else {
                    if (StyleThemePage.this.function.getClasses() != new Integer(StyleThemePage.this.getCombo(2).getText()).intValue()) {
                        if (StyleThemePage.this.getCombo(5).getSelectionIndex() == 0) {
                            classifierModified = true;
                        }
                        if (StyleThemePage.this.function.getClasses() != new Integer(StyleThemePage.this.getCombo(2).getText()) - 1) {
                            classifierModified = true;
                        }
                    }
                    if (StyleThemePage.this.getCombo(5).getSelectionIndex() > 0) {
                        classifierModified = true;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_custom)) {
                        classifierModified = true;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_equalInterval) && !(StyleThemePage.this.function instanceof EqualIntervalFunction)) {
                        classifierModified = true;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_quantile) && !(StyleThemePage.this.function instanceof QuantileFunction)) {
                        classifierModified = true;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_standardDeviation) && !(StyleThemePage.this.function instanceof StandardDeviationFunction)) {
                        classifierModified = true;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_uniques) && !(StyleThemePage.this.function instanceof UniqueIntervalFunction)) {
                        classifierModified = true;
                    } else if (!StyleThemePage.this.function.getExpression().equals(expr)) {
                        classifierModified = true;
                    }
                }
                String semanticTypeIdentifier = StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_uniques) ? "unique:" : (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_equalInterval) ? "equalinterval:" : (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_quantile) ? "quantile:" : (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase("standard deviation") ? "standarddeviation:" : (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_custom) ? "custom:" : "default:"))));
                semanticTypeIdentifier = semanticTypeIdentifier.concat(paletteName.toLowerCase());
                if (classifierModified) {
                    FunctionName fn = null;
                    boolean createClassifier = true;
                    if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_uniques)) {
                        fn = UniqueIntervalFunction.NAME;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_equalInterval)) {
                        fn = EqualIntervalFunction.NAME;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_quantile)) {
                        fn = QuantileFunction.NAME;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_standardDeviation)) {
                        fn = StandardDeviationFunction.NAME;
                    } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_custom)) {
                        StyleThemePage.this.classifier = StyleThemePage.this.customBreak;
                        createClassifier = false;
                    } else {
                        return;
                    }
                    if (createClassifier) {
                        StyleThemePage.this.function = (ClassificationFunction)StyleThemePage.this.ff.function(fn.getFunctionName(), new Expression[fn.getArgumentCount()]);
                        org.opengis.util.ProgressListener cancelProgress = ((StyleEditorDialog)StyleThemePage.this.getContainer()).getProgressListener();
                        StyleThemePage.this.function.setProgressListener((ProgressListener)cancelProgress);
                        numClasses = new Integer(StyleThemePage.this.getCombo(2).getText());
                        if (StyleThemePage.this.getCombo(5).getSelectionIndex() == 0) {
                            StyleThemePage.this.function.setClasses(numClasses);
                        } else {
                            StyleThemePage.this.function.setClasses(numClasses - 1);
                        }
                        StyleThemePage.this.function.getParameters().set(0, expr);
                        StyleThemePage.this.classifier = (Classifier)StyleThemePage.this.function.evaluate((Object)StyleThemePage.this.collection, Classifier.class);
                    }
                }
                BrewerPalette palette = StyleThemePage.this.getBrewer().getPalette(paletteName);
                Color[] colors = null;
                try {
                    colors = palette.getColors(numClasses);
                }
                catch (Exception exception) {
                    colors = palette.getColors();
                    palette = new CustomDynamicPalette(palette.getName(), palette.getDescription(), colors);
                    colors = palette.getColors(numClasses);
                }
                if (StyleThemePage.this.reverseColours) {
                    int i = 0;
                    while (i < colors.length / 2) {
                        Color tempColor = colors[i];
                        int j = colors.length - i - 1;
                        colors[i] = colors[j];
                        colors[j] = tempColor;
                        ++i;
                    }
                }
                int elsemode = -1;
                if (StyleThemePage.this.getCombo(5).getSelectionIndex() == 0) {
                    elsemode = 0;
                } else if (StyleThemePage.this.getCombo(5).getSelectionIndex() == 1) {
                    elsemode = 1;
                } else if (StyleThemePage.this.getCombo(5).getSelectionIndex() == 2) {
                    elsemode = 2;
                }
                int opacIndex = StyleThemePage.this.getCombo(7).getSelectionIndex();
                double opac = opacIndex > -1 ? StyleThemePage.this.opacity[opacIndex] : 1.0;
                Color borderColor = BorderColorComboListener.getBorder(StyleThemePage.this.getCombo(8));
                FeatureTypeStyle newFTS = null;
                try {
                    newFTS = StyleGenerator.createFeatureTypeStyle((Classifier)StyleThemePage.this.classifier, (Expression)expr, (Color[])colors, (String)semanticTypeIdentifier, (GeometryDescriptor)StyleThemePage.this.getSelectedLayer().getSchema().getGeometryDescriptor(), (int)elsemode, (double)opac, null);
                    StyleThemePage.this.applyExistingRulesProperties(newFTS, opac, borderColor);
                }
                catch (IllegalFilterException e) {
                    newFTS = null;
                    SLDPlugin.log("sg.createFeatureTypeStyle() failed", e);
                }
                catch (NullPointerException e) {
                    newFTS = null;
                    SLDPlugin.log("sg.createFeatureTypeStyle() failed", e);
                }
                if (newFTS == null) {
                    ErrorManager.get().displayError(Messages.StyleEditor_error, Messages.StyleEditor_theme_failure);
                    return;
                }
                newFTS.featureTypeNames().clear();
                newFTS.featureTypeNames().add(new NameImpl("Feature"));
                Style style = StyleThemePage.this.getStyle();
                if (style == null) {
                    throw new RuntimeException("Style is null");
                }
                Object sld = null;
                if (sld == null) {
                    SLDContent.createDefaultStyledLayerDescriptor(style);
                }
                try {
                    StyleThemePage.this.addThemedFTStoStyle(style, newFTS);
                }
                catch (Exception e) {
                    String msg = "addThemedFTStoStyle() failed";
                    SLDPlugin.log(msg, e);
                    ErrorManager.get().displayException((Throwable)e, msg, "net.refractions.udig.style.sld");
                    return;
                }
                if (suitability != null) {
                    StyleThemePage.this.updateSuitabilities(suitability);
                }
                StyleThemePage.this.treeViewer.setInput((Object)newFTS);
            }
        };
        try {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)genDefault);
        }
        catch (Exception e) {
            String msg = "Theme Generation Failed";
            SLDPlugin.log(msg, e);
            ErrorManager.get().displayException((Throwable)e, msg, "net.refractions.udig.style.sld");
        }
        this.displayBottomComposite();
        TableUtils.resizeColumns((Tree)this.treeViewer.getTree(), (TableSettings)this.tableSettings, (int)3);
        this.treeViewer.getControl().setVisible(true);
    }

    private void applyExistingRulesProperties(FeatureTypeStyle newFTS, double opac, Color borderColor) {
        block9: {
            Symbolizer symbolizer;
            block10: {
                Style style = this.getStyle();
                Symbolizer[] symbolizers = SLDs.symbolizers((Style)style);
                if (symbolizers.length <= 0) break block9;
                symbolizer = symbolizers[0];
                if (!(symbolizer instanceof PointSymbolizer)) break block10;
                PointSymbolizer previousSymbolizer = (PointSymbolizer)symbolizer;
                Graphic oldGraphic = SLDs.graphic((PointSymbolizer)previousSymbolizer);
                Mark oldMark = SLDs.mark((PointSymbolizer)previousSymbolizer);
                if (oldMark == null) break block9;
                List rules = newFTS.rules();
                block0: for (Rule rule : rules) {
                    String[] colors = SLDs.colors((Rule)rule);
                    Color fill = SLDs.toColor((String)colors[0]);
                    List newSymbolizers = rule.symbolizers();
                    for (Symbolizer newSymbolizer : newSymbolizers) {
                        if (!(newSymbolizer instanceof PointSymbolizer)) continue;
                        PointSymbolizer newPointSymbolizer = (PointSymbolizer)newSymbolizer;
                        Mark mark = this.sb.createMark((String)oldMark.getWellKnownName().evaluate(null, String.class));
                        Fill newFill = this.sb.createFill(fill);
                        newFill.setOpacity((Expression)this.ff.literal(opac));
                        mark.setFill((org.opengis.style.Fill)newFill);
                        Stroke newStroke = oldMark.getStroke();
                        if (newStroke != null) {
                            if (borderColor != null) {
                                newStroke.setColor((Expression)this.ff.literal((Object)borderColor));
                                mark.setStroke((org.opengis.style.Stroke)newStroke);
                            } else {
                                mark.setStroke(null);
                            }
                        }
                        Graphic newGraphic = SLDs.graphic((PointSymbolizer)newPointSymbolizer);
                        newGraphic.setSize(oldGraphic.getSize());
                        newGraphic.setRotation(oldGraphic.getRotation());
                        newGraphic.graphicalSymbols().clear();
                        newGraphic.graphicalSymbols().add(mark);
                        continue block0;
                    }
                }
                break block9;
            }
            if (symbolizer instanceof PolygonSymbolizer) {
                List rules = newFTS.rules();
                for (Rule rule : rules) {
                    List newSymbolizers = rule.symbolizers();
                    for (Symbolizer newSymbolizer : newSymbolizers) {
                        if (!(newSymbolizer instanceof PolygonSymbolizer)) continue;
                        PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)newSymbolizer;
                        Fill previousFill = SLDs.fill((PolygonSymbolizer)polygonSymbolizer);
                        previousFill.setOpacity((Expression)this.ff.literal(opac));
                        Stroke stroke = SLDs.stroke((PolygonSymbolizer)polygonSymbolizer);
                        if (stroke == null) continue;
                        if (borderColor != null) {
                            stroke.setColor((Expression)this.ff.literal((Object)borderColor));
                            continue;
                        }
                        polygonSymbolizer.setStroke(null);
                    }
                }
            }
        }
    }

    FeatureTypeStyle getFTS() {
        Style style = this.getStyle();
        List featureTypeStyles = style.featureTypeStyles();
        for (FeatureTypeStyle featureTypeStyle : featureTypeStyles) {
            if (!SLDs.isSemanticTypeMatch((FeatureTypeStyle)featureTypeStyle, (String)"colorbrewer:.*")) continue;
            return featureTypeStyle;
        }
        return null;
    }

    private void addThemedFTStoStyle(Style style, FeatureTypeStyle fts) {
        HashSet symbs = new HashSet();
        Rule[] newRules = fts.getRules();
        int i = 0;
        while (i < newRules.length) {
            Symbolizer[] newSymbs = newRules[i].getSymbolizers();
            int j = 0;
            while (j < newSymbs.length) {
                symbs.add(newSymbs[j].getClass());
                ++j;
            }
            ++i;
        }
        Object[] FTSs = style.getFeatureTypeStyles();
        boolean found = false;
        int i2 = 0;
        while (i2 < FTSs.length) {
            if (SLDs.isSemanticTypeMatch((FeatureTypeStyle)FTSs[i2], (String)"colorbrewer:.*")) {
                FTSs[i2] = fts;
                found = true;
            } else {
                Rule[] rule = FTSs[i2].getRules();
                int j = 0;
                while (j < rule.length) {
                    Symbolizer[] symb = rule[j].getSymbolizers();
                    Object[] newSymb = (Symbolizer[])symb.clone();
                    int deletedElements = 0;
                    int k = 0;
                    while (k < symb.length) {
                        if (symbs.contains(symb[k].getClass())) {
                            Object[] temp = this.removeElement(newSymb, k - deletedElements);
                            if (temp.length > 0) {
                                newSymb = new Symbolizer[temp.length];
                                int l = 0;
                                while (l < temp.length) {
                                    newSymb[l] = (Symbolizer)temp[l];
                                    ++l;
                                }
                            } else {
                                newSymb = new Symbolizer[]{};
                            }
                            ++deletedElements;
                        }
                        ++k;
                    }
                    if (deletedElements > 0) {
                        rule[j].setSymbolizers((Symbolizer[])newSymb);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < FTSs.length) {
            boolean changed = false;
            Object[] rule = FTSs[i2].getRules();
            int j = 0;
            while (j < rule.length) {
                if (rule[j].getSymbolizers().length == 0) {
                    if (rule.length > 1) {
                        Object[] temp = this.removeElement(rule, j);
                        rule = new Rule[temp.length];
                        int k = 0;
                        while (k < temp.length) {
                            rule[k] = (Rule)temp[k];
                            ++k;
                        }
                    } else {
                        rule = new Rule[]{};
                    }
                    changed = true;
                    --j;
                }
                ++j;
            }
            if (changed) {
                FTSs[i2].setRules((Rule[])rule);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < FTSs.length) {
            if (FTSs[i2].getRules().length == 0) {
                Object[] temp = this.removeElement(FTSs, i2);
                FTSs = new FeatureTypeStyle[temp.length];
                int j = 0;
                while (j < temp.length) {
                    FTSs[j] = (FeatureTypeStyle)temp[j];
                    ++j;
                }
            }
            ++i2;
        }
        if (!found) {
            FeatureTypeStyle[] newFTSList = new FeatureTypeStyle[FTSs.length + 1];
            newFTSList[0] = fts;
            System.arraycopy(FTSs, 0, newFTSList, 1, FTSs.length);
            style.setFeatureTypeStyles(newFTSList);
        } else {
            style.setFeatureTypeStyles((FeatureTypeStyle[])FTSs);
        }
    }

    private Object[] removeElement(Object[] array, int indexToRemove) {
        if (array.length == 1) {
            return new Object[0];
        }
        Object[] newArray = new Object[array.length - 1];
        if (indexToRemove > 0) {
            System.arraycopy(array, 0, newArray, 0, indexToRemove);
        }
        if (indexToRemove < array.length - 1) {
            System.arraycopy(array, indexToRemove + 1, newArray, indexToRemove, array.length - indexToRemove - 1);
        }
        return newArray;
    }

    private AttributeDescriptor getAttributeType(String attributeTypeName) {
        SimpleFeatureType featureType = this.getSelectedLayer().getSchema();
        int i = 0;
        while (i < featureType.getAttributeCount()) {
            AttributeDescriptor attributeType = featureType.getDescriptor(i);
            if (attributeType.getName().getLocalPart().equals(attributeTypeName)) {
                return attributeType;
            }
            ++i;
        }
        return null;
    }

    private void createBrewer() {
        this.brewer = PlatformGIS.getColorBrewer();
    }

    private void displayBottomComposite() {
        Object layout = this.paletteTable.getControl().getLayoutData();
        if (layout instanceof GridData) {
            GridData gd = (GridData)layout;
            gd.grabExcessVerticalSpace = false;
            gd.heightHint = 70;
        }
        this.getLabel(12).setVisible(true);
        this.getLayoutData((int)32).grabExcessVerticalSpace = false;
        this.getComposite(33).setVisible(true);
        this.getLayoutData((int)33).grabExcessVerticalSpace = true;
        this.getLayoutData((int)34).grabExcessVerticalSpace = true;
        this.getComposite(32).layout();
        this.getComposite(33).layout();
        this.getComposite(30).layout();
    }

    private void updateSuitabilities(int[] suitability) {
        for (Integer key : this.viewerQuality.keySet()) {
            int icon = this.viewerQuality.get(key);
            int quality = suitability[key];
            String viewer = String.valueOf(Messages.StyleEditor_theme_suitability_visiblefor) + " " + this.controlNames.get(icon) + " ";
            Label label = this.getLabel(icon);
            if (quality == 3) {
                label.setImage(this.getImageWithOverlay(icon, null));
                label.setToolTipText(String.valueOf(viewer) + Messages.StyleEditor_theme_suitability_good);
                continue;
            }
            if (quality == 1) {
                this.getLabel(icon).setImage(this.getImageWithOverlay(icon, SLDPlugin.getDefault().getImageDescriptor("ovr16/doubtful_ovr.gif")));
                label.setToolTipText(String.valueOf(viewer) + Messages.StyleEditor_theme_suitability_doubtful);
                continue;
            }
            if (quality == 0) {
                this.getLabel(icon).setImage(this.getImageWithOverlay(icon, SLDPlugin.getDefault().getImageDescriptor("ovr16/bad_ovr.gif")));
                label.setToolTipText(String.valueOf(viewer) + Messages.StyleEditor_theme_suitability_bad);
                continue;
            }
            this.getLabel(icon).setImage(this.getImageWithOverlay(icon, SLDPlugin.getDefault().getImageDescriptor("ovr16/unknown_ovr.gif")));
            label.setToolTipText(String.valueOf(viewer) + Messages.StyleEditor_theme_suitability_unknown);
        }
    }

    private Image getImageWithOverlay(int iconLabelID, ImageDescriptor overlay) {
        ImageDescriptor descriptor = null;
        Image base = null;
        if (iconLabelID == 14) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/colorblind_friendly_mode.gif");
        } else if (iconLabelID == 18) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/crt_friendly_mode.gif");
        } else if (iconLabelID == 17) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/laptop_friendly_mode.gif");
        } else if (iconLabelID == 15) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/photocopy_friendly_mode.gif");
        } else if (iconLabelID == 19) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/printer_friendly_mode.gif");
        } else if (iconLabelID == 16) {
            descriptor = SLDPlugin.getDefault().getImageDescriptor("eview16/projector_friendly_mode.gif");
        }
        if (descriptor != null) {
            base = descriptor.createImage();
        }
        if (overlay == null) {
            return base;
        }
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[2] = overlay;
        DecoratorOverlayIcon ovrIcon = new DecoratorOverlayIcon(base, imageDescriptorArray);
        return ovrIcon.createImage();
    }

    @Override
    public void gotFocus() {
        StyleBlackboard bb = this.getSelectedLayer().getStyleBlackboard();
        IMemento memento = (IMemento)bb.get("net.refractions.udig.style.dialogSettings");
        if (memento != null) {
            this.setComboSelectionInt(memento, 7, OPACITY_KEY);
            this.setComboSelectionString(memento, 1, ATTRIBUTE_KEY);
            this.setComboSelectionInt(memento, 2, CLASSES_KEY);
            this.setComboSelectionString(memento, 3, BREAK_KEY);
            this.setComboSelectionString(memento, 4, NORMALIZE_KEY);
            this.setComboSelectionString(memento, 5, ELSE_KEY);
            this.setComboSelectionString(memento, 6, PALETTE_CATEGORY_KEY);
            this.setButtonSelection(memento, 20, COLOR_BLIND_KEY);
            this.setButtonSelection(memento, 24, CRT_KEY);
            this.setButtonSelection(memento, 23, LCD_KEY);
            this.setButtonSelection(memento, 21, PHOTO_COPY_KEY);
            this.setButtonSelection(memento, 25, PRINT_KEY);
            this.setButtonSelection(memento, 22, PROJECTOR_KEY);
            this.setOutine(memento);
            this.setPaletteSelection(memento);
            this.readCustomPalette(memento);
            this.readCustomBreak(memento);
            this.generateTheme();
        }
    }

    private void setOutine(IMemento memento) {
        String string = memento.getString(BORDER_COLOR_KEY);
        if (string == null) {
            return;
        }
        String[] parts = string.split("-");
        if (parts.length != 3) {
            return;
        }
        int red = Integer.parseInt(parts[0]);
        int green = Integer.parseInt(parts[1]);
        int blue = Integer.parseInt(parts[2]);
        Combo combo = this.getCombo(8);
        if (red == 0 && blue == 0 && green == 0) {
            combo.select(BorderColorComboListener.Outline.BLACK.ordinal());
        } else if (red == 255 && blue == 255 && green == 255) {
            combo.select(BorderColorComboListener.Outline.WHITE.ordinal());
        } else {
            combo.select(BorderColorComboListener.Outline.CUSTOM.ordinal());
            combo.setData((Object)new RGB(red, green, blue));
        }
    }

    private void readCustomBreak(IMemento memento) {
    }

    private void readCustomPalette(IMemento memento) {
        ArrayList<Color> colors = new ArrayList<Color>();
        int index = 1;
        while (memento.getInteger(CUSTOM_PALETTE + index) != null) {
            int rgb = memento.getInteger(CUSTOM_PALETTE + index);
            colors.add(new Color(rgb));
            ++index;
        }
        if (colors.isEmpty()) {
            return;
        }
        if (this.getBrewer().hasPalette(Messages.StyleEditor_theme_custom)) {
            this.customPalette = this.getBrewer().getPalette(Messages.StyleEditor_theme_custom);
            this.customPalette.setColors(colors.toArray(new Color[0]));
        } else {
            this.customPalette = new BrewerPalette();
            PaletteSuitability suitability = new PaletteSuitability();
            SampleScheme newScheme = new SampleScheme();
            String unknown = "?";
            int i = 0;
            while (i < colors.size()) {
                if (i > 0) {
                    int[] scheme = new int[i + 1];
                    int j = 0;
                    while (j < i + 1) {
                        scheme[j] = j;
                        ++j;
                    }
                    try {
                        newScheme.setSampleScheme(i + 1, scheme);
                        suitability.setSuitability(i + 1, new String[]{unknown, unknown, unknown, unknown, unknown, unknown});
                    }
                    catch (Exception exception) {
                        suitability = CustomUnknownPaletteSuitability.getInstance();
                        newScheme = new CustomSampleScheme(colors.size());
                    }
                }
                ++i;
            }
            this.customPalette.setPaletteSuitability(suitability);
            this.customPalette.setColors(colors.toArray(new Color[0]));
            this.customPalette.setColorScheme(newScheme);
            this.customPalette.setName(Messages.StyleEditor_theme_custom);
            this.customPalette.setDescription(Messages.StyleEditor_theme_custom_desc);
            this.customPalette.setType(new PaletteType());
            if (!this.getBrewer().hasPalette(Messages.StyleEditor_theme_custom)) {
                this.getBrewer().registerPalette(this.customPalette);
            }
        }
        this.paletteTable.setInput((Object)this.getBrewer());
        String paletteName = memento.getString(PALETTE_KEY);
        if (paletteName.equals(this.customPalette.getName())) {
            this.paletteTable.setSelection((ISelection)new StructuredSelection((Object)this.customPalette));
        }
    }

    private void setPaletteSelection(IMemento memento) {
        String paletteName = memento.getString(PALETTE_KEY);
        if (paletteName != null) {
            BrewerPalette[] palettes;
            BrewerPalette[] brewerPaletteArray = palettes = this.brewer.getPalettes();
            int n = palettes.length;
            int n2 = 0;
            while (n2 < n) {
                BrewerPalette brewerPalette = brewerPaletteArray[n2];
                String currentName = brewerPalette.getName();
                if (currentName.equals(paletteName)) {
                    StructuredSelection selection = new StructuredSelection((Object)brewerPalette);
                    this.paletteTable.setSelection((ISelection)selection, true);
                    return;
                }
                ++n2;
            }
        }
    }

    private void setButtonSelection(IMemento memento, int widgetID, String mementoKey) {
        if (memento.getInteger(mementoKey) != null) {
            Button button = this.getButton(widgetID);
            boolean selected = memento.getInteger(mementoKey) > 0;
            button.setSelection(selected);
        }
    }

    private void setComboSelectionString(IMemento memento, int widgetId, String key) {
        Combo control = this.getCombo(widgetId);
        if (memento.getString(key) != null) {
            String string = memento.getString(key);
            String[] items = control.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(string)) {
                    control.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void setComboSelectionInt(IMemento memento, int widgetId, String key) {
        Combo control = this.getCombo(widgetId);
        if (memento.getInteger(key) != null) {
            Integer integer = memento.getInteger(key);
            control.select(integer.intValue());
        }
    }

    @Override
    public boolean performApply() {
        StyleBlackboard bb = this.getSelectedLayer().getStyleBlackboard();
        IMemento memento = (IMemento)bb.get("net.refractions.udig.style.dialogSettings");
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)"ThemeingData");
        }
        this.putIntFromCombo(memento, OPACITY_KEY, 7);
        this.putStringFromCombo(memento, ATTRIBUTE_KEY, 1);
        this.putIntFromCombo(memento, CLASSES_KEY, 2);
        this.putStringFromCombo(memento, BREAK_KEY, 3);
        this.putStringFromCombo(memento, NORMALIZE_KEY, 4);
        memento.putInteger(ELSE_KEY, this.getCombo(5).getSelectionIndex());
        this.putStringFromCombo(memento, PALETTE_CATEGORY_KEY, 6);
        this.putButton(memento, 20, COLOR_BLIND_KEY);
        this.putButton(memento, 24, CRT_KEY);
        this.putButton(memento, 22, PROJECTOR_KEY);
        this.putButton(memento, 23, LCD_KEY);
        this.putButton(memento, 25, PRINT_KEY);
        this.putButton(memento, 21, PHOTO_COPY_KEY);
        this.storeOutline(memento);
        this.storePalette(memento);
        this.storeCustomPalette(memento);
        this.storeCustomBreak(memento);
        bb.put("net.refractions.udig.style.dialogSettings", (Object)memento);
        return true;
    }

    private void storeOutline(IMemento memento) {
        Combo combo = this.getCombo(8);
        BorderColorComboListener.Outline outline = BorderColorComboListener.Outline.values()[combo.getSelectionIndex()];
        RGB rgb = null;
        switch (outline) {
            case BLACK: {
                rgb = new RGB(0, 0, 0);
                break;
            }
            case WHITE: {
                rgb = new RGB(255, 255, 255);
                break;
            }
            case CUSTOM: {
                rgb = (RGB)combo.getData();
                break;
            }
            default: {
                memento.putString(BORDER_COLOR_KEY, "");
                return;
            }
        }
        String sep = "-";
        String stringVal = String.valueOf(rgb.red) + sep + rgb.green + sep + rgb.blue;
        memento.putString(BORDER_COLOR_KEY, stringVal);
    }

    private void storeCustomBreak(IMemento memento) {
    }

    private void storeCustomPalette(IMemento memento) {
        if (this.customPalette != null) {
            Color[] colors = this.customPalette.getColors();
            int index = 1;
            Color[] colorArray = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                int rgb = color.getRGB();
                memento.putInteger(CUSTOM_PALETTE + index, rgb);
                ++index;
                ++n2;
            }
        }
    }

    private void storePalette(IMemento memento) {
        ISelection selection = this.paletteTable.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            BrewerPalette palette = (BrewerPalette)structuredSelection.getFirstElement();
            memento.putString(PALETTE_KEY, palette.getName());
        }
    }

    private void putButton(IMemento memento, int buttonId, String key) {
        boolean selection = this.getButton(buttonId).getSelection();
        memento.putInteger(key, selection ? 1 : 0);
    }

    private void putStringFromCombo(IMemento memento, String key, int comboID) {
        Combo combo = this.getCombo(comboID);
        int index = combo.getSelectionIndex();
        memento.putString(key, combo.getItem(index));
    }

    private void putIntFromCombo(IMemento memento, String key, int comboID) {
        memento.putInteger(key, this.getCombo(comboID).getSelectionIndex());
    }

    @Override
    public void refresh() {
    }

    private class AttributeComboListener
    implements Listener {
        private AttributeComboListener() {
        }

        public void handleEvent(Event e) {
            StyleThemePage.this.selectedAttributeType = StyleThemePage.this.getAttributeType(StyleThemePage.this.getCombo(1).getText());
            StyleThemePage.this.updateNormalize();
            StyleThemePage.this.updateBreaks();
            if (StyleThemePage.this.isNumber(StyleThemePage.this.selectedAttributeType)) {
                StyleThemePage.this.setStatusText("");
            } else if (StyleThemePage.this.getCombo(3).getText().equalsIgnoreCase(Messages.StyleEditor_theme_uniques)) {
                String attribute = StyleThemePage.this.selectedAttributeType.getName().getLocalPart();
                if (StyleThemePage.this.uniqueCounts.containsKey(attribute)) {
                    this.updateUnique(attribute, (Integer)StyleThemePage.this.uniqueCounts.get(attribute));
                }
                int uniqueCount = -1;
                try {
                    PropertyName attr = StyleThemePage.this.ff.property(attribute);
                    UniqueVisitor uniques = new UniqueVisitor((Expression)attr);
                    NullProgressListener progress = new NullProgressListener();
                    StyleThemePage.this.collection.accepts((FeatureVisitor)uniques, (org.opengis.util.ProgressListener)progress);
                    uniqueCount = uniques.getUnique().size();
                }
                catch (IOException e1) {
                    SLDPlugin.log("unique values calculation failed", e1);
                }
                if (uniqueCount > -1) {
                    this.updateUnique(attribute, uniqueCount);
                }
            } else {
                StyleThemePage.this.setStatusText("");
            }
            if (StyleThemePage.this.inputsValid()) {
                StyleThemePage.this.generateTheme();
            }
        }

        private void updateUnique(String attr, int uniqueCount) {
            StyleThemePage.this.setStatusText(MessageFormat.format(Messages.StyleEditor_theme_unique_values, uniqueCount, attr));
            if (uniqueCount < 12) {
                if (StyleThemePage.this.getCombo(5).getSelectionIndex() > 0) {
                    StyleThemePage.this.getCombo(2).select(uniqueCount - 1);
                } else {
                    StyleThemePage.this.getCombo(2).select(uniqueCount - 2);
                }
            } else if (uniqueCount == 12) {
                StyleThemePage.this.getCombo(2).select(10);
            }
        }
    }

    private class ClassesComboListener
    implements Listener {
        private ClassesComboListener() {
        }

        public void handleEvent(Event event) {
            StyleThemePage.this.updatePalettes();
            if (StyleThemePage.this.inputsValid()) {
                StyleThemePage.this.generateTheme();
            }
        }
    }

    private class ElseComboListener
    implements SelectionListener {
        private ElseComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = StyleThemePage.this.getCombo(5).getSelectionIndex();
            int classesIndex = StyleThemePage.this.getCombo(2).getSelectionIndex();
            if (StyleThemePage.this.elseSelection && index == 0) {
                if (classesIndex > 0) {
                    StyleThemePage.this.getCombo(2).select(classesIndex - 1);
                }
            } else if (!StyleThemePage.this.elseSelection && index != 0 && classesIndex < StyleThemePage.this.getCombo(2).getItemCount() - 1) {
                StyleThemePage.this.getCombo(2).select(classesIndex + 1);
            }
            StyleThemePage.this.elseSelection = index > 0;
            if (StyleThemePage.this.inputsValid()) {
                StyleThemePage.this.generateTheme();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class PalettesListener
    implements ISelectionChangedListener {
        private PalettesListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (StyleThemePage.this.inputsValid()) {
                StyleThemePage.this.generateTheme();
            }
        }
    }

    private class SimpleComboListener
    implements SelectionListener {
        private SimpleComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (StyleThemePage.this.inputsValid()) {
                StyleThemePage.this.generateTheme();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class SuitabilityToggleListener
    implements SelectionListener {
        private int id;

        public SuitabilityToggleListener(int id) {
            this.id = id;
        }

        public void widgetSelected(SelectionEvent e) {
            StyleThemePage.this.updateToggleTooltip(this.id);
            StyleThemePage.this.updatePalettes();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

