/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.sld.editor.EditorNode;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

final class StyleEditorPageExtensionProcessor
implements ExtensionPointProcessor {
    private final EditorPageManager[] manager;
    private ILayer selectedLayer;

    StyleEditorPageExtensionProcessor(EditorPageManager[] manager, ILayer selectedLayer) {
        this.selectedLayer = selectedLayer;
        this.manager = manager;
    }

    public void process(IExtension extension, IConfigurationElement element) throws Exception {
        boolean classMissing;
        EditorNode node = null;
        boolean labelMissing = element.getAttribute("label") == null;
        String id = element.getAttribute("id");
        String requires = element.getAttribute("requires");
        boolean bl = classMissing = this.manager[0].getClassValue(element, "class") == null;
        if (!labelMissing && id != null && !classMissing) {
            node = new EditorNode(id, element);
        }
        if (node == null) {
            return;
        }
        if (requires != null && !EditorPageManager.meetsRequirement(this.selectedLayer, id, element, node)) {
            return;
        }
        this.manager[0].registerNode(node);
        String category = node.getCategory();
        if (category == null) {
            this.manager[0].addToRoot(node);
        } else {
            EditorNode parent = null;
            for (EditorNode pNode : this.manager[0].getElements(1)) {
                if (!category.equals(pNode.getId())) continue;
                parent = pNode;
                break;
            }
            if (parent == null) {
                this.manager[0].addToRoot(node);
            } else {
                parent.add(node);
            }
        }
    }
}

