/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.IStyleEditorPageContainer;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import net.refractions.udig.style.sld.editor.StyleEditorButtonListener;
import net.refractions.udig.style.sld.editor.internal.FilteredEditorDialog;
import net.refractions.udig.style.sld.editor.internal.IEditorNode;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

public class StyleEditorDialog
extends FilteredEditorDialog
implements IStyleEditorPageContainer {
    public static final int IMPORT_ID = 32;
    public static final int EXPORT_ID = 33;
    public static final int APPLY_ID = 34;
    public static final int REVERT_ID = 35;
    public static final int DEFAULTS_ID = 36;
    public static final int OK_ID = 37;
    public static final int CANCEL_ID = 38;
    StyleLayer selectedLayer;

    public ProgressListener getProgressListener() {
        NullProgressListener cancelProgress = new NullProgressListener();
        return cancelProgress;
    }

    public static final StyleEditorDialog createDialogOn(Shell shell, String pageId, Layer selectedLayer, EditorPageManager manager) {
        Object parentShell = shell;
        if (parentShell == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            parentShell = workbenchWindow != null ? workbenchWindow.getShell() : null;
        }
        StyleEditorDialog dialog = new StyleEditorDialog((Shell)parentShell, manager);
        dialog.setSelectedNode(pageId);
        dialog.setSelectedLayer(selectedLayer);
        dialog.create();
        dialog.getShell().setText(Messages.StyleEditor_name);
        dialog.filteredTree.getFilterCombo().setEnabled(true);
        if (pageId != null) {
            dialog.findNodeMatching(pageId);
        }
        return dialog;
    }

    protected StyleEditorDialog(Shell parentShell, EditorPageManager manager) {
        super(parentShell, manager);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(66800);
    }

    public void setSelectedLayer(Layer layer) {
        if (this.selectedLayer == null && layer == null) {
            return;
        }
        if (layer != null && layer.equals(this.selectedLayer)) {
            return;
        }
        this.selectedLayer = layer == null ? null : new StyleLayer(layer);
    }

    @Override
    public StyleLayer getSelectedLayer() {
        return this.selectedLayer;
    }

    @Override
    public Style getStyle() {
        Object styleObject;
        if (this.selectedLayer != null && (styleObject = this.selectedLayer.getStyleBlackboard().get("net.refractions.udig.style.sld")) instanceof Style) {
            return (Style)styleObject;
        }
        return null;
    }

    @Override
    public void setStyle(Style newStyle) {
        StyleBlackboard styleBlackboard = this.selectedLayer.getStyleBlackboard();
        styleBlackboard.put("net.refractions.udig.style.sld", (Object)newStyle);
        styleBlackboard.setSelected(new String[]{"net.refractions.udig.style.sld"});
    }

    private StyledLayerDescriptor getSLD(Style style) {
        if (style != null) {
            StyledLayerDescriptor sld = null;
            if (sld == null) {
                sld = SLDContent.createDefaultStyledLayerDescriptor(style);
            }
            return sld;
        }
        return null;
    }

    @Override
    public StyledLayerDescriptor getSLD() {
        Style style = this.getStyle();
        return this.getSLD(style);
    }

    @Override
    public boolean showPage(IEditorNode node) {
        return super.showPage(node);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.addImportExportButtons(composite);
        this.addOkCancelRevertApplyButtons(parent, composite);
        return composite;
    }

    private void addOkCancelRevertApplyButtons(Composite parent, Composite composite) {
        Composite compRight = new Composite(composite, 0);
        GridLayout layout = new GridLayout(0, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compRight.setLayout((Layout)layout);
        GridData data = new GridData(0x1000008, 0x1000000, true, false);
        compRight.setLayoutData((Object)data);
        compRight.setFont(parent.getFont());
        Button defaultsButton = this.createButton(compRight, 36, Messages.StyleEditorDialog_defaults, false);
        defaultsButton.setEnabled(true);
        defaultsButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        Button revertButton = this.createButton(compRight, 35, Messages.StyleEditor_revert, false);
        revertButton.setEnabled(false);
        revertButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        Button applyButton = this.createButton(compRight, 34, Messages.StyleEditor_apply, false);
        applyButton.setEnabled(false);
        applyButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        new Label(compRight, 0);
        Button closeButton = this.createButton(compRight, 38, IDialogConstants.CANCEL_LABEL, false);
        closeButton.setEnabled(true);
        closeButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        Button okButton = this.createButton(compRight, 37, IDialogConstants.OK_LABEL, false);
        okButton.setEnabled(true);
        okButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        layout.numColumns = 3;
    }

    private void addImportExportButtons(Composite composite) {
        Composite compLeft = new Composite(composite, 0);
        GridLayout layout = new GridLayout(0, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compLeft.setLayout((Layout)layout);
        compLeft.setLayoutData((Object)new GridData(16384, 1024, false, false));
        Button importButton = this.createButton(compLeft, 32, Messages.StyleEditor_import, false);
        importButton.setEnabled(false);
        importButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
        Button exportButton = this.createButton(compLeft, 33, Messages.StyleEditor_export, false);
        exportButton.setEnabled(false);
        exportButton.addListener(13, (Listener)new StyleEditorButtonListener(this));
    }

    @Override
    public void updateButtons() {
        this.getButton(32).setEnabled(true);
        this.getButton(33).setEnabled(true);
        this.getButton(34).setEnabled(true);
        this.getButton(35).setEnabled(true);
        this.getButton(37).setEnabled(true);
        this.getButton(38).setEnabled(true);
    }

    @Override
    public void setExitButtonState() {
        this.getButton(34).setEnabled(true);
    }

    @Override
    public IAction getApplyAction() {
        final Button applyButton = this.getButton(34);
        return new Action(){

            public void setText(String text) {
                applyButton.setText(text);
            }

            public String getText() {
                return applyButton.getText();
            }

            public void setToolTipText(String toolTipText) {
                applyButton.setToolTipText(toolTipText);
            }

            public String getToolTipText() {
                return applyButton.getToolTipText();
            }

            public void setEnabled(boolean enabled) {
                applyButton.setEnabled(enabled);
            }

            public void run() {
                Event event = new Event();
                event.display = applyButton.getDisplay();
                event.button = 1;
                event.widget = applyButton;
                applyButton.notifyListeners(13, event);
            }

            public void setChecked(boolean checked) {
                applyButton.setSelection(checked);
            }
        };
    }
}

