/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.EditorNode;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

final class StyleConfiguratorExtensionProcessor
implements ExtensionPointProcessor {
    private final EditorPageManager[] manager;
    private ILayer selectedLayer;

    StyleConfiguratorExtensionProcessor(EditorPageManager[] manager, ILayer selectedLayer) {
        this.manager = manager;
        this.selectedLayer = selectedLayer;
    }

    public void process(IExtension extension, IConfigurationElement element) throws Exception {
        boolean classMissing;
        EditorNode node = null;
        String id = element.getAttribute("id");
        String label = element.getAttribute("label");
        String requires = element.getAttribute("requires");
        boolean bl = classMissing = this.manager[0].getClassValue(element, "class") == null;
        if (label == null) {
            SLDPlugin.trace("StyleConfigurator extension point attribute 'label' not specified -- instance ignored: " + element.getClass(), null);
            return;
        }
        if (id == null) {
            SLDPlugin.trace("StyleConfigurator extension point attribute 'id' not specified -- skipped", null);
            return;
        }
        if (classMissing) {
            SLDPlugin.trace("StyleConfigurator extension point class could not be found: " + element.getClass(), null);
            return;
        }
        if (this.manager[0].hasNode(id)) {
            SLDPlugin.trace("Duplicate id found -- skipping '" + id + "' with label '" + label + "'", null);
            return;
        }
        node = new EditorNode(id, element);
        if (node == null) {
            SLDPlugin.log("EditorNode creation failed in OpenStyleEditorAction", null);
            return;
        }
        if (requires != null && !EditorPageManager.meetsRequirement(this.selectedLayer, id, element, node)) {
            return;
        }
        this.manager[0].registerNode(node);
        String category = node.getCategory();
        if (category == null) {
            this.manager[0].addToRoot(node);
        } else {
            EditorNode parent = null;
            for (EditorNode pNode : this.manager[0].getElements(1)) {
                if (!category.equals(pNode.getId())) continue;
                parent = pNode;
                break;
            }
            if (parent == null) {
                this.manager[0].addToRoot(node);
            } else {
                parent.add(node);
            }
        }
    }
}

